/* Copyright (c) 2006-2008, Maros Barabas
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of the Vrije Universiteit nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/* Argos log definitions */

#ifdef TARGET_X86_64
#define INCIDENT_MODEL          "INSERT INTO argos.incidents (version, arch, type, timestamp, eflags, faultyEIP) VALUES "\
                                "('0x%02x', '%s', '%s', '%s', '0x%16x', '0x%16llx');"
#else

#define INCIDENT_MODEL          "INSERT INTO argos.incidents (version, arch, type, timestamp, eflags, faultyEIP) VALUES "\
                                "('0x%02x', '%s', '%s', '%s', '0x%08x', '0x%08x');"
#endif

#define MEMBLOCKS_MODEL         "INSERT INTO argos.memoryblocks (id_incident, version, tainted, size, memphysical, memvirtual, data) VALUES "\
                                "(%d, '0x%02x', %s, %u, '0x%08x', '0x%08x', '%s');"
#define REGISTERS_MODEL         "INSERT INTO argos.registers (id_incident, id_register, value, memoryfromaddr, netidx, tainted) VALUES "\
                                "(%d, %d, '0x%08x', '0x%08x', %d, %s);"
#define EXPLOIT_MEMBLOCKS_MODEL "INSERT INTO argos.exploitmemoryblocks (id_incident, memblocksize, memblockdata) VALUES "\
                                "(%d, %d, '%s');"

#define EXPLOIT_PACKET_MODEL    "INSERT INTO argos.exploitpackets (id_incident, packetsize, packetdata) VALUES "\
                                "(%d, %d, '%s');"

#define NETTRACKER_GET_MODEL    "SELECT id, length, data FROM argos.nettracker;"
#define NETTRACKER_DEL_MODEL    "DELETE FROM argos.nettracker WHERE id <= %s;"
/* Nettracker definitions */

#define NETTRACKER_MODEL "INSERT INTO argos.nettracker (length, data) VALUES (%d, '%s');"

/* Connection definitions */

#define APSQL_HOST      "127.0.0.1"
#define APSQL_PORT      "5432"
#define APSQL_DB        "aips3"
#define APSQL_LOGIN     "argos"
#define APSQL_PASSWD    "LV8=15m2&_bj_1"

#define NETTRACKER_CLEAR  "DELETE FROM argos.nettracker;"
