﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TrafficMicroSimulator
{
    [Serializable]
    public class CrossingSegmentInfo
    {
        public double TOfMyCrossing { get; set; }
        public LaneSegment CrossingSegment { get; set; }
        public double TOfCrossingSegment { get; set; }
        public bool Processed { get; set; }
        public EPriority Priority { get; set; }
        public bool IsJoin
        {
            get
            {
                return ((TOfMyCrossing == 0.0 && TOfCrossingSegment == 1.0) ||
                        (TOfMyCrossing == 1.0 && TOfCrossingSegment == 0.0));
            }
        }
        public bool IsCross
        {
            get
            {
                return (TOfMyCrossing != 0.0 && TOfMyCrossing != 1.0 &&
                    TOfCrossingSegment != 0.0 && TOfCrossingSegment != 1.0);
            }
        }
        public bool IsSplit
        {
            get
            {
                return !IsJoin && !IsCross;
            }
        }
        public double MinPriority = -1.0;
        public double MaxPriority = 1.0;
    }
}
