﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TrafficMicroSimulator
{
    /// <summary>
    /// Implements generator as exponential generator
    /// </summary>
    [Serializable]
    class ExponentialGenerator : Generator
    {
        /// <summary>
        /// A parameter of distribution
        /// </summary>
        protected TimeSpan A;

        /// <summary>
        /// Random generator
        /// </summary>
        protected Random random;
        
        /// <summary>
        /// Initialize exponential generator
        /// </summary>
        /// <param name="connectedCell">Cell which is generator connected to</param>
        /// <param name="A">A parameter of exponential distribution in Timespan type</param>
        public ExponentialGenerator(Cell connectedCell, TimeSpan A)
            : base(connectedCell)
        {
            this.A = A;
            random = new Random(((int)DateTime.Now.Ticks & 0x0000FFFF) + GetHashCode());
        }

        public ExponentialGenerator(LaneSegment nearestLaneSegment, TimeSpan A)
            :base(nearestLaneSegment)
        {
            this.A = A;
            random = new Random(((int)DateTime.Now.Ticks & 0x0000FFFF) + GetHashCode());
        }

        /// <summary>
        /// Computes next interval using inverse function of exponential function
        /// </summary>
        /// <returns>Next interval</returns>
        protected override TimeSpan GetNextInterval()
        {
            return TimeSpan.FromMilliseconds(-A.TotalMilliseconds * Math.Log(1.0 - random.NextDouble()));
        }
    }
}
