﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TrafficMicroSimulator
{
    /// <summary>
    /// Implements generator as deterministic generator
    /// </summary>
    [Serializable]
    public class DeterministicGenerator : Generator
    {
        /// <summary>
        /// Generator interval
        /// </summary>
        protected TimeSpan interval;
        
        /// <summary>
        /// Initialize deterministic generator
        /// </summary>
        /// <param name="connectedCell">Cell which is generator connected to</param>
        /// <param name="interval">Generation interval</param>
        public DeterministicGenerator(Cell connectedCell, TimeSpan interval)
            : base(connectedCell)
        {
            this.interval = interval;
        }

        public DeterministicGenerator(LaneSegment nearestLaneSegment, TimeSpan interval)
        :base(nearestLaneSegment)
        {
            this.interval = interval;
        }

        /// <summary>
        /// Returns deterministic interval set in constructor
        /// </summary>
        /// <returns>Deterministic interval</returns>
        protected override TimeSpan GetNextInterval()
        {
            return interval;
        }
    }
}
