﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;
using System.Windows;

namespace TrafficMicroSimulator
{
    /// <summary>
    /// Converter based on the ferguson curves
    /// </summary>
    class ZoomConverter : IValueConverter
    {
        Point P0 = new Point(0.0, 0.1);
        Point P1 = new Point(2.5, 1.0);
        Point V0 = new Point(6.0, 0.0);
        Point V1 = new Point(1.2, 0.8);
        Point P2 = new Point(2.5, 1.0);
        Point P3 = new Point(10.0, 1000.0);
        Point V2 = new Point(0.5, 5);
        Point V3 = new Point(0.0, 3100.0);

        double eps = 0.000001;            

        public object Convert(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            if ((double)value <= 0.1)
                return 0.0;
            else if ((double)value == 1.0)
                return 2.5;
            else if ((double)value >= 1000.0)
                return 10.0;
            //assign value t to 0.5
            double t = 0.5;
            //number to add or subtract to t
            double toAddOrSubtract = 0.25;
            //determine which part of curve to search
            Point p0, p1, v0, v1;
            if ((double)value < 1)
            {   //lower part 0-1
                p0 = P0;
                p1 = P1;
                v0 = V0;
                v1 = V1;
            }
            else
            {   //higher part 1-10
                p0 = P2;
                p1 = P3;
                v0 = V2;
                v1 = V3;
            }
            //result point
            Point point = new Point();
            //coefficients
            double f1, f2, f3, f4;
            //search for linear number
            do
            {
                //compute coefficients
                f1 = F1(t);
                f2 = F2(t);
                f3 = F3(t);
                f4 = F4(t);
                //compute Y result
                point.Y = p0.Y * f1 + p1.Y * f2 + v0.Y * f3 + v1.Y * f4;
                //adjust t
                if ((double)value > point.Y)
                    t += toAddOrSubtract;
                else
                    t -= toAddOrSubtract;
                toAddOrSubtract /= 2;
            } while (Math.Abs((double)value - point.Y) > eps);//end if we are too close
            //return X value
            return Math.Round(p0.X * f1 + p1.X * f2 + v0.X * f3 + v1.X * f4, 3);
        }

        public object ConvertBack(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            if ((double)value <= 0.0)
                return 0.1;
            else if ((double)value == 2.5)
                return 1.0;
            else if ((double)value >= 10.0)
                return 1000.0;
            //assign value t to 0.5
            double t = 0.5;
            //number to add or subtract to t
            double toAddOrSubtract = 0.25;
            //determine which part of curve to search
            Point p0, p1, v0, v1;
            if ((double)value < 2.5)
            {   //lower part 0-5
                p0 = P0;
                p1 = P1;
                v0 = V0;
                v1 = V1;
            }
            else
            {   //higher part 5-10
                p0 = P2;
                p1 = P3;
                v0 = V2;
                v1 = V3;
            }
            //result point
            Point point = new Point();
            //coefficients
            double f1, f2, f3, f4;
            //search for linear number
            do
            {
                //compute coefficients
                f1 = F1(t);
                f2 = F2(t);
                f3 = F3(t);
                f4 = F4(t);
                //compute X result
                point.X = p0.X * f1 + p1.X * f2 + v0.X * f3 + v1.X * f4;
                //adjust t
                if ((double)value > point.X)
                    t += toAddOrSubtract;
                else
                    t -= toAddOrSubtract;
                toAddOrSubtract /= 2;
            } while (Math.Abs((double)value - point.X) > eps);//end if we are too close
            //return Y value
            double Yvalue = p0.Y * f1 + p1.Y * f2 + v0.Y * f3 + v1.Y * f4;
            return Yvalue;
        }



        protected double F1(double t)
        {
            return 2 * Math.Pow(t, 3) - 3 * Math.Pow(t, 2) + 1;
        }

        protected double F2(double t)
        {
            return -2 * Math.Pow(t, 3) + 3 * Math.Pow(t, 2);
        }

        protected double F3(double t)
        {
            return Math.Pow(t, 3) - 2 * Math.Pow(t, 2) + t;
        }

        protected double F4(double t)
        {
            return Math.Pow(t, 3) - Math.Pow(t, 2);
        }
    }
}
