﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;
using System.Resources;

namespace TrafficMicroSimulator
{
    class RoadShapeTypeValueConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            ResourceManager resourceManager = Properties.Resources.ResourceManager;
            string language = Properties.Settings.Default.Language;
            Dictionary<ERoadShapeType, string> GeneratorTypeFriendlyNames = new Dictionary<ERoadShapeType, string>
            {
                {ERoadShapeType.Straight, resourceManager.GetString("StraightShape", new CultureInfo(language))},
                {ERoadShapeType.Bezier, resourceManager.GetString("BezierShape", new CultureInfo(language))},
            };
            return GeneratorTypeFriendlyNames[(ERoadShapeType)value];
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null)
                return null;
            ResourceManager resourceManager = Properties.Resources.ResourceManager;
            string language = Properties.Settings.Default.Language;
            Dictionary<string, ERoadShapeType> GeneratorTypeEnumValues = new Dictionary<string, ERoadShapeType>
            {
                {resourceManager.GetString("StraightShape", new CultureInfo(language)), ERoadShapeType.Straight},
                {resourceManager.GetString("BezierShape", new CultureInfo(language)), ERoadShapeType.Bezier},
            };
            return GeneratorTypeEnumValues[(String)value];
        }
    }
}

