﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;

namespace TrafficMicroSimulator
{
    class RoadShapeTypeListProvider : IValueConverter
    {
        public object Convert
           (object value, Type targetType, object parameter, CultureInfo culture)
        {
            /* Note that this converter does not convert a value passed in. Instead, it generates
            * a list of user-friendly counterparts for each member of the target enum and
            * returns that list to the caller. */
            List<string> values = new List<string>();
            values.Add(Properties.Resources.ResourceManager.GetString("StraightShape", new CultureInfo(Properties.Settings.Default.Language)));
            values.Add(Properties.Resources.ResourceManager.GetString("BezierShape", new CultureInfo(Properties.Settings.Default.Language)));
            return values;
        }

        public object ConvertBack(object value, Type targetType, object parameter,
        CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
