﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;
using System.Resources;

namespace TrafficMicroSimulator
{
    class RoadConstructionStatusToLabelConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            ResourceManager resourceManager = Properties.Resources.ResourceManager;
            string language = Properties.Settings.Default.Language;
            Dictionary<ERoadContructionStatus, string> GeneratorTypeFriendlyNames = new Dictionary<ERoadContructionStatus, string>
            {
                {ERoadContructionStatus.NoConstruction, resourceManager.GetString("RoadStatusNoConstruction", new CultureInfo(language))},
                {ERoadContructionStatus.FirstPointPlaced, resourceManager.GetString("RoadStatusFirstPoint", new CultureInfo(language))},
                {ERoadContructionStatus.SecondPointPlaced, resourceManager.GetString("RoadStatusSecondPoint", new CultureInfo(language))},
                {ERoadContructionStatus.FirstControlPointPlaced, resourceManager.GetString("RoadStatusFirstControlPoint", new CultureInfo(language))},
                {ERoadContructionStatus.Editing, resourceManager.GetString("RoadStatusEditing", new CultureInfo(language))},
            };
            return GeneratorTypeFriendlyNames[(ERoadContructionStatus)value];
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new ApplicationException("Convert Back of RoadConstructionStatus called");
        }
    }
}
