﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;

namespace TrafficMicroSimulator
{
    class RoadConstructionModeToBoolConverter : IValueConverter
    {
        public object Convert(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            if ((ERoadConstructionMode)value == (ERoadConstructionMode)Enum.Parse(typeof(ERoadConstructionMode), (string)parameter))
                return true;
            return false;
        }

        public object ConvertBack(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            if ((bool)value)
                return Enum.Parse(targetType, parameter.ToString());
            return null;
        }
    }
}

