﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Data;
using System.Globalization;
using System.Resources;

namespace TrafficMicroSimulator
{
    class GeneratorTypeValueConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            ResourceManager resourceManager = Properties.Resources.ResourceManager;
            string language = Properties.Settings.Default.Language;
            Dictionary<EGeneratorType, string> GeneratorTypeFriendlyNames = new Dictionary<EGeneratorType, string>
            {
                {EGeneratorType.Deterministic, resourceManager.GetString("Deterministic", new CultureInfo(language))},
                {EGeneratorType.Exponential, resourceManager.GetString("Exponential", new CultureInfo(language))},
                {EGeneratorType.Gauss, resourceManager.GetString("Gauss", new CultureInfo(language))},
            };
            return GeneratorTypeFriendlyNames[(EGeneratorType)value];
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null)
                return null;
            ResourceManager resourceManager = Properties.Resources.ResourceManager;
            string language = Properties.Settings.Default.Language;
            Dictionary<string, EGeneratorType> GeneratorTypeEnumValues = new Dictionary<string, EGeneratorType>
            {
                {resourceManager.GetString("Deterministic", new CultureInfo(language)), EGeneratorType.Deterministic},
                {resourceManager.GetString("Exponential", new CultureInfo(language)), EGeneratorType.Exponential},
                {resourceManager.GetString("Gauss", new CultureInfo(language)), EGeneratorType.Gauss},
            };
            return GeneratorTypeEnumValues[(String)value];
        }
    }
}
