﻿using System;
using System.Windows.Media;
using System.Windows.Controls;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Windows.Controls.Primitives;
using System.Windows.Threading;

namespace TrafficMicroSimulator
{
    /// <summary>
    /// Canvas containing space for drawing
    /// </summary>
    class CanvasWorld : Canvas
    {
        /// <summary>
        /// Renderer instance which has method to render on canvas
        /// </summary>
        public Renderer renderer;

        /// <summary>
        /// Render World
        /// </summary>
        /// <param name="dc">Drawing context used to draw roads and vehicles</param>
        protected override void OnRender(DrawingContext dc)
        {
            base.OnRender(dc);
            if (renderer != null)
                //call window's render method to pass drawing context, width and height to renderer
                renderer.Render(dc, ActualWidth, ActualHeight);
        }
    }
}
