
#include "p.struct.h"

@begin
   header "struct.h";
@end

/*
 * methods of structure string_s
 */

/* 
 * methods of generated structures
 */

// -- bc_array_s --
@begin
   methods "bc_array_s";
@end

// -- bi_array_s --
@begin
   methods "bi_array_s";
@end

// -- ui_array_s --
@begin
   methods "ui_array_s";
@end

// -- bd_array_s --
@begin
   methods "bd_array_s";
@end

// -- string_array_s --
@begin
   methods "string_array_s";
@end

/*
 * finds index of string in array of strings via its length and data pointer
 */
unsigned string_array_s::get_idx_char_ptr(unsigned a_length,char *a_data)
{
   if (used == 0) return c_idx_not_exist;

   string_s *ptr = data;
   string_s *ptr_end = ptr + used;

   do {
      if (ptr->compare_char_ptr(a_length,a_data)) {
         return ptr - data;
      }
   } while(++ptr < ptr_end);

   return c_idx_not_exist;
}

// -- ui_arrays_s --
@begin
   methods "ui_arrays_s";
@end

// -- lalr_stack_element_s --
// -- symbol_s --
// -- sp_mcs_s --
@begin
   methods "lalr_stack_element_s";
@end

// -- lalr_stack_s --
// -- symbols_s --
// -- sp_mcs_array_s --
@begin
   methods "lalr_stack_s";
@end

/*
 * finds symbol via index of its name
 */

unsigned symbols_s::get_idx_by_ui_first(unsigned a_ui_first)
{
   if (used == 0) return c_idx_not_exist;

   symbol_s *ptr = data;
   symbol_s *ptr_end = ptr + used;

   do {
      if (ptr->ui_first == a_ui_first) {
         return ptr - data;
      }
   } while(++ptr < ptr_end);

   return c_idx_not_exist;
}

