
#ifndef __SCRIPT_PARSER_H
#define __SCRIPT_PARSER_H

#include "p.struct.h"
#include "p.image.h"

@begin
   header "struct.h";
   header "image.h";
@end

// -- constants and definitions --

/*
 * type of values (variables and constants), and also symbol index
 * of record of structures of this types
 */

enum {
   c_value_type_BLANK = 1,
   c_value_type_CHAR = 2,
   c_value_type_SHORT = 3,
   c_value_type_INT = 4,
   c_value_type_DOUBLE = 5,
   c_value_type_COLOR = 6,
   c_value_type_THREAD = 7,
   c_value_type_STRING = 8,
   c_value_type_LOCAL_IMG = 9,
   c_value_type_CHAR_ARRAY = 10,
   c_value_type_INT_ARRAY = 11,
   c_value_type_DOUBLE_ARRAY = 12,
   c_value_type_OBJ_ARRAY = 13,
   c_value_type_MUTEX = 14,
   c_value_type_CONDITION = 15,
   c_value_type_STRUCT_BASE = 16,
};

/*
 * modifiers of values 
 */

enum {
   c_value_modifier_NOTHING = 0x00,
   c_value_modifier_WRITABLE = 0x01,
   c_value_modifier_TMP = 0x02,
   c_value_modifier_INDEXED = 0x04,
};

/*
 * definition of access to data of various value types
 */

#define IM_ACCESS_CHAR_TRG(DATA) (*((char *)&(DATA)))
#define IM_ACCESS_SHORT_TRG(DATA) (*((short *)&(DATA)))
#define IM_ACCESS_INT_TRG(DATA) (*((int *)&(DATA)))
#define IM_ACCESS_DOUBLE_TRG(DATA) (*((double *)&(DATA)))
#define IM_ACCESS_COLOR_TRG(DATA) (*((unsigned long long *)&(DATA)))

#define IM_ACCESS_THREAD_TRG(DATA) (*((unsigned *)&(DATA)))
#define IM_ACCESS_THREAD_SRC(DATA) ((unsigned)(DATA))

#define IM_ACCESS_STRING_PTR(DATA) ((string_s *)(unsigned)(DATA))
#define IM_ACCESS_LOCAL_IMG_PTR(DATA) ((local_img_s *)(unsigned)(DATA))
#define IM_ACCESS_CHAR_ARRAY_PTR(DATA) ((bc_array_s *)(unsigned)(DATA))
#define IM_ACCESS_INT_ARRAY_PTR(DATA) ((bi_array_s *)(unsigned)(DATA))
#define IM_ACCESS_DOUBLE_ARRAY_PTR(DATA) ((bd_array_s *)(unsigned)(DATA))
#define IM_ACCESS_OBJ_ARRAY_PTR(DATA) ((ui_array_s *)(unsigned)(DATA))
#define IM_ACCESS_STRUCT_PTR(DATA) ((ui_array_s *)(unsigned)(DATA))

#define IM_ACCESS_MUTEX_TRG(DATA) (*((unsigned *)&(DATA)))
#define IM_ACCESS_MUTEX_SRC(DATA) ((unsigned)(DATA))

#define IM_ACCESS_COND_TRG(DATA) (*((unsigned *)&(DATA)))
#define IM_ACCESS_COND_SRC(DATA) ((unsigned)(DATA))

#define IM_ACCESS_DATA_PTR(PTR) ((unsigned long long)(unsigned)(PTR))

// -- constants and definitions --

/*
 * types of symbols contained in table of symbols
 */

const unsigned c_symbol_type_cnt = 5;
enum {
   c_symbol_type_structure,
   c_symbol_type_function,
   c_symbol_type_struct_variable,
   c_symbol_type_fun_param,
   c_symbol_type_local_variable,
};

/*
 * types of function parameter symbols
 */

enum {
   c_parm_symbol_type_copy,
   c_parm_symbol_type_ref,
};

/*
 * list of interpreter system constants
 */

const unsigned c_system_constant_cnt = 1;

enum {
   c_sc_SYSTEM_THREADS = 0,
};

/*
 * list of constants describing data type
 */

const unsigned c_type_constant_cnt = 15;

enum {
   c_tc_TYPE_BLANK = 0,
   c_tc_TYPE_CHAR,
   c_tc_TYPE_SHORT,
   c_tc_TYPE_INT,
   c_tc_TYPE_DOUBLE,
   c_tc_TYPE_COLOR,
   c_tc_TYPE_THREAD,
   c_tc_TYPE_STRING,
   c_tc_TYPE_LOCAL_IMG,
   c_tc_TYPE_CHAR_ARRAY,
   c_tc_TYPE_INT_ARRAY,
   c_tc_TYPE_DOUBLE_ARRAY,
   c_tc_TYPE_OBJ_ARRAY,
   c_tc_TYPE_MUTEX,
   c_tc_TYPE_CONDITION,
};

/*
 * list of thread function return values
 */

const unsigned c_thread_constant_cnt = 5;

enum {
   c_tc_THREAD_OK = 0,
   c_tc_THREAD_ERR_RESOURCES,
   c_tc_THREAD_ERR_SEARCH,
   c_tc_THREAD_ERR_INVAL,
   c_tc_THREAD_ERR_DEADLK,
};

/*
 * list of mutex function return values
 */

const unsigned c_mutex_constant_cnt = 5;

enum {
   c_mc_MUTEX_OK = 0,
   c_mc_MUTEX_ERR_DEADLK,
   c_mc_MUTEX_ERR_PERM,
   c_mc_MUTEX_ERR_UNLOCKED,
   c_mc_MUTEX_ERR_BUSY,
};

/*
 * list of condition function return values
 */

const unsigned  c_condition_constant_cnt = 3;

enum {
   c_cc_CONDITION_OK = 0,
   c_cc_CONDITION_ERR_TIMEDOUT,
   c_cc_CONDITION_ERR_UNKNOWN,
};

/*
 * values describing state of running thread
 */

enum {
   c_thread_state_JOINABLE,
   c_thread_state_JOINABLE_ENDED,
   c_thread_state_JOINED,
   c_thread_state_JOINED_ENDED,
   c_thread_state_DETACHED,
   c_thread_state_NOT_EXIST,
};

/*
 * instructions (commands) of generated code
 */

enum {
   i_flow_end,

   i_return,

   i_cmd_block_begin,
   i_cmd_block_end,

   i_false_jmp,
   i_true_jmp,
   i_jmp,
   i_local_cross_jmp,

   i_cmd_return,

   i_exp_end,

   i_this_var,
   i_param_var,
   i_local_var,
   i_global_var,

   i_this_call,
   i_global_call,

   i_s_element,
   i_s_method_call,

   i_new_object,
   i_this,
   i_thread,

   i_new_char_array,
   i_new_int_array,
   i_new_double_array,
   i_new_array,
   i_array_element,

   i_const,
};

/*
 * parse constants
 */
const unsigned c_rule_cnt = 150;
const unsigned rule_head_idxs[c_rule_cnt] = {86, 87, 87, 88, 88, 89, 89, 89, 90, 91, 92, 92, 93, 93, 94, 94, 95, 96, 97, 97, 98, 98, 99, 99, 100, 100, 101, 101, 102, 103, 103, 104, 104, 105, 106, 106, 107, 104, 108, 109, 110, 104, 111, 112, 104, 104, 104, 104, 113, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 117, 118, 118, 118, 119, 119, 119, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 122, 122, 123, 124, 124, 121, 121, 125, 126, 126, 127, 128, 128, 121, 121, 121, 129, 130, 130, 131, 131, 132, 132, 121, 121, 133, 133, 133, 133, 134, 134, 135, 135, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, };
const unsigned rule_body_lengths[c_rule_cnt] = {1, 2, 1, 2, 1, 1, 1, 1, 4, 2, 2, 1, 2, 1, 1, 3, 4, 2, 1, 2, 3, 1, 1, 2, 2, 3, 2, 3, 1, 2, 1, 1, 3, 3, 1, 2, 2, 5, 1, 3, 1, 3, 3, 1, 2, 2, 3, 2, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 1, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 1, 3, 3, 1, 3, 3, 1, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 4, 1, 3, 1, 2, 1, 3, 1, 1, 3, 3, 1, 2, 1, 3, 1, 2, 1, 4, 1, 1, 2, 3, 1, 2, 3, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, };

/*
 * LALR(1) parse table
 */
#define blank c_idx_not_exist
#define SHIFT(VALUE) VALUE
#define REDUCE(VALUE) c_lalr_table_reduce_base + VALUE
#define GOTO(VALUE) VALUE

const unsigned c_lalr_table_reduce_base = 0x80000000;
const unsigned c_terminal_plus_nonterminal_cnt = 136;
const unsigned lalr_state_cnt = 242;

const unsigned lalr_table[lalr_state_cnt*c_terminal_plus_nonterminal_cnt] = {
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),   SHIFT(19),   SHIFT(18),   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,    SHIFT(3),       blank,     GOTO(1),     GOTO(2),     GOTO(4),     GOTO(5),     GOTO(8),       blank,       blank,       blank,     GOTO(6),     GOTO(9),       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,     GOTO(7),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(70),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),   SHIFT(19),   SHIFT(18),   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,   REDUCE(4),       blank,       blank,    GOTO(71),     GOTO(4),     GOTO(5),     GOTO(8),       blank,       blank,       blank,     GOTO(6),     GOTO(9),       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,     GOTO(7),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),       blank,   REDUCE(5),       blank,       blank,       blank,       blank,       blank,   REDUCE(5),       blank,   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(5),   REDUCE(5),       blank,       blank,       blank,       blank,       blank,   REDUCE(5),   REDUCE(5),   REDUCE(5),   REDUCE(5),       blank,       blank,       blank,       blank,   REDUCE(5),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),       blank,   REDUCE(6),       blank,       blank,       blank,       blank,       blank,   REDUCE(6),       blank,   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(6),   REDUCE(6),       blank,       blank,       blank,       blank,       blank,   REDUCE(6),   REDUCE(6),   REDUCE(6),   REDUCE(6),       blank,       blank,       blank,       blank,   REDUCE(6),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),       blank,   REDUCE(7),       blank,       blank,       blank,       blank,       blank,   REDUCE(7),       blank,   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(7),   REDUCE(7),       blank,       blank,       blank,       blank,       blank,   REDUCE(7),   REDUCE(7),   REDUCE(7),   REDUCE(7),       blank,       blank,       blank,       blank,   REDUCE(7),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(72),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(74),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(73),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),       blank,  REDUCE(31),  REDUCE(31),       blank,       blank,       blank,       blank,  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(31),  REDUCE(31),       blank,       blank,       blank,       blank,       blank,  REDUCE(31),  REDUCE(31),  REDUCE(31),  REDUCE(31),       blank,       blank,       blank,       blank,  REDUCE(31),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(76),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(75),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,    GOTO(77),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(80),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(78),    GOTO(79),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(81),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(82),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(83),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(84),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(85),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(86),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),       blank,       blank,  REDUCE(28),       blank,  REDUCE(28),   SHIFT(87),       blank,       blank,       blank,       blank,  REDUCE(28),       blank,  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(28),  REDUCE(28),       blank,       blank,       blank,       blank,       blank,  REDUCE(28),  REDUCE(28),  REDUCE(28),  REDUCE(28),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),    GOTO(88),    GOTO(89),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),       blank,       blank,  REDUCE(38),       blank,  REDUCE(38),       blank,       blank,       blank,       blank,       blank,  REDUCE(38),       blank,  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(38),  REDUCE(38),       blank,       blank,       blank,       blank,       blank,  REDUCE(38),  REDUCE(38),  REDUCE(38),  REDUCE(38),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(48),       blank,       blank,       blank,       blank,  REDUCE(48),  REDUCE(48),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(60),       blank,       blank,       blank,  REDUCE(60),  REDUCE(60),  REDUCE(60),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  REDUCE(60),  SHIFT(101),  SHIFT(102),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(63),       blank,       blank,       blank,  REDUCE(63),  REDUCE(63),  REDUCE(63),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  REDUCE(63),  SHIFT(103),  SHIFT(104),  SHIFT(105),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(67),       blank,       blank,       blank,  REDUCE(67),  REDUCE(67),  REDUCE(67),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  REDUCE(67),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(74),       blank,       blank,       blank,  REDUCE(74),  REDUCE(74),  REDUCE(74),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  REDUCE(74),  SHIFT(112),  SHIFT(113),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(77),       blank,       blank,       blank,  REDUCE(77),  REDUCE(77),  REDUCE(77),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  REDUCE(77),  SHIFT(114),  SHIFT(115),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(80),       blank,       blank,       blank,  REDUCE(80),  REDUCE(80),  REDUCE(80),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),  REDUCE(80),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(121),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(122),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(123),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(124),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(125),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(126),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(92),       blank,       blank,  SHIFT(127),  REDUCE(92),  REDUCE(92),  REDUCE(92),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  SHIFT(128),       blank,  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),  REDUCE(92),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(131),  REDUCE(94),       blank,       blank,  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),       blank,  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),  REDUCE(94),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(129),   GOTO(130),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(134), REDUCE(101),       blank,       blank, REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101),       blank, REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101), REDUCE(101),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(132),   GOTO(133),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(135),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(110),       blank,       blank, REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110),       blank, REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110), REDUCE(110),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(137),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(136),       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(119),       blank,       blank, REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119),       blank, REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119), REDUCE(119),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(139),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(138),       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(129),       blank,       blank, REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129),       blank, REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129), REDUCE(129),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(130),       blank,       blank, REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130),       blank, REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130), REDUCE(130),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(131),       blank,       blank, REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131),       blank, REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131), REDUCE(131),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(132),       blank,       blank, REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132),       blank, REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132), REDUCE(132),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(133),       blank,       blank, REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133),       blank, REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133), REDUCE(133),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(134),       blank,       blank, REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134),       blank, REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134), REDUCE(134),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(135),       blank,       blank, REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135),       blank, REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135), REDUCE(135),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(136),       blank,       blank, REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136),       blank, REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136), REDUCE(136),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(137),       blank,       blank, REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137),       blank, REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137), REDUCE(137),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(138),       blank,       blank, REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138),       blank, REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138), REDUCE(138),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(139),       blank,       blank, REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139),       blank, REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139), REDUCE(139),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(140),       blank,       blank, REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140),       blank, REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140), REDUCE(140),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(141),       blank,       blank, REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141),       blank, REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141), REDUCE(141),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(142),       blank,       blank, REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142),       blank, REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142), REDUCE(142),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(143),       blank,       blank, REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143),       blank, REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143), REDUCE(143),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(144),       blank,       blank, REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144),       blank, REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144), REDUCE(144),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(145),       blank,       blank, REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145),       blank, REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145), REDUCE(145),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(146),       blank,       blank, REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146),       blank, REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146), REDUCE(146),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(147),       blank,       blank, REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147),       blank, REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147), REDUCE(147),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(148),       blank,       blank, REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148),       blank, REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148), REDUCE(148),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(140),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(112),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(121),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(122),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(123),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(124),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(3),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(145),   SHIFT(19),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(141),   GOTO(142),   GOTO(143),   GOTO(144),     GOTO(9),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(146),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(149),       blank,       blank,       blank,  REDUCE(18),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(150),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(147),   GOTO(148),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(152),       blank,   GOTO(151),   GOTO(153),    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(154),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(155),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(156),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(157),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),       blank,       blank,  REDUCE(43),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(43),  REDUCE(43),       blank,       blank,       blank,       blank,       blank,  REDUCE(43),  REDUCE(43),  REDUCE(43),  REDUCE(43),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),       blank,  REDUCE(44),  REDUCE(44),       blank,       blank,       blank,       blank,  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(44),  REDUCE(44),       blank,       blank,       blank,       blank,       blank,  REDUCE(44),  REDUCE(44),  REDUCE(44),  REDUCE(44),       blank,       blank,       blank,       blank,  REDUCE(44),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),       blank,  REDUCE(45),  REDUCE(45),       blank,       blank,       blank,       blank,  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(45),  REDUCE(45),       blank,       blank,       blank,       blank,       blank,  REDUCE(45),  REDUCE(45),  REDUCE(45),  REDUCE(45),       blank,       blank,       blank,       blank,  REDUCE(45),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(158),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),       blank,  REDUCE(47),  REDUCE(47),       blank,       blank,       blank,       blank,  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(47),  REDUCE(47),       blank,       blank,       blank,       blank,       blank,  REDUCE(47),  REDUCE(47),  REDUCE(47),  REDUCE(47),       blank,       blank,       blank,       blank,  REDUCE(47),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(9),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(17),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),       blank,  REDUCE(26),  REDUCE(26),       blank,       blank,       blank,       blank,  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(26),  REDUCE(26),       blank,       blank,       blank,       blank,       blank,  REDUCE(26),  REDUCE(26),  REDUCE(26),  REDUCE(26),       blank,       blank,       blank,       blank,  REDUCE(26),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),  SHIFT(160),       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(159),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),       blank,       blank,  REDUCE(30),       blank,  REDUCE(30),  REDUCE(30),       blank,       blank,       blank,       blank,  REDUCE(30),       blank,  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(30),  REDUCE(30),       blank,       blank,       blank,       blank,       blank,  REDUCE(30),  REDUCE(30),  REDUCE(30),  REDUCE(30),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(161),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(162),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(163),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(164),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(165),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(166),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(167),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(168),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(169),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(170),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(171),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(172),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(173),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(174),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(175),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(176),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(177),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(178),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(179),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(180),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(181),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(182),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(183),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(184),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(185),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(186),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(187),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(188),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(189),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(84),       blank,       blank,       blank,  REDUCE(84),  REDUCE(84),  REDUCE(84),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),       blank,       blank,  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),  REDUCE(84),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(85),       blank,       blank,       blank,  REDUCE(85),  REDUCE(85),  REDUCE(85),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),       blank,       blank,  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),  REDUCE(85),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(86),       blank,       blank,       blank,  REDUCE(86),  REDUCE(86),  REDUCE(86),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),  REDUCE(86),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(87),       blank,       blank,       blank,  REDUCE(87),  REDUCE(87),  REDUCE(87),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),  REDUCE(87),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(88),       blank,       blank,       blank,  REDUCE(88),  REDUCE(88),  REDUCE(88),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),  REDUCE(88),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(89),       blank,       blank,       blank,  REDUCE(89),  REDUCE(89),  REDUCE(89),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),  REDUCE(89),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(90),       blank,       blank,       blank,  REDUCE(90),  REDUCE(90),  REDUCE(90),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),  REDUCE(90),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(91),       blank,       blank,       blank,  REDUCE(91),  REDUCE(91),  REDUCE(91),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),  REDUCE(91),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(190),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(191),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(192),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),  REDUCE(96),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(194),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,   GOTO(193),    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),       blank,       blank,  REDUCE(98),  REDUCE(98),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(98),  REDUCE(98),       blank,       blank,       blank,       blank,       blank,  REDUCE(98),  REDUCE(98),  REDUCE(98),  REDUCE(98),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(195),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64), REDUCE(104),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(197),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,   GOTO(196),    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
 REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106),       blank,       blank, REDUCE(106), REDUCE(106),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(106), REDUCE(106),       blank,       blank,       blank,       blank,       blank, REDUCE(106), REDUCE(106), REDUCE(106), REDUCE(106),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(109),       blank,       blank, REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109),       blank, REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109), REDUCE(109),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(198),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(200),       blank,       blank,       blank, REDUCE(113),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(199),       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(201),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64), REDUCE(125),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(203),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,   GOTO(202),
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(204),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(145),   SHIFT(19),       blank,       blank,       blank,       blank,  SHIFT(206),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(205),   GOTO(143),   GOTO(144),     GOTO(9),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(11),  REDUCE(11),       blank,       blank,       blank,       blank,  REDUCE(11),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(208),  SHIFT(207),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(13),  REDUCE(13),       blank,       blank,       blank,       blank,  REDUCE(13),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(14),  REDUCE(14),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(210),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(209),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(19),       blank,       blank,       blank,       blank,  SHIFT(211),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(21),       blank,       blank,       blank,       blank,  REDUCE(21),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(22),       blank,       blank,       blank,       blank,  REDUCE(22),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(212),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),       blank,  REDUCE(32),  REDUCE(32),       blank,       blank,       blank,       blank,  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(32),  REDUCE(32),       blank,       blank,       blank,       blank,       blank,  REDUCE(32),  REDUCE(32),  REDUCE(32),  REDUCE(32),       blank,       blank,       blank,       blank,  REDUCE(32),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),       blank,  REDUCE(34),  REDUCE(34),       blank,       blank,       blank,       blank,  REDUCE(34),  SHIFT(213),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(34),  REDUCE(34),       blank,       blank,       blank,       blank,       blank,  REDUCE(34),  REDUCE(34),  REDUCE(34),  REDUCE(34),       blank,       blank,       blank,       blank,  REDUCE(34),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),       blank,       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(214),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(215),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(218),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(216),   GOTO(217),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),       blank,  REDUCE(41),  REDUCE(41),       blank,       blank,       blank,       blank,  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(41),  REDUCE(41),       blank,       blank,       blank,       blank,       blank,  REDUCE(41),  REDUCE(41),  REDUCE(41),  REDUCE(41),       blank,       blank,       blank,       blank,  REDUCE(41),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(219),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),       blank,  REDUCE(46),  REDUCE(46),       blank,       blank,       blank,       blank,  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(46),  REDUCE(46),       blank,       blank,       blank,       blank,       blank,  REDUCE(46),  REDUCE(46),  REDUCE(46),  REDUCE(46),       blank,       blank,       blank,       blank,  REDUCE(46),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),       blank,       blank,  REDUCE(29),       blank,  REDUCE(29),  REDUCE(29),       blank,       blank,       blank,       blank,  REDUCE(29),       blank,  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(29),  REDUCE(29),       blank,       blank,       blank,       blank,       blank,  REDUCE(29),  REDUCE(29),  REDUCE(29),  REDUCE(29),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),       blank,  REDUCE(27),  REDUCE(27),       blank,       blank,       blank,       blank,  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(27),  REDUCE(27),       blank,       blank,       blank,       blank,       blank,  REDUCE(27),  REDUCE(27),  REDUCE(27),  REDUCE(27),       blank,       blank,       blank,       blank,  REDUCE(27),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(49),       blank,       blank,       blank,  REDUCE(49),  REDUCE(49),  REDUCE(49),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(50),       blank,       blank,       blank,  REDUCE(50),  REDUCE(50),  REDUCE(50),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(51),       blank,       blank,       blank,  REDUCE(51),  REDUCE(51),  REDUCE(51),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(52),       blank,       blank,       blank,  REDUCE(52),  REDUCE(52),  REDUCE(52),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(53),       blank,       blank,       blank,  REDUCE(53),  REDUCE(53),  REDUCE(53),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(54),       blank,       blank,       blank,  REDUCE(54),  REDUCE(54),  REDUCE(54),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(55),       blank,       blank,       blank,  REDUCE(55),  REDUCE(55),  REDUCE(55),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(56),       blank,       blank,       blank,  REDUCE(56),  REDUCE(56),  REDUCE(56),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(57),       blank,       blank,       blank,  REDUCE(57),  REDUCE(57),  REDUCE(57),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(58),       blank,       blank,       blank,  REDUCE(58),  REDUCE(58),  REDUCE(58),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(59),       blank,       blank,       blank,  REDUCE(59),  REDUCE(59),  REDUCE(59),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(61),       blank,       blank,       blank,  REDUCE(61),  REDUCE(61),  REDUCE(61),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  REDUCE(61),  SHIFT(101),  SHIFT(102),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(62),       blank,       blank,       blank,  REDUCE(62),  REDUCE(62),  REDUCE(62),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  REDUCE(62),  SHIFT(101),  SHIFT(102),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(64),       blank,       blank,       blank,  REDUCE(64),  REDUCE(64),  REDUCE(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  REDUCE(64),  SHIFT(103),  SHIFT(104),  SHIFT(105),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(65),       blank,       blank,       blank,  REDUCE(65),  REDUCE(65),  REDUCE(65),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  REDUCE(65),  SHIFT(103),  SHIFT(104),  SHIFT(105),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(66),       blank,       blank,       blank,  REDUCE(66),  REDUCE(66),  REDUCE(66),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  REDUCE(66),  SHIFT(103),  SHIFT(104),  SHIFT(105),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(68),       blank,       blank,       blank,  REDUCE(68),  REDUCE(68),  REDUCE(68),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  REDUCE(68),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(69),       blank,       blank,       blank,  REDUCE(69),  REDUCE(69),  REDUCE(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  REDUCE(69),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(70),       blank,       blank,       blank,  REDUCE(70),  REDUCE(70),  REDUCE(70),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  REDUCE(70),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(71),       blank,       blank,       blank,  REDUCE(71),  REDUCE(71),  REDUCE(71),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  REDUCE(71),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(72),       blank,       blank,       blank,  REDUCE(72),  REDUCE(72),  REDUCE(72),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  REDUCE(72),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(73),       blank,       blank,       blank,  REDUCE(73),  REDUCE(73),  REDUCE(73),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  REDUCE(73),  SHIFT(106),  SHIFT(107),  SHIFT(108),  SHIFT(109),  SHIFT(110),  SHIFT(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(75),       blank,       blank,       blank,  REDUCE(75),  REDUCE(75),  REDUCE(75),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  REDUCE(75),  SHIFT(112),  SHIFT(113),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(76),       blank,       blank,       blank,  REDUCE(76),  REDUCE(76),  REDUCE(76),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  REDUCE(76),  SHIFT(112),  SHIFT(113),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(78),       blank,       blank,       blank,  REDUCE(78),  REDUCE(78),  REDUCE(78),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  REDUCE(78),  SHIFT(114),  SHIFT(115),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(79),       blank,       blank,       blank,  REDUCE(79),  REDUCE(79),  REDUCE(79),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  REDUCE(79),  SHIFT(114),  SHIFT(115),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(81),       blank,       blank,       blank,  REDUCE(81),  REDUCE(81),  REDUCE(81),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),  REDUCE(81),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(82),       blank,       blank,       blank,  REDUCE(82),  REDUCE(82),  REDUCE(82),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),  REDUCE(82),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(83),       blank,       blank,       blank,  REDUCE(83),  REDUCE(83),  REDUCE(83),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),  REDUCE(83),       blank,       blank,  SHIFT(116),  SHIFT(117),  SHIFT(118),  SHIFT(119),  SHIFT(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(220),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(90),   SHIFT(91),   SHIFT(92),   SHIFT(93),   SHIFT(94),   SHIFT(95),   SHIFT(96),   SHIFT(97),   SHIFT(98),   SHIFT(99),  SHIFT(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(103), REDUCE(103),       blank,       blank, REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103),       blank, REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103), REDUCE(103),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(95),       blank,       blank,  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),       blank,  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),  REDUCE(95),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(97),       blank,       blank,       blank,       blank,  SHIFT(221),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(100),       blank,       blank,       blank,       blank, REDUCE(100),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(102),       blank,       blank, REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102),       blank, REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102), REDUCE(102),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(105),       blank,       blank,       blank,       blank,  SHIFT(222),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(108),       blank,       blank,       blank,       blank, REDUCE(108),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(224),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(223),       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(114),       blank,       blank,       blank,       blank,  SHIFT(225),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(116),       blank,       blank,       blank,       blank, REDUCE(116),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(120),       blank,       blank, REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120),       blank, REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120), REDUCE(120),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(126),       blank,       blank,       blank,       blank,  SHIFT(226),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(128),       blank,       blank,       blank,       blank, REDUCE(128),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(149),       blank,       blank, REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149),       blank, REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149), REDUCE(149),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(10),  REDUCE(10),       blank,       blank,       blank,       blank,  REDUCE(10),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),       blank,   REDUCE(8),       blank,       blank,       blank,       blank,       blank,   REDUCE(8),       blank,   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   REDUCE(8),   REDUCE(8),       blank,       blank,       blank,       blank,       blank,   REDUCE(8),   REDUCE(8),   REDUCE(8),   REDUCE(8),       blank,       blank,       blank,       blank,   REDUCE(8),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(12),  REDUCE(12),       blank,       blank,       blank,       blank,  REDUCE(12),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(227),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),       blank,  REDUCE(16),  REDUCE(16),       blank,       blank,       blank,       blank,  REDUCE(16),       blank,  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(16),  REDUCE(16),       blank,       blank,       blank,       blank,       blank,  REDUCE(16),  REDUCE(16),  REDUCE(16),  REDUCE(16),       blank,       blank,       blank,       blank,  REDUCE(16),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),  SHIFT(228),       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),   GOTO(229),    GOTO(89),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(149),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(150),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(230),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(23),       blank,       blank,       blank,       blank,  REDUCE(23),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),       blank,       blank,  REDUCE(36),       blank,  REDUCE(36),       blank,       blank,       blank,       blank,       blank,  REDUCE(36),       blank,  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(36),  REDUCE(36),       blank,       blank,       blank,       blank,       blank,  REDUCE(36),  REDUCE(36),  REDUCE(36),  REDUCE(36),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),       blank,  REDUCE(35),  REDUCE(35),       blank,       blank,       blank,       blank,  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(35),  REDUCE(35),       blank,       blank,       blank,       blank,       blank,  REDUCE(35),  REDUCE(35),  REDUCE(35),  REDUCE(35),       blank,       blank,       blank,       blank,  REDUCE(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),       blank,       blank,  REDUCE(33),       blank,  REDUCE(33),       blank,       blank,       blank,       blank,       blank,  REDUCE(33),       blank,  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(33),  REDUCE(33),       blank,       blank,       blank,       blank,       blank,  REDUCE(33),  REDUCE(33),  REDUCE(33),  REDUCE(33),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(231),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(232),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),       blank,       blank,  REDUCE(40),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(40),  REDUCE(40),       blank,       blank,       blank,       blank,       blank,  REDUCE(40),  REDUCE(40),  REDUCE(40),  REDUCE(40),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),       blank,       blank,  REDUCE(42),       blank,  REDUCE(42),       blank,       blank,       blank,       blank,       blank,  REDUCE(42),       blank,  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(42),  REDUCE(42),       blank,       blank,       blank,       blank,       blank,  REDUCE(42),  REDUCE(42),  REDUCE(42),  REDUCE(42),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(93),       blank,       blank,  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),       blank,  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),  REDUCE(93),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(233),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(234),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(111),       blank,       blank, REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111),       blank, REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111), REDUCE(111),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),  SHIFT(235),       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),   GOTO(236),    GOTO(89),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(237),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   GOTO(238),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(15),  REDUCE(15),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),       blank,  REDUCE(24),  REDUCE(24),       blank,       blank,       blank,       blank,  REDUCE(24),       blank,  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(24),  REDUCE(24),       blank,       blank,       blank,       blank,       blank,  REDUCE(24),  REDUCE(24),  REDUCE(24),  REDUCE(24),       blank,       blank,       blank,       blank,  REDUCE(24),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),  SHIFT(239),       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(159),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(20),       blank,       blank,       blank,       blank,  REDUCE(20),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),       blank,  REDUCE(37),  REDUCE(37),       blank,       blank,       blank,       blank,  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(37),  REDUCE(37),       blank,       blank,       blank,       blank,       blank,  REDUCE(37),  REDUCE(37),  REDUCE(37),  REDUCE(37),       blank,       blank,       blank,       blank,  REDUCE(37),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  SHIFT(240),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(99),       blank,       blank,       blank,       blank,  REDUCE(99),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(107),       blank,       blank,       blank,       blank, REDUCE(107),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(117),       blank,       blank, REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117),       blank, REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117), REDUCE(117),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
   SHIFT(44),   SHIFT(45),   SHIFT(46),   SHIFT(47),   SHIFT(48),   SHIFT(49),   SHIFT(50),   SHIFT(51),   SHIFT(52),   SHIFT(53),   SHIFT(54),   SHIFT(55),   SHIFT(56),   SHIFT(57),   SHIFT(58),   SHIFT(59),   SHIFT(60),   SHIFT(61),   SHIFT(62),   SHIFT(63),   SHIFT(37),       blank,       blank,   SHIFT(64),       blank,   SHIFT(20),  SHIFT(241),       blank,       blank,       blank,       blank,   SHIFT(11),       blank,   SHIFT(22),   SHIFT(13),   SHIFT(14),   SHIFT(15),   SHIFT(16),   SHIFT(39),   SHIFT(40),   SHIFT(65),   SHIFT(42),   SHIFT(66),   SHIFT(67),   SHIFT(68),   SHIFT(69),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,   SHIFT(32),   SHIFT(33),       blank,       blank,       blank,       blank,       blank,   SHIFT(30),   SHIFT(31),   SHIFT(34),   SHIFT(35),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,    GOTO(10),    GOTO(21),       blank,   GOTO(159),       blank,       blank,       blank,    GOTO(12),       blank,       blank,       blank,       blank,    GOTO(17),    GOTO(23),    GOTO(24),    GOTO(25),    GOTO(26),    GOTO(27),    GOTO(28),    GOTO(29),    GOTO(36),       blank,       blank,       blank,    GOTO(38),       blank,       blank,       blank,    GOTO(41),       blank,       blank,       blank,    GOTO(43),       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(115),       blank,       blank,       blank,       blank, REDUCE(115),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(127),       blank,       blank,       blank,       blank, REDUCE(127),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),       blank,  REDUCE(25),  REDUCE(25),       blank,       blank,       blank,       blank,  REDUCE(25),       blank,  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(25),  REDUCE(25),       blank,       blank,       blank,       blank,       blank,  REDUCE(25),  REDUCE(25),  REDUCE(25),  REDUCE(25),       blank,       blank,       blank,       blank,  REDUCE(25),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,  REDUCE(39),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(118),       blank,       blank, REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank, REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118),       blank, REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118), REDUCE(118),       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,       blank,
};

/*
 * definition of generated structures
 */

// -- value_location_s --
@begin
   struct
   <unsigned unsigned_long_long unsigned_char>
   <-v ui_first ulli_second uc_third>
   value_location_s;
@end

// -- location_array_s --
@begin
   array<value_location_s> location_array_s;
@end

// -- value_location_pool_s --
@begin
   struct
   <     location_array_s ui_array_s   unsigned>
   <-v   location_array   empty_stack  script_parser_ptr>
   "inline unsigned insert(unsigned a_ui_first,unsigned long long a_ui_second,unsigned char a_uc_third);"
   "inline void remove(unsigned a_idx);"
   "inline value_location_s &operator[](unsigned a_idx);"

   "void free_value(unsigned a_idx);"
   "void final_free_value(unsigned a_idx);"
   "void final_free_all_values();"

   "inline ui_array_s *create_structure(unsigned a_var_cnt);"
   "unsigned copy_create_value(unsigned src_location_idx);"
   "bool compare_values(unsigned first_location_idx,unsigned second_location_idx);"

   "inline char get_char_value(value_location_s &location);"
   "inline char *get_char_ptr(value_location_s &location);"
   "inline short get_short_value(value_location_s &location);"
   "inline short *get_short_ptr(value_location_s &location);"
   "inline int get_int_value(value_location_s &location);"
   "inline int *get_int_ptr(value_location_s &location);"
   "inline double get_double_value(value_location_s &location);"
   "inline double *get_double_ptr(value_location_s &location);"
   "inline short *get_color_ptr(value_location_s &location);"

   "inline void tmp_value_shift(value_location_s &dst_location,value_location_s &src_location);"

   "inline void copy_string_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_local_img_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_char_array_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_int_array_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_double_array_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_obj_array_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_mutex_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_condition_value(value_location_s &dst_location,value_location_s &src_location);"
   "inline void copy_struct_value(value_location_s &dst_location,value_location_s &src_location);"

   "inline void local_img_clear(local_img_s *local_img_ptr);"
   "void obj_array_clear(ui_array_s *ui_array_ptr);"
   "void struct_clear(ui_array_s *struct_ptr);"

   "inline void local_img_print(local_img_s *local_img_ptr);"
   "void char_array_print(bc_array_s *bc_array_ptr);"
   "void int_array_print(bi_array_s *bi_array_ptr);"
   "void double_array_print(bd_array_s *bd_array_ptr);"
   "void obj_array_print(ui_array_s *ui_array_ptr);"

   "void print_value(value_location_s &location);"
   "inline void print_value_idx(unsigned location_idx);"

   value_location_pool_s;
@end

// -- rc_position_s --
// -- break_continue_pos_s --
// -- source_string_pos_s --
// -- parser_ptr_thread_idx_s --
@begin
   struct
   <   unsigned unsigned>
   <-v ui_first ui_second>
   rc_position_s
   break_continue_pos_s
   source_string_pos_s
   parser_ptr_thread_idx_s;
@end

// -- rc_position_array_s --
// -- break_continue_pos_array_s --
// -- source_string_pos_array_s --
@begin
   array<rc_position_s>
   rc_position_array_s
   break_continue_pos_array_s
   source_string_pos_array_s;
@end

// -- break_continue_pos_arrays_s --
@begin
   array<break_continue_pos_array_s> break_continue_pos_arrays_s;
@end

// -- symbols_array_s --
@begin
   array<symbols_s> symbols_array_s;
@end

// -- symbol_record_s --
@begin
   struct
   <	 unsigned       unsigned       unsigned       symbols_array_s>
   <-v	 p_record_idx	p_symbol_type  p_symbol_idx   symbols_array>
   symbol_record_s;
@end

// -- symbol_records_s --
@begin
   array<symbol_record_s> symbol_records_s;
@end

// -- run_code_s --
@begin
   struct
   <	 ui_array_s  ui_array_s>
   <-v	 code	     source_positions>
   run_code_s;
@end

// -- run_codes_s --
@begin
   array<run_code_s> run_codes_s;
@end

// -- sp_thread_s --
@begin
   struct
   <
   pthread_t
   unsigned
   rc_position_array_s
   ui_array_s
   ui_arrays_s
   ui_arrays_s
   ui_arrays_s
   ui_array_s
   >
   <-v
   pthread $// - identifier of corresponding pthread thread -
   state $// - run state of thread -
   rc_position_array $// - array of actual positions of thread in code -
   this_variables $// - this variables stack -
   param_variables_array $// - function parameters array stack -
   local_variables_array $// - local variables array stack -
   tmp_variables_array $// - registration of temporary variables -
   exp_stack $// - stack of expression values -
   >
   "inline void initialize_thread(pthread_t pthread,unsigned a_code,unsigned a_code_idx);"
   sp_thread_s;
@end

// -- sp_thread_array_s --
@begin
   array<sp_thread_s> sp_thread_array_s;
@end

// -- sp_thread_pool_s --
@begin
   struct
   <	 sp_thread_array_s ui_array_s  unsigned>
   <-v	 sp_thread_array   empty_stack used>
   "inline unsigned insert(pthread_t pthread,unsigned a_code,unsigned a_code_idx);"
   "inline void remove(unsigned a_idx);"
   "inline sp_thread_s &operator[](unsigned a_idx);"
   sp_thread_pool_s;
@end

// -- sp_mcs_pool_s --
@begin
   struct
   <	 sp_mcs_array_s	ui_array_s>
   <-v	 sp_mcs_array	empty_stack>
   "inline unsigned mutex_insert_new();"
   "inline void mutex_increase_cnt(unsigned a_idx);"
   "inline void mutex_remove(unsigned a_idx);"

   "inline unsigned condition_insert_new();"
   "inline void condition_increase_cnt(unsigned a_idx);"
   "inline void condition_remove(unsigned a_idx);"

   "inline sp_mcs_s &operator[](unsigned a_idx);"
   sp_mcs_pool_s;
@end

// -- script_parser_s --
@begin
   struct
   <
   string_array_s
   symbol_records_s
   ui_array_s
   value_location_pool_s
   run_codes_s

   $ - parse variables -
   unsigned
   unsigned
   lalr_stack_s
   source_string_pos_s
   source_string_pos_array_s
   ui_array_s
   ui_array_s
   break_continue_pos_arrays_s
   break_continue_pos_arrays_s
   ui_array_s

   $ - run variables -
   ui_array_s
   sp_thread_pool_s
   sp_mcs_pool_s
   bool
   mutex_s
   >

   <-v 
   symbol_names $// - array containing names of all elements of program, index in this array identifies them -
   symbol_records $// - record of symbols which describes all structures, functions and variables of program -
   sa_idx_stack $// - at parse this stack have at top index of actual symbol record -
   value_location_pool $// - structure which contains value of all script data and its description -
   run_codes $// - codes of main program and all functions -

   $ - parse variables -
   line_cnt $// - actual line in parsed file -
   instr_per_line $// - instruction count at actual line -
   lalr_stack $// - LALR parse stack -
   tmp_fun_name_pos $// - variable for temporary saving function name, at parse time -
   tmp_sm_name_pos_array $// - variable for temporary save of structure member names -
   fm_param_cnt $// - variable for function parameter counting (function call) -
   jmp_code_idxs $// - variable for save indexes of code from which is performed jump -
   break_pos_arrays $// - positions of break command at code -
   continue_pos_arrays $// - positions of continue command at code -
   pc_idx_stack $// - parse code stack, top contain index of produced code -

   $ - run variables -
   global_variables $// - array defining locations of global variables -
   sp_thread_pool $// - structure containing description of separate threads -
   sp_mcs_pool $// - list describing mutexes, conditions a semaphores of program -
   multiple_threads $// - multi threading enable switch -
   mutex $// - interpret main mutex -
   >
   "unsigned get_line_number(unsigned a_thread_idx);"
   "unsigned recognize_terminal(string_s &source_string,unsigned &input_idx,unsigned &line_cnt);"
   "inline unsigned get_symbol_name_idx(unsigned a_length,char *a_data);"
   "void parse_script(string_s &source_string);"
   "void create_build_in_symbols();"
   "void initialize_parser(int argc,char **argv);"
   "void run_thread(unsigned a_thread_idx);"
   "void run_main_thread(unsigned a_thread_idx);"

   "inline void remove_tmp_values(unsigned a_thread_idx);"
   
   script_parser_s;
@end

/* 
 * inline methods of generated structures
 */

// -- value_location_s --
@begin
   inlines "value_location_s";
@end

// -- location_array_s --
@begin
   inlines "location_array_s";
@end

// -- value_location_pool_s --
@begin
   inlines "value_location_pool_s";
@end

/*
 * create new value description and return its index
 */

inline unsigned value_location_pool_s::insert(unsigned a_ui_first,unsigned long long a_ulli_second,unsigned char a_uc_third)
{
   if (empty_stack.used != 0) {
      unsigned idx = empty_stack.pop();
      location_array[idx].set(a_ui_first,a_ulli_second,a_uc_third);
      return idx;
   }
   else {
      location_array.push_blank();
      unsigned idx = location_array.used - 1;
      location_array[idx].set(a_ui_first,a_ulli_second,a_uc_third);
      return idx;
   }
}

/*
 * remove value description from pool
 */

inline void value_location_pool_s::remove(unsigned a_idx)
{
   location_array[a_idx].ui_first = c_idx_not_exist;
   empty_stack.push(a_idx);
}

/*
 * return description of value 
 */

inline value_location_s &value_location_pool_s::operator[](unsigned a_idx)
{
   return location_array[a_idx];
}

/*
 * creation of structure including elements of this structure
 */

inline ui_array_s *value_location_pool_s::create_structure(unsigned a_s_var_cnt)
{

   // - allocation of memory for array of structure members -
   ui_array_s *struct_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));

   // - setting of structure element count -
   struct_ptr->init_size(a_s_var_cnt);

   // - creation of elements of structure -
   if (a_s_var_cnt != 0) {
      unsigned *s_var_ptr = struct_ptr->data;
      unsigned *s_var_ptr_end = s_var_ptr + a_s_var_cnt;

      // - cycle over every element -
      do {
         *s_var_ptr = insert(c_value_type_BLANK,(unsigned long long)c_idx_not_exist,c_value_modifier_WRITABLE);
      } while(++s_var_ptr < s_var_ptr_end);

      struct_ptr->used = a_s_var_cnt;
   }

   return struct_ptr;
}

/*
 * function returning char value described by location
 */

inline char value_location_pool_s::get_char_value(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      switch (a_location.ui_first) {
      case c_value_type_STRING:
	 {
	    string_s *string_ptr = IM_ACCESS_STRING_PTR(a_location.ulli_second);
	    return ((*string_ptr)[location.ulli_second & 0xffffffff]);
	 }
	 break;
      case c_value_type_CHAR_ARRAY:
	 {
	    bc_array_s *bc_array_ptr = IM_ACCESS_CHAR_ARRAY_PTR(a_location.ulli_second);
	    return ((*bc_array_ptr)[location.ulli_second & 0xffffffff]);
	 }
	 break;
      default:
	 assert(0);
      }
   }
   else {
      return (char)(location.ulli_second);
   }
}

/*
 * function returning pointer to char described by location
 */

inline char *value_location_pool_s::get_char_ptr(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = (location.ulli_second >> 32);
      value_location_s &a_location = location_array[a_location_idx];

      switch (a_location.ui_first) {
      case c_value_type_STRING:
	 {
	    string_s *string_ptr = IM_ACCESS_STRING_PTR(a_location.ulli_second);
	    return &((*string_ptr)[location.ulli_second & 0xffffffff]);
	 }
	 break;
      case c_value_type_CHAR_ARRAY:
	 {
	    bc_array_s *bc_array_ptr = IM_ACCESS_CHAR_ARRAY_PTR(a_location.ulli_second);
	    return &((*bc_array_ptr)[location.ulli_second & 0xffffffff]);
	 }
	 break;
      default:
	 assert(0);
      }
   }
   else {
      return ((char *)&(location.ulli_second));
   }
}

/*
 * function returning value of short integer
 */

inline short value_location_pool_s::get_short_value(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      switch (a_location.ui_first) {
      case c_value_type_COLOR:
	 {
	    short *color_ptr = get_color_ptr(a_location);
	    return color_ptr[location.ulli_second & 0xffffffff];
	 }
	 break;
      default:
	 assert(0);
      }
   }
   else {
      return (short)(location.ulli_second);
   }
}

/*
 * function returning pointer to short integer
 */

inline short *value_location_pool_s::get_short_ptr(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      switch (a_location.ui_first) {
      case c_value_type_COLOR:
	 {
	    short *color_ptr = get_color_ptr(a_location);
	    return color_ptr + (location.ulli_second & 0xffffffff);
	 }
	 break;
      default:
	 assert(0);
      }
   }
   else {
      return ((short *)&(location.ulli_second));
   }
}

/*
 * function returning value of integer, described by location
 */

inline int value_location_pool_s::get_int_value(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      assert(a_location.ui_first == c_value_type_INT_ARRAY);
      bi_array_s *bi_array_ptr = IM_ACCESS_INT_ARRAY_PTR(a_location.ulli_second);
      return ((*bi_array_ptr)[location.ulli_second & 0xffffffff]);
   }
   else {
      return (int)(location.ulli_second);
   }
}

/*
 * function returning pointer to integer, described by location
 */

inline int *value_location_pool_s::get_int_ptr(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      assert(a_location.ui_first == c_value_type_INT_ARRAY);
      bi_array_s *bi_array_ptr = IM_ACCESS_INT_ARRAY_PTR(a_location.ulli_second);
      return &((*bi_array_ptr)[location.ulli_second & 0xffffffff]);
   }
   else {
      return ((int *)&(location.ulli_second));
   }
}

/*
 * function returning value of number with floating point, described by location
 */

inline double value_location_pool_s::get_double_value(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      assert(a_location.ui_first == c_value_type_DOUBLE_ARRAY);
      bd_array_s *bd_array_ptr = IM_ACCESS_DOUBLE_ARRAY_PTR(a_location.ulli_second);
      return ((*bd_array_ptr)[location.ulli_second & 0xffffffff]);
   }
   else {
      return *((double *)&(location.ulli_second));
   }
}

/*
 * function returning pointer to number with floating point, described by location
 */

inline double *value_location_pool_s::get_double_ptr(value_location_s &location)
{
   if (location.uc_third & c_value_modifier_INDEXED) {
      unsigned a_location_idx = ((unsigned)(location.ulli_second >> 32));
      value_location_s &a_location = location_array[a_location_idx];

      assert(a_location.ui_first == c_value_type_DOUBLE_ARRAY);
      bd_array_s *bd_array_ptr = IM_ACCESS_DOUBLE_ARRAY_PTR(a_location.ulli_second);
      return &((*bd_array_ptr)[location.ulli_second & 0xffffffff]);
   }
   else {
      return ((double *)&(location.ulli_second));
   }
}

/*
 * function returning pointer to short array describing color elements
 */

inline short *value_location_pool_s::get_color_ptr(value_location_s &location)
{
   return (short *)&location.ulli_second;
}

/*
 * move of temporary value to new not-temporary position
 */

inline void value_location_pool_s::tmp_value_shift(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = src_location.ui_first;
   dst_location.ulli_second = src_location.ulli_second;

   src_location.ui_first = c_value_type_BLANK;
}

/*
 * copy of string described by source location to target location
 */

inline void value_location_pool_s::copy_string_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_STRING;
   string_s *str_ptr = (string_s *)cmalloc(sizeof(string_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(str_ptr);
   str_ptr->init();
   *str_ptr = *IM_ACCESS_STRING_PTR(src_location.ulli_second);
}

/*
 * copy of local image described by source location to target location
 */

inline void value_location_pool_s::copy_local_img_value(value_location_s &dst_location,value_location_s &src_location)
{
   script_parser_s *sp_ptr = (script_parser_s *)script_parser_ptr;

   dst_location.ui_first = c_value_type_LOCAL_IMG;
   local_img_s *local_img_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(local_img_ptr);
   local_img_ptr->init();

   if (sp_ptr->multiple_threads) {
      local_img_ptr->lock_set(sp_ptr->mutex,*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
   }
   else {
      local_img_ptr->set(*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
   }
}

/*
 * copy of char array described by source location to target location
 */

inline void value_location_pool_s::copy_char_array_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_CHAR_ARRAY;
   bc_array_s *bc_array_ptr = (bc_array_s *)cmalloc(sizeof(bc_array_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(bc_array_ptr);
   bc_array_ptr->init();
   *bc_array_ptr = *IM_ACCESS_CHAR_ARRAY_PTR(src_location.ulli_second);
}

/*
 * copy of integer array described by source location to target location
 */

inline void value_location_pool_s::copy_int_array_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_INT_ARRAY;
   bi_array_s *bi_array_ptr = (bi_array_s *)cmalloc(sizeof(bi_array_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(bi_array_ptr);
   bi_array_ptr->init();
   *bi_array_ptr = *IM_ACCESS_INT_ARRAY_PTR(src_location.ulli_second);
}

/*
 * copy of double array described by source location to target location
 */

inline void value_location_pool_s::copy_double_array_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_DOUBLE_ARRAY;
   bd_array_s *bd_array_ptr = (bd_array_s *)cmalloc(sizeof(bd_array_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(bd_array_ptr);
   bd_array_ptr->init();
   *bd_array_ptr = *IM_ACCESS_DOUBLE_ARRAY_PTR(src_location.ulli_second);
}

/*
 * copy of object array described by source location to target location
 */

inline void value_location_pool_s::copy_obj_array_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_OBJ_ARRAY;
   ui_array_s *ui_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(ui_array_ptr);
   ui_array_ptr->init();
   
   ui_array_s *src_ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(src_location.ulli_second);

   if (src_ui_array_ptr->used != 0) {
      unsigned *si_ptr = src_ui_array_ptr->data;
      unsigned *si_ptr_end = si_ptr + src_ui_array_ptr->used;

      do {
	 ui_array_ptr->push(copy_create_value(*si_ptr));
      } while(++si_ptr < si_ptr_end);
   }
}

/*
 * copy of mutex (reference) described by source location to target location
 */

inline void value_location_pool_s::copy_mutex_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_MUTEX;

   unsigned src_mutex_idx = IM_ACCESS_MUTEX_SRC(src_location.ulli_second);

   ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.mutex_increase_cnt(src_mutex_idx);
   IM_ACCESS_MUTEX_TRG(dst_location.ulli_second) = src_mutex_idx;
}

/*
 * copy of condition (reference) described by source location to target location
 */

inline void value_location_pool_s::copy_condition_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = c_value_type_CONDITION;

   unsigned src_condition_idx = IM_ACCESS_COND_SRC(src_location.ulli_second);

   ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.condition_increase_cnt(src_condition_idx);
   IM_ACCESS_COND_TRG(dst_location.ulli_second) = src_condition_idx;
}

/*
 * zkopirovani struktury popsane zdrojovou lokaci do cilove lokace
 * copy of structure described by source location to target location
 */

inline void value_location_pool_s::copy_struct_value(value_location_s &dst_location,value_location_s &src_location)
{
   dst_location.ui_first = src_location.ui_first;
   ui_array_s *ui_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
   dst_location.ulli_second = IM_ACCESS_DATA_PTR(ui_array_ptr);
   ui_array_ptr->init();

   ui_array_s *src_ui_array_ptr = IM_ACCESS_STRUCT_PTR(src_location.ulli_second);

   if (src_ui_array_ptr->used != 0) {
      unsigned *si_ptr = src_ui_array_ptr->data;
      unsigned *si_ptr_end = si_ptr + src_ui_array_ptr->used;

      do {
	 ui_array_ptr->push(copy_create_value(*si_ptr));
      } while(++si_ptr < si_ptr_end);
   }
}

/*
 * release local image from memory
 */

inline void value_location_pool_s::local_img_clear(local_img_s *local_img_ptr)
{
   script_parser_s *sp_ptr = (script_parser_s *)script_parser_ptr;
  
   if (sp_ptr->multiple_threads) {
      local_img_ptr->lock_clear(sp_ptr->mutex);
   }
   else {
      local_img_ptr->clear();
   }

   cfree(local_img_ptr);
}

/*
 * prints informations about local image
 */

inline void value_location_pool_s::local_img_print(local_img_s *local_img_ptr)
{
   script_parser_s *sp_ptr = (script_parser_s *)script_parser_ptr;

   if (sp_ptr->multiple_threads) {
      local_img_ptr->lock_print_info(sp_ptr->mutex);
   }
   else {
      local_img_ptr->print_info();
   }
}

/*
 * prints value described by location
 */

inline void value_location_pool_s::print_value_idx(unsigned location_idx)
{
   print_value(location_array[location_idx]);
}

// -- rc_position_s --
// -- break_continue_pos_s --
// -- source_string_pos_s --
// -- parser_ptr_thread_idx_s --
@begin
   inlines "rc_position_s";
@end

// -- rc_position_array_s --
// -- break_continue_pos_array_s --
// -- source_string_pos_array_s --
@begin
   inlines "rc_position_array_s";
@end

// -- break_continue_pos_arrays_s --
@begin
   inlines "break_continue_pos_arrays_s";
@end

// -- symbols_array_s --
@begin
   inlines "symbols_array_s";
@end

// -- symbol_record_s --
@begin
   inlines "symbol_record_s";
@end

// -- symbol_records_s --
@begin
   inlines "symbol_records_s";
@end

// -- run_code_s --
@begin
   inlines "run_code_s";
@end

// -- run_codes_s --
@begin
   inlines "run_codes_s";
@end

// -- sp_thread_s --
@begin
   inlines "sp_thread_s";
@end

/*
 * set variables of structure sp_thread_s to default values
 */

inline void sp_thread_s::initialize_thread(pthread_t a_pthread,unsigned a_code,unsigned a_code_idx)
{
   pthread = a_pthread;
   state = c_thread_state_JOINABLE;

   rc_position_array.clear();
   rc_position_array.push_blank();
   rc_position_array.last().set(a_code,a_code_idx);

   this_variables.clear();
   param_variables_array.clear();
   local_variables_array.clear();

   tmp_variables_array.clear();
   tmp_variables_array.push_blank();

   exp_stack.clear();
}

// -- sp_thread_array_s --
@begin
   inlines "sp_thread_array_s";
@end

// -- sp_thread_pool_s --
@begin
   inlines "sp_thread_pool_s";
@end

/*
 * insert to thread list new thread description
 */

inline unsigned sp_thread_pool_s::insert(pthread_t pthread,unsigned a_code,unsigned a_code_idx)
{
   if (empty_stack.used != 0) {
      unsigned thread_idx = empty_stack.pop();
      sp_thread_array[thread_idx].initialize_thread(pthread,a_code,a_code_idx);
      used++;
      return thread_idx;
   }
   else {
      sp_thread_array.push_blank();
      sp_thread_array.last().initialize_thread(pthread,a_code,a_code_idx);
      used++;
      return sp_thread_array.used - 1;
   }
}

/*
 * remove from thread list thread description
 */

inline void sp_thread_pool_s::remove(unsigned a_idx)
{
   empty_stack.push(a_idx);
   used--;
}

/*
 * return thread description according index
 */

inline sp_thread_s &sp_thread_pool_s::operator[](unsigned a_idx)
{
   return sp_thread_array[a_idx];
}

// -- sp_mcs_pool_s --
@begin
   inlines "sp_mcs_pool_s";
@end

inline unsigned sp_mcs_pool_s::mutex_insert_new()
{
   if (empty_stack.used != 0) {
      unsigned sp_mutex_idx = empty_stack.pop();
      sp_mcs_array[sp_mutex_idx].set(0,1,0);
      return sp_mutex_idx;
   }
   else {
      sp_mcs_array.push_blank();
      sp_mcs_array.last().set(0,1,0);
      return sp_mcs_array.used - 1;
   }
}

inline void sp_mcs_pool_s::mutex_increase_cnt(unsigned a_idx)
{
   sp_mcs_array[a_idx].ui_second++;
}

inline void sp_mcs_pool_s::mutex_remove(unsigned a_idx)
{
   sp_mcs_s &sp_mutex = sp_mcs_array[a_idx];

   if ((--sp_mutex.ui_second) == 0) {

      // - test if mutex is unlocked -
      err_test(sp_mutex.ui_first == 0,c_R_ERR_LOCKED_MUTEX_DESTROY);
      empty_stack.push(a_idx);
   }
}

inline unsigned sp_mcs_pool_s::condition_insert_new()
{
   if (empty_stack.used != 0) {
      unsigned sp_condition_idx = empty_stack.pop();
      sp_mcs_array[sp_condition_idx].set(0,1,0);
      return sp_condition_idx;
   }
   else {
      sp_mcs_array.push_blank();
      sp_mcs_array.last().set(0,1,0);
      return sp_mcs_array.used - 1;
   }
}

inline void sp_mcs_pool_s::condition_increase_cnt(unsigned a_idx)
{
   sp_mcs_array[a_idx].ui_second++;
}

inline void sp_mcs_pool_s::condition_remove(unsigned a_idx)
{
   sp_mcs_s &sp_condition = sp_mcs_array[a_idx];

   if ((--sp_condition.ui_second) == 0) {
      
      // - test if any thread do not wait on condition -
      err_test(sp_condition.ui_first == 0,c_R_ERR_USED_CONDITION_DESTROY);
      empty_stack.push(a_idx);
   }
}

inline sp_mcs_s &sp_mcs_pool_s::operator[](unsigned a_idx)
{
   return sp_mcs_array[a_idx];
}

// -- script_parser_s --
@begin
   inlines "script_parser_s";
@end

/*
 * retrieve of symbol name index
 */

inline unsigned script_parser_s::get_symbol_name_idx(unsigned a_length,char *a_data)
{
   unsigned n_idx = symbol_names.get_idx_char_ptr(a_length,a_data);

   if (n_idx == c_idx_not_exist) {
      symbol_names.push_blank();
      symbol_names.last().set(a_length,a_data);
      n_idx = symbol_names.used - 1;
   }

   return n_idx;
}

/*
 * remove of temporal variables, created in actual expression
 */

inline void script_parser_s::remove_tmp_values(unsigned a_thread_idx)
{
   ui_array_s &tmp_variables = sp_thread_pool[a_thread_idx].tmp_variables_array.last();

   if (tmp_variables.used != 0) {
      do {
         value_location_pool.free_value(tmp_variables.pop());
      } while(tmp_variables.used > 0);
   }
}

/*
 * definition of global functions
 */

void *new_thread_fun(void *a_ppti);

/*
 * build in functions of interpret
 */

#include "parse_actions.h"
#include "run_actions.h"
#include "build_in.h"

#endif

