
#include "p.script_parser.h"

@begin
   header "script_parser.h";
@end

/*
 * names of argument variables
 */

const char *c_argc_name = "argc";
const char *c_argv_name = "argv";

/*
 * list of names of system constants
 */

const char *c_system_constant_names[c_system_constant_cnt] = {
   "SYSTEM_THREADS",
};

/*
 * list of constant data type names
 */

const char *c_type_constant_names[c_type_constant_cnt] = {
   "TYPE_BLANK",
   "TYPE_CHAR",
   "TYPE_SHORT",
   "TYPE_INT",
   "TYPE_DOUBLE",
   "TYPE_COLOR",
   "TYPE_THREAD",
   "TYPE_STRING",
   "TYPE_LOCAL_IMG",
   "TYPE_CHAR_ARRAY",
   "TYPE_INT_ARRAY",
   "TYPE_DOUBLE_ARRAY",
   "TYPE_OBJ_ARRAY",
   "TYPE_MUTEX",
   "TYPE_CONDITION",
};

/*
 * list of thread function return constant values
 */

const char *c_thread_constant_names[c_thread_constant_cnt] = {
   "THREAD_OK",
   "THREAD_ERR_RESOURCES",
   "THREAD_ERR_SEARCH",
   "THREAD_ERR_INVAL",
   "THREAD_ERR_DEADLK",
};

/*
 * list of mutex function return constant values
 */

const char *c_mutex_constant_names[c_mutex_constant_cnt] = {
   "MUTEX_OK",
   "MUTEX_ERR_DEADLK",
   "MUTEX_ERR_PERM",
   "MUTEX_ERR_UNLOCKED",
   "MUTEX_ERR_BUSY",
};

/*
 * list of condition function return constant values
 */

const char *c_condition_constant_names[c_condition_constant_cnt] = {
   "CONDITION_OK",
   "CONDITION_ERR_TIMEDOUT",
   "CONDITION_ERR_UNKNOWN",
};

/* 
 * methods of generated structures
 */

// -- rc_position_s --
// -- break_continue_pos_s --
// -- source_string_pos_s --
// -- parser_ptr_thread_idx_s --
@begin
   methods "rc_position_s";
@end

// -- rc_position_array_s --
// -- break_continue_pos_array_s --
// -- source_string_pos_array_s --
@begin
   methods "rc_position_array_s";
@end

// -- break_continue_pos_arrays_s --
@begin
   methods "break_continue_pos_arrays_s";
@end

// -- symbols_array_s --
@begin
   methods "symbols_array_s";
@end

// -- symbol_record_s --
@begin
   methods "symbol_record_s";
@end

// -- symbol_records_s --
@begin
   methods "symbol_records_s";
@end

// -- run_code_s --
@begin
   methods "run_code_s";
@end

// -- run_codes_s --
@begin
   methods "run_codes_s";
@end

// -- sp_thread_s --
@begin
   methods "sp_thread_s";
@end

// -- sp_thread_array_s --
@begin
   methods "sp_thread_array_s";
@end

// -- sp_thread_pool_s --
@begin
   methods "sp_thread_pool_s";
@end

// -- sp_mcs_pool_s --
@begin
   methods "sp_mcs_pool_s";
@end

// -- script_parser_s --
@begin
   methods "script_parser_s";
@end

/*
 * function returning source code line, according to state of given thread
 */
unsigned script_parser_s::get_line_number(unsigned a_thread_idx)
{
   rc_position_array_s &rc_position_array = sp_thread_pool[a_thread_idx].rc_position_array;
   rc_position_s &rc_position = rc_position_array.last();
   ui_array_s &source_positions = run_codes[rc_position.ui_first].source_positions;
   
   unsigned *sp_ptr = source_positions.data;
   unsigned *sp_ptr_end = sp_ptr + source_positions.used;
   unsigned line = 0;
   unsigned instr_idx = 0;

   do {
      if ((*sp_ptr & 0x80000000)) {
	 instr_idx += (*sp_ptr) & 0x7fffffff;

	 if (instr_idx > rc_position.ui_second) {
	    return line;
	 }

	 line++;
      }
      else {
	 line = *sp_ptr;
      }
   } while(++sp_ptr < sp_ptr_end);

   return c_idx_not_exist;
}

/*
 * function implementing final automat of lexical analysis
 */
unsigned script_parser_s::recognize_terminal(string_s &source_string,unsigned &input_idx,unsigned &line_cnt)
{
   unsigned source_string_length = source_string.size - 1;

#define GET_NEXT_CHAR() \
{\
   if (input_idx < source_string_length) {\
      in_char = source_string[input_idx];\
   }\
   else {\
      in_char = '\0';\
   }\
}

#define CLOSE_CHAR(RET_TERM_IDX) \
{\
   if (in_char == '\0') {\
      return RET_TERM_IDX;\
   }\
\
   if (in_char == '\n') {\
      line_cnt++;\
   }\
\
   input_idx++;\
}

   unsigned short in_char;

// - STAV 0 - 
   GET_NEXT_CHAR();

   if (in_char == 0)
      goto state_1_label;

   if (in_char >= 9 && in_char < 11)
      goto state_42_label;

   if (in_char == 32)
      goto state_42_label;

   if (in_char == 33)
      goto state_2_label;

   if (in_char == 34)
      goto state_3_label;

   if (in_char == 35)
      goto state_4_label;

   if (in_char == 37)
      goto state_5_label;

   if (in_char == 38)
      goto state_6_label;

   if (in_char == 39)
      goto state_7_label;

   if (in_char == 40)
      goto state_8_label;

   if (in_char == 41)
      goto state_9_label;

   if (in_char == 42)
      goto state_10_label;

   if (in_char == 43)
      goto state_11_label;

   if (in_char == 44)
      goto state_12_label;

   if (in_char == 45)
      goto state_13_label;

   if (in_char == 46)
      goto state_14_label;

   if (in_char == 47)
      goto state_15_label;

   if (in_char == 48)
      goto state_16_label;

   if (in_char >= 49 && in_char < 58)
      goto state_17_label;

   if (in_char == 59)
      goto state_18_label;

   if (in_char == 60)
      goto state_19_label;

   if (in_char == 61)
      goto state_20_label;

   if (in_char == 62)
      goto state_21_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 91)
      goto state_22_label;

   if (in_char == 93)
      goto state_23_label;

   if (in_char == 94)
      goto state_24_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_26_label;

   if (in_char == 98)
      goto state_27_label;

   if (in_char == 99)
      goto state_28_label;

   if (in_char == 100)
      goto state_29_label;

   if (in_char == 101)
      goto state_30_label;

   if (in_char == 102)
      goto state_31_label;

   if (in_char >= 103 && in_char < 105)
      goto state_25_label;

   if (in_char == 105)
      goto state_32_label;

   if (in_char >= 106 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_33_label;

   if (in_char >= 111 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_34_label;

   if (in_char == 115)
      goto state_35_label;

   if (in_char == 116)
      goto state_36_label;

   if (in_char >= 117 && in_char < 119)
      goto state_25_label;

   if (in_char == 119)
      goto state_37_label;

   if (in_char >= 120 && in_char < 123)
      goto state_25_label;

   if (in_char == 123)
      goto state_38_label;

   if (in_char == 124)
      goto state_39_label;

   if (in_char == 125)
      goto state_40_label;

   if (in_char == 126)
      goto state_41_label;

   return c_idx_not_exist;

// - STAV 1 - 
state_1_label:
   CLOSE_CHAR(85)
   return 85;

// - STAV 2 - 
state_2_label:
   CLOSE_CHAR(79)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_44_label;

   return 79;

// - STAV 3 - 
state_3_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 34)
      goto state_3_label;

   if (in_char == 34)
      goto state_45_label;

   if (in_char >= 35 && in_char < 92)
      goto state_3_label;

   if (in_char == 92)
      goto state_46_label;

   if (in_char >= 93 && in_char < 256)
      goto state_3_label;

   return c_idx_not_exist;

// - STAV 4 - 
state_4_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 10)
      goto state_4_label;

   if (in_char == 10)
      goto state_47_label;

   if (in_char >= 11 && in_char < 257)
      goto state_4_label;

   return c_idx_not_exist;

// - STAV 5 - 
state_5_label:
   CLOSE_CHAR(76)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_48_label;

   return 76;

// - STAV 6 - 
state_6_label:
   CLOSE_CHAR(59)
   GET_NEXT_CHAR();

   if (in_char == 38)
      goto state_49_label;

   if (in_char == 61)
      goto state_50_label;

   return 59;

// - STAV 7 - 
state_7_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 92)
      goto state_52_label;

   if (in_char == 92)
      goto state_51_label;

   if (in_char >= 93 && in_char < 257)
      goto state_52_label;

   return c_idx_not_exist;

// - STAV 8 - 
state_8_label:
   CLOSE_CHAR(23)
   return 23;

// - STAV 9 - 
state_9_label:
   CLOSE_CHAR(24)
   return 24;

// - STAV 10 - 
state_10_label:
   CLOSE_CHAR(74)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_53_label;

   return 74;

// - STAV 11 - 
state_11_label:
   CLOSE_CHAR(70)
   GET_NEXT_CHAR();

   if (in_char == 43)
      goto state_54_label;

   if (in_char == 61)
      goto state_55_label;

   return 70;

// - STAV 12 - 
state_12_label:
   CLOSE_CHAR(29)
   return 29;

// - STAV 13 - 
state_13_label:
   CLOSE_CHAR(71)
   GET_NEXT_CHAR();

   if (in_char == 45)
      goto state_56_label;

   if (in_char == 61)
      goto state_57_label;

   if (in_char == 62)
      goto state_58_label;

   return 71;

// - STAV 14 - 
state_14_label:
   CLOSE_CHAR(72)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_59_label;

   return 72;

// - STAV 15 - 
state_15_label:
   CLOSE_CHAR(75)
   GET_NEXT_CHAR();

   if (in_char == 42)
      goto state_60_label;

   if (in_char == 47)
      goto state_61_label;

   if (in_char == 61)
      goto state_62_label;

   return 75;

// - STAV 16 - 
state_16_label:
   CLOSE_CHAR(4)
   GET_NEXT_CHAR();

   if (in_char == 46)
      goto state_63_label;

   if (in_char >= 48 && in_char < 56)
      goto state_64_label;

   if (in_char >= 56 && in_char < 58)
      goto state_43_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 88)
      goto state_66_label;

   if (in_char == 101)
      goto state_65_label;

   if (in_char == 120)
      goto state_66_label;

   return 4;

// - STAV 17 - 
state_17_label:
   CLOSE_CHAR(5)
   GET_NEXT_CHAR();

   if (in_char == 46)
      goto state_63_label;

   if (in_char >= 48 && in_char < 58)
      goto state_17_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 76)
      goto state_67_label;

   if (in_char == 85)
      goto state_68_label;

   if (in_char == 101)
      goto state_65_label;

   if (in_char == 108)
      goto state_67_label;

   if (in_char == 117)
      goto state_68_label;

   return 5;

// - STAV 18 - 
state_18_label:
   CLOSE_CHAR(30)
   return 30;

// - STAV 19 - 
state_19_label:
   CLOSE_CHAR(65)
   GET_NEXT_CHAR();

   if (in_char == 60)
      goto state_69_label;

   if (in_char == 61)
      goto state_70_label;

   return 65;

// - STAV 20 - 
state_20_label:
   CLOSE_CHAR(46)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_71_label;

   return 46;

// - STAV 21 - 
state_21_label:
   CLOSE_CHAR(64)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_72_label;

   if (in_char == 62)
      goto state_73_label;

   return 64;

// - STAV 22 - 
state_22_label:
   CLOSE_CHAR(27)
   return 27;

// - STAV 23 - 
state_23_label:
   CLOSE_CHAR(28)
   return 28;

// - STAV 24 - 
state_24_label:
   CLOSE_CHAR(61)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_74_label;

   return 61;

// - STAV 25 - 
state_25_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 26 - 
state_26_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_75_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 27 - 
state_27_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_76_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 28 - 
state_28_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 104)
      goto state_25_label;

   if (in_char == 104)
      goto state_77_label;

   if (in_char >= 105 && in_char < 111)
      goto state_25_label;

   if (in_char == 111)
      goto state_78_label;

   if (in_char >= 112 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 29 - 
state_29_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 111)
      goto state_25_label;

   if (in_char == 111)
      goto state_79_label;

   if (in_char >= 112 && in_char < 115)
      goto state_25_label;

   if (in_char == 115)
      goto state_80_label;

   if (in_char >= 116 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 30 - 
state_30_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 108)
      goto state_25_label;

   if (in_char == 108)
      goto state_81_label;

   if (in_char >= 109 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 31 - 
state_31_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 117)
      goto state_25_label;

   if (in_char == 117)
      goto state_82_label;

   if (in_char >= 118 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 32 - 
state_32_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 102)
      goto state_25_label;

   if (in_char == 102)
      goto state_83_label;

   if (in_char >= 103 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_84_label;

   if (in_char >= 111 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 33 - 
state_33_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_85_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 34 - 
state_34_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_86_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 35 - 
state_35_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 116)
      goto state_25_label;

   if (in_char == 116)
      goto state_87_label;

   if (in_char >= 117 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 36 - 
state_36_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 104)
      goto state_25_label;

   if (in_char == 104)
      goto state_88_label;

   if (in_char >= 105 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 37 - 
state_37_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 104)
      goto state_25_label;

   if (in_char == 104)
      goto state_89_label;

   if (in_char >= 105 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 38 - 
state_38_label:
   CLOSE_CHAR(25)
   return 25;

// - STAV 39 - 
state_39_label:
   CLOSE_CHAR(60)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_90_label;

   if (in_char == 124)
      goto state_91_label;

   return 60;

// - STAV 40 - 
state_40_label:
   CLOSE_CHAR(26)
   return 26;

// - STAV 41 - 
state_41_label:
   CLOSE_CHAR(80)
   return 80;

// - STAV 42 - 
state_42_label:
   CLOSE_CHAR(81)
   GET_NEXT_CHAR();

   if (in_char >= 9 && in_char < 11)
      goto state_42_label;

   if (in_char == 32)
      goto state_42_label;

   return 81;

// - STAV 43 - 
state_43_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 46)
      goto state_63_label;

   if (in_char >= 48 && in_char < 58)
      goto state_43_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 101)
      goto state_65_label;

   return c_idx_not_exist;

// - STAV 44 - 
state_44_label:
   CLOSE_CHAR(63)
   return 63;

// - STAV 45 - 
state_45_label:
   CLOSE_CHAR(19)
   return 19;

// - STAV 46 - 
state_46_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 34)
      goto state_3_label;

   if (in_char == 39)
      goto state_3_label;

   if (in_char >= 48 && in_char < 56)
      goto state_92_label;

   if (in_char == 63)
      goto state_3_label;

   if (in_char == 92)
      goto state_3_label;

   if (in_char >= 97 && in_char < 99)
      goto state_3_label;

   if (in_char == 102)
      goto state_3_label;

   if (in_char == 110)
      goto state_3_label;

   if (in_char == 114)
      goto state_3_label;

   if (in_char == 116)
      goto state_3_label;

   if (in_char == 118)
      goto state_3_label;

   if (in_char == 120)
      goto state_93_label;

   return c_idx_not_exist;

// - STAV 47 - 
state_47_label:
   CLOSE_CHAR(82)
   return 82;

// - STAV 48 - 
state_48_label:
   CLOSE_CHAR(51)
   return 51;

// - STAV 49 - 
state_49_label:
   CLOSE_CHAR(57)
   return 57;

// - STAV 50 - 
state_50_label:
   CLOSE_CHAR(54)
   return 54;

// - STAV 51 - 
state_51_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 34)
      goto state_94_label;

   if (in_char == 39)
      goto state_95_label;

   if (in_char >= 48 && in_char < 56)
      goto state_96_label;

   if (in_char == 63)
      goto state_94_label;

   if (in_char == 92)
      goto state_94_label;

   if (in_char >= 97 && in_char < 99)
      goto state_94_label;

   if (in_char == 102)
      goto state_94_label;

   if (in_char == 110)
      goto state_94_label;

   if (in_char == 114)
      goto state_94_label;

   if (in_char == 116)
      goto state_94_label;

   if (in_char == 118)
      goto state_94_label;

   if (in_char == 120)
      goto state_97_label;

   return c_idx_not_exist;

// - STAV 52 - 
state_52_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_98_label;

   return c_idx_not_exist;

// - STAV 53 - 
state_53_label:
   CLOSE_CHAR(49)
   return 49;

// - STAV 54 - 
state_54_label:
   CLOSE_CHAR(77)
   return 77;

// - STAV 55 - 
state_55_label:
   CLOSE_CHAR(47)
   return 47;

// - STAV 56 - 
state_56_label:
   CLOSE_CHAR(78)
   return 78;

// - STAV 57 - 
state_57_label:
   CLOSE_CHAR(48)
   return 48;

// - STAV 58 - 
state_58_label:
   CLOSE_CHAR(73)
   return 73;

// - STAV 59 - 
state_59_label:
   CLOSE_CHAR(16)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_59_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 70)
      goto state_99_label;

   if (in_char == 76)
      goto state_100_label;

   if (in_char == 101)
      goto state_65_label;

   if (in_char == 102)
      goto state_99_label;

   if (in_char == 108)
      goto state_100_label;

   return 16;

// - STAV 60 - 
state_60_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 42)
      goto state_60_label;

   if (in_char == 42)
      goto state_101_label;

   if (in_char >= 43 && in_char < 257)
      goto state_60_label;

   return c_idx_not_exist;

// - STAV 61 - 
state_61_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 10)
      goto state_61_label;

   if (in_char == 10)
      goto state_102_label;

   if (in_char >= 11 && in_char < 257)
      goto state_61_label;

   return c_idx_not_exist;

// - STAV 62 - 
state_62_label:
   CLOSE_CHAR(50)
   return 50;

// - STAV 63 - 
state_63_label:
   CLOSE_CHAR(16)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_59_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 70)
      goto state_99_label;

   if (in_char == 76)
      goto state_100_label;

   if (in_char == 101)
      goto state_65_label;

   if (in_char == 102)
      goto state_99_label;

   if (in_char == 108)
      goto state_100_label;

   return 16;

// - STAV 64 - 
state_64_label:
   CLOSE_CHAR(4)
   GET_NEXT_CHAR();

   if (in_char == 46)
      goto state_63_label;

   if (in_char >= 48 && in_char < 56)
      goto state_64_label;

   if (in_char >= 56 && in_char < 58)
      goto state_43_label;

   if (in_char == 69)
      goto state_65_label;

   if (in_char == 76)
      goto state_103_label;

   if (in_char == 85)
      goto state_104_label;

   if (in_char == 101)
      goto state_65_label;

   if (in_char == 108)
      goto state_103_label;

   if (in_char == 117)
      goto state_104_label;

   return 4;

// - STAV 65 - 
state_65_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 43)
      goto state_105_label;

   if (in_char == 45)
      goto state_105_label;

   if (in_char >= 48 && in_char < 58)
      goto state_106_label;

   return c_idx_not_exist;

// - STAV 66 - 
state_66_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_107_label;

   if (in_char >= 65 && in_char < 71)
      goto state_107_label;

   if (in_char >= 97 && in_char < 103)
      goto state_107_label;

   return c_idx_not_exist;

// - STAV 67 - 
state_67_label:
   CLOSE_CHAR(8)
   return 8;

// - STAV 68 - 
state_68_label:
   CLOSE_CHAR(11)
   GET_NEXT_CHAR();

   if (in_char == 76)
      goto state_108_label;

   if (in_char == 108)
      goto state_108_label;

   return 11;

// - STAV 69 - 
state_69_label:
   CLOSE_CHAR(69)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_109_label;

   return 69;

// - STAV 70 - 
state_70_label:
   CLOSE_CHAR(67)
   return 67;

// - STAV 71 - 
state_71_label:
   CLOSE_CHAR(62)
   return 62;

// - STAV 72 - 
state_72_label:
   CLOSE_CHAR(66)
   return 66;

// - STAV 73 - 
state_73_label:
   CLOSE_CHAR(68)
   GET_NEXT_CHAR();

   if (in_char == 61)
      goto state_110_label;

   return 68;

// - STAV 74 - 
state_74_label:
   CLOSE_CHAR(56)
   return 56;

// - STAV 75 - 
state_75_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_111_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 76 - 
state_76_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_112_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 77 - 
state_77_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_113_label;

   if (in_char >= 98 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 78 - 
state_78_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_114_label;

   if (in_char >= 111 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 79 - 
state_79_label:
   CLOSE_CHAR(33)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 117)
      goto state_25_label;

   if (in_char == 117)
      goto state_115_label;

   if (in_char >= 118 && in_char < 123)
      goto state_25_label;

   return 33;

// - STAV 80 - 
state_80_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 112)
      goto state_25_label;

   if (in_char == 112)
      goto state_116_label;

   if (in_char >= 113 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 81 - 
state_81_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 115)
      goto state_25_label;

   if (in_char == 115)
      goto state_117_label;

   if (in_char >= 116 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 82 - 
state_82_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_118_label;

   if (in_char >= 111 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 83 - 
state_83_label:
   CLOSE_CHAR(31)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 31;

// - STAV 84 - 
state_84_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 116)
      goto state_25_label;

   if (in_char == 116)
      goto state_119_label;

   if (in_char >= 117 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 85 - 
state_85_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 119)
      goto state_25_label;

   if (in_char == 119)
      goto state_120_label;

   if (in_char >= 120 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 86 - 
state_86_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 116)
      goto state_25_label;

   if (in_char == 116)
      goto state_121_label;

   if (in_char >= 117 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 87 - 
state_87_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_122_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 88 - 
state_88_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 105)
      goto state_25_label;

   if (in_char == 105)
      goto state_123_label;

   if (in_char >= 106 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_124_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 89 - 
state_89_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 105)
      goto state_25_label;

   if (in_char == 105)
      goto state_125_label;

   if (in_char >= 106 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 90 - 
state_90_label:
   CLOSE_CHAR(55)
   return 55;

// - STAV 91 - 
state_91_label:
   CLOSE_CHAR(58)
   return 58;

// - STAV 92 - 
state_92_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 34)
      goto state_3_label;

   if (in_char == 34)
      goto state_45_label;

   if (in_char >= 35 && in_char < 48)
      goto state_3_label;

   if (in_char >= 48 && in_char < 56)
      goto state_126_label;

   if (in_char >= 56 && in_char < 92)
      goto state_3_label;

   if (in_char == 92)
      goto state_46_label;

   if (in_char >= 93 && in_char < 256)
      goto state_3_label;

   return c_idx_not_exist;

// - STAV 93 - 
state_93_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_127_label;

   if (in_char >= 65 && in_char < 71)
      goto state_127_label;

   if (in_char >= 97 && in_char < 103)
      goto state_127_label;

   return c_idx_not_exist;

// - STAV 94 - 
state_94_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_128_label;

   return c_idx_not_exist;

// - STAV 95 - 
state_95_label:
   CLOSE_CHAR(0)
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_128_label;

   return 0;

// - STAV 96 - 
state_96_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_129_label;

   if (in_char >= 48 && in_char < 56)
      goto state_130_label;

   return c_idx_not_exist;

// - STAV 97 - 
state_97_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_131_label;

   if (in_char >= 65 && in_char < 71)
      goto state_131_label;

   if (in_char >= 97 && in_char < 103)
      goto state_131_label;

   return c_idx_not_exist;

// - STAV 98 - 
state_98_label:
   CLOSE_CHAR(0)
   return 0;

// - STAV 99 - 
state_99_label:
   CLOSE_CHAR(17)
   return 17;

// - STAV 100 - 
state_100_label:
   CLOSE_CHAR(18)
   return 18;

// - STAV 101 - 
state_101_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 47)
      goto state_60_label;

   if (in_char == 47)
      goto state_132_label;

   if (in_char >= 48 && in_char < 257)
      goto state_60_label;

   return c_idx_not_exist;

// - STAV 102 - 
state_102_label:
   CLOSE_CHAR(83)
   return 83;

// - STAV 103 - 
state_103_label:
   CLOSE_CHAR(7)
   return 7;

// - STAV 104 - 
state_104_label:
   CLOSE_CHAR(10)
   GET_NEXT_CHAR();

   if (in_char == 76)
      goto state_133_label;

   if (in_char == 108)
      goto state_133_label;

   return 10;

// - STAV 105 - 
state_105_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_106_label;

   return c_idx_not_exist;

// - STAV 106 - 
state_106_label:
   CLOSE_CHAR(16)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_106_label;

   if (in_char == 70)
      goto state_99_label;

   if (in_char == 76)
      goto state_100_label;

   if (in_char == 102)
      goto state_99_label;

   if (in_char == 108)
      goto state_100_label;

   return 16;

// - STAV 107 - 
state_107_label:
   CLOSE_CHAR(6)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_107_label;

   if (in_char >= 65 && in_char < 71)
      goto state_107_label;

   if (in_char == 76)
      goto state_134_label;

   if (in_char == 85)
      goto state_135_label;

   if (in_char >= 97 && in_char < 103)
      goto state_107_label;

   if (in_char == 108)
      goto state_134_label;

   if (in_char == 117)
      goto state_135_label;

   return 6;

// - STAV 108 - 
state_108_label:
   CLOSE_CHAR(14)
   return 14;

// - STAV 109 - 
state_109_label:
   CLOSE_CHAR(52)
   return 52;

// - STAV 110 - 
state_110_label:
   CLOSE_CHAR(53)
   return 53;

// - STAV 111 - 
state_111_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_136_label;

   if (in_char >= 98 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 112 - 
state_112_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_137_label;

   if (in_char >= 98 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 113 - 
state_113_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_138_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 114 - 
state_114_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 116)
      goto state_25_label;

   if (in_char == 116)
      goto state_139_label;

   if (in_char >= 117 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 115 - 
state_115_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_25_label;

   if (in_char == 98)
      goto state_140_label;

   if (in_char >= 99 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 116 - 
state_116_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_141_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 117 - 
state_117_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_142_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 118 - 
state_118_label:
   CLOSE_CHAR(21)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 21;

// - STAV 119 - 
state_119_label:
   CLOSE_CHAR(43)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 43;

// - STAV 120 - 
state_120_label:
   CLOSE_CHAR(38)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 38;

// - STAV 121 - 
state_121_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 117)
      goto state_25_label;

   if (in_char == 117)
      goto state_143_label;

   if (in_char >= 118 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 122 - 
state_122_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 117)
      goto state_25_label;

   if (in_char == 117)
      goto state_144_label;

   if (in_char >= 118 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 123 - 
state_123_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 115)
      goto state_25_label;

   if (in_char == 115)
      goto state_145_label;

   if (in_char >= 116 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 124 - 
state_124_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_146_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 125 - 
state_125_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 108)
      goto state_25_label;

   if (in_char == 108)
      goto state_147_label;

   if (in_char >= 109 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 126 - 
state_126_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 34)
      goto state_3_label;

   if (in_char == 34)
      goto state_45_label;

   if (in_char >= 35 && in_char < 92)
      goto state_3_label;

   if (in_char == 92)
      goto state_46_label;

   if (in_char >= 93 && in_char < 256)
      goto state_3_label;

   return c_idx_not_exist;

// - STAV 127 - 
state_127_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char < 34)
      goto state_3_label;

   if (in_char == 34)
      goto state_45_label;

   if (in_char >= 35 && in_char < 92)
      goto state_3_label;

   if (in_char == 92)
      goto state_46_label;

   if (in_char >= 93 && in_char < 256)
      goto state_3_label;

   return c_idx_not_exist;

// - STAV 128 - 
state_128_label:
   CLOSE_CHAR(3)
   return 3;

// - STAV 129 - 
state_129_label:
   CLOSE_CHAR(1)
   return 1;

// - STAV 130 - 
state_130_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_129_label;

   if (in_char >= 48 && in_char < 56)
      goto state_148_label;

   return c_idx_not_exist;

// - STAV 131 - 
state_131_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_149_label;

   if (in_char >= 48 && in_char < 58)
      goto state_150_label;

   if (in_char >= 65 && in_char < 71)
      goto state_150_label;

   if (in_char >= 97 && in_char < 103)
      goto state_150_label;

   return c_idx_not_exist;

// - STAV 132 - 
state_132_label:
   CLOSE_CHAR(84)
   return 84;

// - STAV 133 - 
state_133_label:
   CLOSE_CHAR(13)
   return 13;

// - STAV 134 - 
state_134_label:
   CLOSE_CHAR(9)
   return 9;

// - STAV 135 - 
state_135_label:
   CLOSE_CHAR(12)
   GET_NEXT_CHAR();

   if (in_char == 76)
      goto state_151_label;

   if (in_char == 108)
      goto state_151_label;

   return 12;

// - STAV 136 - 
state_136_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 121)
      goto state_25_label;

   if (in_char == 121)
      goto state_152_label;

   if (in_char == 122)
      goto state_25_label;

   return 20;

// - STAV 137 - 
state_137_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 107)
      goto state_25_label;

   if (in_char == 107)
      goto state_153_label;

   if (in_char >= 108 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 138 - 
state_138_label:
   CLOSE_CHAR(42)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 42;

// - STAV 139 - 
state_139_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 105)
      goto state_25_label;

   if (in_char == 105)
      goto state_154_label;

   if (in_char >= 106 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 140 - 
state_140_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 108)
      goto state_25_label;

   if (in_char == 108)
      goto state_155_label;

   if (in_char >= 109 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 141 - 
state_141_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_25_label;

   if (in_char == 98)
      goto state_156_label;

   if (in_char >= 99 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 142 - 
state_142_label:
   CLOSE_CHAR(32)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 32;

// - STAV 143 - 
state_143_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 114)
      goto state_25_label;

   if (in_char == 114)
      goto state_157_label;

   if (in_char >= 115 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 144 - 
state_144_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 99)
      goto state_25_label;

   if (in_char == 99)
      goto state_158_label;

   if (in_char >= 100 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 145 - 
state_145_label:
   CLOSE_CHAR(39)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 39;

// - STAV 146 - 
state_146_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char == 97)
      goto state_159_label;

   if (in_char >= 98 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 147 - 
state_147_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_160_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 148 - 
state_148_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_129_label;

   return c_idx_not_exist;

// - STAV 149 - 
state_149_label:
   CLOSE_CHAR(2)
   return 2;

// - STAV 150 - 
state_150_label:
   CLOSE_CHAR(c_idx_not_exist);
   GET_NEXT_CHAR();

   if (in_char == 39)
      goto state_149_label;

   return c_idx_not_exist;

// - STAV 151 - 
state_151_label:
   CLOSE_CHAR(15)
   return 15;

// - STAV 152 - 
state_152_label:
   CLOSE_CHAR(45)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 45;

// - STAV 153 - 
state_153_label:
   CLOSE_CHAR(35)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 35;

// - STAV 154 - 
state_154_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_161_label;

   if (in_char >= 111 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 155 - 
state_155_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_162_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 156 - 
state_156_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 108)
      goto state_25_label;

   if (in_char == 108)
      goto state_163_label;

   if (in_char >= 109 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 157 - 
state_157_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 110)
      goto state_25_label;

   if (in_char == 110)
      goto state_164_label;

   if (in_char >= 111 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 158 - 
state_158_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 116)
      goto state_25_label;

   if (in_char == 116)
      goto state_165_label;

   if (in_char >= 117 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 159 - 
state_159_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 100)
      goto state_25_label;

   if (in_char == 100)
      goto state_166_label;

   if (in_char >= 101 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 160 - 
state_160_label:
   CLOSE_CHAR(34)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 34;

// - STAV 161 - 
state_161_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 117)
      goto state_25_label;

   if (in_char == 117)
      goto state_167_label;

   if (in_char >= 118 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 162 - 
state_162_label:
   CLOSE_CHAR(44)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 44;

// - STAV 163 - 
state_163_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 111)
      goto state_25_label;

   if (in_char == 111)
      goto state_168_label;

   if (in_char >= 112 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 164 - 
state_164_label:
   CLOSE_CHAR(37)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 37;

// - STAV 165 - 
state_165_label:
   CLOSE_CHAR(22)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 22;

// - STAV 166 - 
state_166_label:
   CLOSE_CHAR(40)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 40;

// - STAV 167 - 
state_167_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 101)
      goto state_25_label;

   if (in_char == 101)
      goto state_169_label;

   if (in_char >= 102 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 168 - 
state_168_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 99)
      goto state_25_label;

   if (in_char == 99)
      goto state_170_label;

   if (in_char >= 100 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 169 - 
state_169_label:
   CLOSE_CHAR(36)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 36;

// - STAV 170 - 
state_170_label:
   CLOSE_CHAR(20)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 107)
      goto state_25_label;

   if (in_char == 107)
      goto state_171_label;

   if (in_char >= 108 && in_char < 123)
      goto state_25_label;

   return 20;

// - STAV 171 - 
state_171_label:
   CLOSE_CHAR(41)
   GET_NEXT_CHAR();

   if (in_char >= 48 && in_char < 58)
      goto state_25_label;

   if (in_char >= 65 && in_char < 91)
      goto state_25_label;

   if (in_char == 95)
      goto state_25_label;

   if (in_char >= 97 && in_char < 123)
      goto state_25_label;

   return 41;

}

/*
 * function implementing syntactic analysis
 */
void script_parser_s::parse_script(string_s &source_string)
{
   unsigned old_input_idx = 0;
   unsigned input_idx = 0;
   line_cnt = 1;
   unsigned old_line_cnt = line_cnt;
   instr_per_line = 0;
   unsigned ret_term = c_idx_not_exist;

   do {

      // - store of information about mapping code to source file -
      if (old_line_cnt < line_cnt) {
	 ui_array_s &source_positions = run_codes[pc_idx_stack.last()].source_positions;

	 // - store of instruction count per line -
	 if (instr_per_line > 0) {
	    source_positions.push(0x80000000 | instr_per_line);
	    old_line_cnt++;
	 }

	 // - store of jump to line number -
	 if (old_line_cnt < line_cnt) {
	    if (!(source_positions.last() & 0x80000000)) {
	       source_positions.last() = line_cnt;
	    }
	    else {
	       source_positions.push(line_cnt);
	    }
	    
	    old_line_cnt = line_cnt;
	 }

	 instr_per_line = 0;
      }

      // - retrieve of next terminal symbol -
      while (ret_term == c_idx_not_exist) {
         old_input_idx = input_idx;

         ret_term = recognize_terminal(source_string,input_idx,line_cnt);

	 // - test of returned terminal - 
	 if (ret_term == c_idx_not_exist) {
	    source_string.data[input_idx + 1] = '\0';
	    err_test2(0,c_P_ERR_UNRECOGNIZABLE_TERMINAL,line_cnt,(unsigned)(source_string.data + old_input_idx));
	 }

         if (ret_term == 81 || ret_term == 82 || ret_term == 83 || ret_term == 84) {
            ret_term = c_idx_not_exist;
         }
      }

      // - retrieve of action from table of actions -
      unsigned parse_action = lalr_table[lalr_stack.last().ui_first*c_terminal_plus_nonterminal_cnt + ret_term];
      if (parse_action == c_idx_not_exist) {
	 source_string.data[input_idx] = '\0';
	 err_test2(0,c_P_ERR_WRONG_PROGRAM_SYNTAX,line_cnt,(unsigned)(source_string.data + old_input_idx));
      }

      // - action SHIFT -
      if (parse_action < c_lalr_table_reduce_base) {

         if (ret_term == 85) {
	    
	    // - insertion of instruction ending the flow -
	    run_code_s &run_code = run_codes[pc_idx_stack.last()];

	    run_code.code.push(i_flow_end); instr_per_line++;
            break;
         }

	 if (ret_term == 41) {
	    assert(0);
	 }

	 // - insertion of state, and terminal position in source string -
         lalr_stack.push(parse_action,old_input_idx,input_idx);
         ret_term = c_idx_not_exist;
      }

      // - action REDUCE-
      else {
         parse_action -= c_lalr_table_reduce_base;

	 // - print of reduction rule index to stdout -
         //printf("%d, ",parse_action);

	 // - call of assigned function to reduction -
	 if (script_pa_callers[parse_action] != pa_null) {
	    script_pa_callers[parse_action](source_string,*this);
	 }

	 // - remove of rule body from lalr_stack -
         lalr_stack.used -= rule_body_lengths[parse_action];

	 // - insert of new automat state to stack -
         unsigned goto_val = lalr_table[lalr_stack.last().ui_first*c_terminal_plus_nonterminal_cnt + rule_head_idxs[parse_action]];
         lalr_stack.push(goto_val);
      }

   } while(1);
}

/*
 * create list of build in symbols in symbol record
 */

void script_parser_s::create_build_in_symbols()
{
   // - fill of structure describing symbol names -
   char **bin_ptr = (char **)c_build_in_symbol_names;
   char **bin_ptr_end = bin_ptr + c_bi_all_cnt;

   do {
      symbol_names.push_blank();
      symbol_names.last().set(strlen(*bin_ptr),*bin_ptr);
   } while(++bin_ptr < bin_ptr_end);

   // - insertion of build in functions to main symbol record -
   symbols_s &global_fun_symbols = symbol_records[0].symbols_array[c_symbol_type_function];

   unsigned bi_fun_idx = 0;
   do {
      global_fun_symbols.push_blank();
      global_fun_symbols.last().set(c_bi_global_method_n_idxs[bi_fun_idx],c_bi_global_method_base + bi_fun_idx,c_idx_not_exist);
   } while(++bi_fun_idx < c_bi_global_method_cnt);

   // - insertion of build in structures to main symbol record -
   symbols_s &struct_symbols = symbol_records[0].symbols_array[c_symbol_type_structure];
  
   unsigned struct_idx = 0;
   do {
      struct_symbols.push_blank();
      struct_symbols.last().set(c_bi_struct_blank_s + struct_idx,0,c_bis_blank_s_record_idx + struct_idx);
   } while(++struct_idx < c_bi_struct_cnt);

   // - create of record of structure blank_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_blank_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_blank_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_blank_s_method_n_idxs[f_idx],c_bis_blank_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_blank_s_method_cnt);
   }

   // - create of record of structure char_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_char_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_char_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_char_s_method_n_idxs[f_idx],c_bis_char_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_char_s_method_cnt);
   }

   // - create of record of structure short_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_short_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_short_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_short_s_method_n_idxs[f_idx],c_bis_short_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_short_s_method_cnt);
   }

   // - create of record of structure int_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_int_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_int_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_int_s_method_n_idxs[f_idx],c_bis_int_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_int_s_method_cnt);
   }

   // - create of record of structure double_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_double_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_double_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_double_s_method_n_idxs[f_idx],c_bis_double_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_double_s_method_cnt);
   }

   // - create of record of structure color_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_color_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_color_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_color_s_method_n_idxs[f_idx],c_bis_color_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_color_s_method_cnt);
   }

   // - create of record of structure thread_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_thread_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_thread_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_thread_s_method_n_idxs[f_idx],c_bis_thread_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_thread_s_method_cnt);
   }

   // - create of record of structure string_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_string_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_string_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_string_s_method_n_idxs[f_idx],c_bis_string_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_string_s_method_cnt);
   }
   
   // - create of record of structure local_img_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_local_img_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_local_img_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_local_img_s_method_n_idxs[f_idx],c_bis_local_img_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_local_img_s_method_cnt);
   }

   // - create of record of structure char_array_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_char_array_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_char_array_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_char_array_s_method_n_idxs[f_idx],c_bis_char_array_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_char_array_s_method_cnt);
   }

   // - create of record of structure int_array_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_int_array_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_int_array_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_int_array_s_method_n_idxs[f_idx],c_bis_int_array_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_int_array_s_method_cnt);
   }

   // - create of record of structure double_array_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_double_array_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_double_array_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_double_array_s_method_n_idxs[f_idx],c_bis_double_array_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_double_array_s_method_cnt);
   }

   // - create of record of structure obj_array_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_obj_array_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_obj_array_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_obj_array_s_method_n_idxs[f_idx],c_bis_obj_array_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_obj_array_s_method_cnt);
   }

   // - create of record of structure mutex_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_mutex_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_mutex_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_mutex_s_method_n_idxs[f_idx],c_bis_mutex_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_mutex_s_method_cnt);
   }

   // - create of record of structure condition_s -
   {
      symbol_records.push_blank();
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = 0;
      record.p_symbol_type = c_symbol_type_structure;
      record.p_symbol_idx = c_bi_struct_condition_s;

      symbols_array_s &symbols_array = record.symbols_array;
      symbols_array.copy_resize(c_symbol_type_cnt);
      symbols_array.used = c_symbol_type_cnt;

      symbols_s &fun_symbols = symbols_array[c_symbol_type_function];
      fun_symbols.copy_resize(c_bis_condition_s_method_cnt);

      unsigned f_idx = 0;
      do {
	 fun_symbols.push_blank();
	 fun_symbols.last().set(c_bis_condition_s_method_n_idxs[f_idx],c_bis_condition_s_method_base + f_idx,c_idx_not_exist);
      } while(++f_idx < c_bis_condition_s_method_cnt);
   }
}

/*
 * initialization of parser for parse of a new script
 */

void script_parser_s::initialize_parser(int argc,char **argv)
{
   symbol_names.clear();

   symbol_records.clear();
   symbol_records.push_blank();

   {
      symbol_record_s &record = symbol_records.last();

      record.p_record_idx = c_idx_not_exist;
      record.p_symbol_type = c_idx_not_exist;
      record.p_symbol_idx = c_idx_not_exist;

      record.symbols_array.copy_resize(c_symbol_type_cnt);
      record.symbols_array.used = c_symbol_type_cnt;
   }

   sa_idx_stack.clear();
   sa_idx_stack.push(0);

   value_location_pool.final_free_all_values();
   value_location_pool.clear();
   value_location_pool.script_parser_ptr = (unsigned)this;

   run_codes.clear();
   run_codes.push_blank();
   run_codes[0].source_positions.push(0);

   lalr_stack.clear();
   lalr_stack.push(0);

   tmp_sm_name_pos_array.clear();

   fm_param_cnt.clear();
   jmp_code_idxs.clear();

   break_pos_arrays.clear();
   continue_pos_arrays.clear();

   pc_idx_stack.clear();
   pc_idx_stack.push(0);

   global_variables.clear();

   sp_thread_pool.clear();
   sp_thread_pool.used = 0;

   multiple_threads = false;

   create_build_in_symbols();

   // - build in constant identifiers -
   unsigned n_idx;
   unsigned location_idx;
   symbols_s &symbols = symbol_records[0].symbols_array[c_symbol_type_local_variable];

   // - system constants -
   {
      unsigned idx = 0;
      do {
	 char *const_name = (char *)c_system_constant_names[idx];

	 n_idx = get_symbol_name_idx(strlen(const_name),const_name);
	 symbols.push_blank();
	 symbols.last().set(n_idx,0,0);

	 location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(c_sc_SYSTEM_THREADS + idx),c_value_modifier_NOTHING);
	 global_variables.push(location_idx);
      } while(++idx < c_system_constant_cnt);
   }

   // - return values of mutex functions -
   {
      unsigned idx = 0;
      do {
	 char *const_name = (char *)c_mutex_constant_names[idx];

	 n_idx = get_symbol_name_idx(strlen(const_name),const_name);
	 symbols.push_blank();
	 symbols.last().set(n_idx,0,0);

	 location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(c_mc_MUTEX_OK + idx),c_value_modifier_NOTHING);
	 global_variables.push(location_idx);
      } while(++idx < c_mutex_constant_cnt);
   }

   // - return values of condition functions -
   {
      unsigned idx = 0;
      do {
	 char *const_name = (char *)c_condition_constant_names[idx];

	 n_idx = get_symbol_name_idx(strlen(const_name),const_name);
	 symbols.push_blank();
	 symbols.last().set(n_idx,0,0);

	 location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(c_cc_CONDITION_OK + idx),c_value_modifier_NOTHING);
	 global_variables.push(location_idx);
      } while(++idx < c_condition_constant_cnt);
   }

   // - return values of thread functions -
   {
      unsigned idx = 0;
      do {
	 char *const_name = (char *)c_thread_constant_names[idx];

	 n_idx = get_symbol_name_idx(strlen(const_name),const_name);
	 symbols.push_blank();
	 symbols.last().set(n_idx,0,0);

	 location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(c_tc_THREAD_OK + idx),c_value_modifier_NOTHING);
	 global_variables.push(location_idx);
      } while(++idx < c_thread_constant_cnt);
   }

   // - constant values describing variables types -
   {
      unsigned idx = 0;
      do {
	 char *const_name = (char *)c_type_constant_names[idx];

	 n_idx = get_symbol_name_idx(strlen(const_name),const_name);
	 symbols.push_blank();
	 symbols.last().set(n_idx,0,0);

	 location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(c_tc_TYPE_BLANK + idx),c_value_modifier_NOTHING);
	 global_variables.push(location_idx);
      } while(++idx < c_type_constant_cnt);
   }

   // - variables used for parameter handling -
   {
      
      // - argc variable -
      n_idx = get_symbol_name_idx(strlen(c_argc_name),(char *)c_argc_name);
      symbols.push_blank();
      symbols.last().set(n_idx,0,0);

      location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)(argc > 2?argc - 2:0),c_value_modifier_NOTHING);
      global_variables.push(location_idx);

      // - argv array -
      ui_array_s *argv_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
      argv_array_ptr->init();

      if (argc > 2) {
	 unsigned idx = 2;

	 do {
	    string_s *arg_string_ptr = (string_s *)cmalloc(sizeof(string_s));
	    arg_string_ptr->init();
	    arg_string_ptr->set(strlen(argv[idx]),argv[idx]);
	    
	    location_idx = value_location_pool.insert(c_value_type_STRING,(unsigned long long)(unsigned)arg_string_ptr,c_value_modifier_NOTHING);

	    argv_array_ptr->push(location_idx);
	 } while(++idx < (unsigned)argc);
      }

      n_idx = get_symbol_name_idx(strlen(c_argv_name),(char *)c_argv_name);
      symbols.push_blank();
      symbols.last().set(n_idx,0,0);

      location_idx = value_location_pool.insert(c_value_type_OBJ_ARRAY,(unsigned long long)(unsigned)argv_array_ptr,c_value_modifier_NOTHING);
      global_variables.push(location_idx);
   }
}

/*
 * run code by new created thread
 */

void script_parser_s::run_thread(unsigned a_thread_idx)
{
   do {

      // - LOCK -
      if (multiple_threads) {
	 mutex.lock();
      }

      rc_position_array_s &rc_position_array = sp_thread_pool[a_thread_idx].rc_position_array;

      rc_position_s &rc_position = rc_position_array.last();
      ui_array_s &code = run_codes[rc_position.ui_first].code;

      if (rc_position.ui_second < code.used) {
	 unsigned instruction = code[rc_position.ui_second++];
	 script_ra_callers[instruction](code,rc_position.ui_second,a_thread_idx,*this);

	 // - UNLOCK -
	 if (multiple_threads) {
	    mutex.unlock();
	 }
      }
      else {
	 rc_position_array.pop();

	 // - test if thread ends in same code as in which begins -
	 assert(rc_position_array.used == 0);

	 sp_thread_s &sp_thread = sp_thread_pool[a_thread_idx];

	 // - test of thread run state -
	 switch (sp_thread.state) {
	 case c_thread_state_JOINABLE:

	    // - set of thread state to ended -
	    sp_thread.state = c_thread_state_JOINABLE_ENDED;

	    break;
	 case c_thread_state_JOINED:
	    
	    // - set of thread state to ended -
	    sp_thread.state = c_thread_state_JOINED_ENDED;

	    break;
	 case c_thread_state_DETACHED:

	    // - set of thread state to ended -
	    sp_thread.state = c_thread_state_NOT_EXIST;

	    // - remove of description of detached thread -
	    sp_thread_pool.remove(a_thread_idx);

	    break;
	 default:
	    assert(0);
	 }

	 // - UNLOCK -
	 if (multiple_threads) {
	    mutex.unlock();
	 }

	 break;
      }

   } while(1);
}

/*
 * run main code flow (run main thread)
 */

void script_parser_s::run_main_thread(unsigned a_thread_idx)
{
   do {

      // - LOCK -
      if (multiple_threads) {
	 mutex.lock();
      }

      // - process of next code instruction -
      rc_position_array_s &rc_position_array = sp_thread_pool[a_thread_idx].rc_position_array;

      rc_position_s &rc_position = rc_position_array.last();
      ui_array_s &code = run_codes[rc_position.ui_first].code;

      if (rc_position.ui_second < code.used) {
	 unsigned instruction = code[rc_position.ui_second++];
	 script_ra_callers[instruction](code,rc_position.ui_second,a_thread_idx,*this);

	 // - UNLOCK -
	 if (multiple_threads) {
	    mutex.unlock();
	 }
      }
      else {
	 rc_position_array.pop();

	 // - test if thread ens in same code in which begins -
	 assert(rc_position_array.used == 0);

	 // - set main thread run state as non existing -
	 sp_thread_pool[a_thread_idx].state = c_thread_state_NOT_EXIST;

	 // - remove of description of main thread -
	 sp_thread_pool.remove(a_thread_idx);

	 // - UNLOCK -
	 if (multiple_threads) {
	    mutex.unlock();
	 }
	 break;
      }

   } while(1);

   // - waiting on end of all created threads -
   if (sp_thread_pool.used > 0) {

      do {
	 
	 // - YIELD -
	 pthread_yield();
      } while(sp_thread_pool.used > 0);
   }
}

/*
 * global functions
 */

/*
 * function which starts newly created threads
 */

void *new_thread_fun(void *a_ppti)
{
   parser_ptr_thread_idx_s *ppti = (parser_ptr_thread_idx_s *)a_ppti;

   ((script_parser_s *)ppti->ui_first)->run_thread(ppti->ui_second);
   cfree(a_ppti);

   return NULL;
}

