
#include "p.script_parser.h"

/*
 * definitions and constants
 */

unsigned const c_function_name_max_length = 256;
const char *c_function_name_format = "%s#%u";

/*
 * array of callers of parse action functions
 */

const unsigned c_script_parse_action_cnt = 150;
void(*script_pa_callers[c_script_parse_action_cnt])(string_s &source_string,script_parser_s &_this) = {
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_definition_struct_end,
   pa_definition_struct_begin,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_definition_struct_variable,
   pa_definition_struct_variable,
   pa_definition_fun_end,
   pa_definition_fun_begin,
   pa_definition_fun_params,
   pa_definition_fun_params,
   pa_null,
   pa_null,
   pa_definition_fun_parameter,
   pa_definition_fun_ref_parameter,
   pa_null,
   pa_null,
   pa_null,
   pa_definition_cmd_block_end,
   pa_definition_cmd_block_begin,
   pa_null,
   pa_null,
   pa_null,
   pa_if_end,
   pa_if_cond,
   pa_null,
   pa_null,
   pa_if_else,
   pa_null,
   pa_do_begin,
   pa_do_cond,
   pa_do_exp,
   pa_while_end,
   pa_while_cond,
   pa_while_exp,
   pa_cmd_break,
   pa_cmd_continue,
   pa_cmd_return,
   pa_exp_end,
   pa_null,
   pa_operator_binary_equal,
   pa_operator_binary_plus_equal,
   pa_operator_binary_minus_equal,
   pa_operator_binary_asterisk_equal,
   pa_operator_binary_slash_equal,
   pa_operator_binary_percent_equal,
   pa_operator_binary_double_ls_br_equal,
   pa_operator_binary_double_rs_br_equal,
   pa_operator_binary_ampersand_equal,
   pa_operator_binary_pipe_equal,
   pa_operator_binary_circumflex_equal,
   pa_null,
   pa_operator_binary_double_ampersand,
   pa_operator_binary_double_pipe,
   pa_null,
   pa_operator_binary_ampersand,
   pa_operator_binary_pipe,
   pa_operator_binary_circumflex,
   pa_null,
   pa_operator_binary_double_equal,
   pa_operator_binary_exclamation_equal,
   pa_operator_binary_rs_br,
   pa_operator_binary_ls_br,
   pa_operator_binary_rs_br_equal,
   pa_operator_binary_ls_br_equal,
   pa_null,
   pa_operator_binary_double_rs_br,
   pa_operator_binary_double_ls_br,
   pa_null,
   pa_operator_binary_plus,
   pa_operator_binary_minus,
   pa_null,
   pa_operator_binary_asterisk,
   pa_operator_binary_slash,
   pa_operator_binary_percent,
   pa_operator_unary_post_double_plus,
   pa_operator_unary_post_double_minus,
   pa_operator_unary_pre_double_plus,
   pa_operator_unary_pre_double_minus,
   pa_operator_unary_pre_plus,
   pa_operator_unary_pre_minus,
   pa_operator_unary_pre_exclamation,
   pa_operator_unary_pre_tilde,
   pa_null,
   pa_operator_binary_le_br_re_br,
   pa_identifier,
   pa_function_call,
   pa_null,
   pa_null,
   pa_fcall_param_begin,
   pa_fcall_parameter,
   pa_fcall_parameter,
   pa_struct_element,
   pa_method_call,
   pa_struct_member,
   pa_null,
   pa_null,
   pa_mcall_param_begin,
   pa_mcall_parameter,
   pa_mcall_parameter,
   pa_new_object,
   pa_this,
   pa_thread_def_end,
   pa_thread_def_begin,
   pa_thread_def_parameters,
   pa_thread_def_parameters,
   pa_thread_parameter,
   pa_thread_parameter,
   pa_null,
   pa_null,
   pa_null,
   pa_null,
   pa_new_char_array,
   pa_new_int_array,
   pa_new_double_array,
   pa_new_array,
   pa_null,
   pa_null,
   pa_array_element,
   pa_array_element,
   pa_single_char_const,
   pa_octal_char_const,
   pa_hex_char_const,
   pa_backslash_char_const,
   pa_oct_int_const,
   pa_dec_int_const,
   pa_hex_int_const,
   pa_oct_long_int_const,
   pa_dec_long_int_const,
   pa_hex_long_int_const,
   pa_oct_unsigned_int_const,
   pa_dec_unsigned_int_const,
   pa_hex_unsigned_int_const,
   pa_oct_unsigned_long_int_const,
   pa_dec_unsigned_long_int_const,
   pa_hex_unsigned_long_int_const,
   pa_double_const,
   pa_float_const,
   pa_long_double_const,
   pa_string_const,
   pa_null,
};

/*
 * functions which implements parse actions of the parser
 */

/*
 * blank function which was originally called by null reductions by parser
 */

void pa_null(string_s &source_string,script_parser_s &_this)
{
}

/*
 * processing of the end of structure definition
 */

void pa_definition_struct_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;

   // *****

   // - remove last index from "symbol_actual_index stack" -
   sa_idx_stack.pop();
}

/*
 * processing of beginning of structure definition
 */

void pa_definition_struct_begin(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;

   // *****

   // - retrieval of structure name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieval of structure name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   symbol_records.push_blank();

   // - store of structure symbol to actual symbol record -
   symbol_record_s &record = symbol_records[sa_idx_stack.last()];
   symbols_s &symbols = record.symbols_array[c_symbol_type_structure];

   // - test if name symbol is unique -
   unsigned s_idx = symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Structure",(unsigned)_this.symbol_names[n_idx].data);

   symbols.push_blank();
   symbols.last().set(n_idx,0,symbol_records.used - 1);

   // - setting of new structure symbol record -
   symbol_record_s &new_record = symbol_records.last();
   new_record.p_record_idx = sa_idx_stack.last();
   new_record.p_symbol_type = c_symbol_type_structure;
   new_record.p_symbol_idx = symbols.used - 1;

   symbols_array_s &new_symbols_array = new_record.symbols_array;
   new_symbols_array.copy_resize(c_symbol_type_cnt);
   new_symbols_array.used = c_symbol_type_cnt;

   // - push new symbol record index at "symbol actual index stack" -
   sa_idx_stack.push(symbol_records.used - 1);
}

/*
 * processing of structure variables
 */

void pa_definition_struct_variable(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;

   // *****

   // - retrieval of variable name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieval of name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - store of index name to symbol record -
   symbol_record_s &record = symbol_records[sa_idx_stack.last()];
   symbols_s &symbols = record.symbols_array[c_symbol_type_struct_variable];

   unsigned s_idx = symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Structure variable",(unsigned)_this.symbol_names[n_idx].data);

   symbols.push_blank();
   symbols.last().set(n_idx,0,0);
}

/*
 * process of end of function definition
 */

void pa_definition_fun_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - remove of idx of symbol record of function from "symbol actual index stack" -
   sa_idx_stack.pop();

   // - insertion of instruction terminating function code -
   run_code.code.push(i_return); _this.instr_per_line++;

   // - remove function code index from "parse code index stack" (return to previous code) -
   pc_idx_stack.pop();
}

/*
 * process of begin of function definition
 */

void pa_definition_fun_begin(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   source_string_pos_s &tmp_fun_name_pos = _this.tmp_fun_name_pos;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   run_codes_s &run_codes = _this.run_codes;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;

   // *****

   // - retrieve of function temporary name -
   lalr_stack_element_s &lse = lalr_stack.last();
   tmp_fun_name_pos.ui_first = lse.ui_second;
   tmp_fun_name_pos.ui_second = lse.ui_third;
   
   symbol_records.push_blank();

   // - insertion of function symbol to symbol record, it will be filled after obtaining all parameter information -
   symbols_s &symbols = symbol_records[sa_idx_stack.last()].symbols_array[c_symbol_type_function];
   symbols.push_blank();
   symbols.last().ui_first = c_idx_not_exist;

   // - creation of new symbol record bound to function -
   symbol_record_s &new_record = symbol_records.last();
   new_record.p_record_idx = sa_idx_stack.last();
   new_record.p_symbol_type = c_symbol_type_function;
   new_record.p_symbol_idx = symbols.used - 1;

   symbols_array_s &new_symbols_array = new_record.symbols_array;
   new_symbols_array.copy_resize(c_symbol_type_cnt);
   new_symbols_array.used = c_symbol_type_cnt;

   // - push index of new record of symbols to "symbol actual index stack" -
   sa_idx_stack.push(symbol_records.used - 1);

   // - creation of new (so far blank) code of function, and its insertion to "parse code index stack" -
   run_codes.push_blank();
   run_codes.last().source_positions.push(_this.line_cnt);

   pc_idx_stack.push(run_codes.used - 1);
}

/*
 * process of function definition after retrieve of all parameters
 */

void pa_definition_fun_params(string_s &source_string,script_parser_s &_this)
{
   source_string_pos_s &tmp_fun_name_pos = _this.tmp_fun_name_pos;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;

   // *****

   unsigned fun_record_idx = sa_idx_stack.last();
   unsigned fun_param_cnt = symbol_records[fun_record_idx].symbols_array[c_symbol_type_fun_param].used;

   // - creation of name function -
   char new_name_data[c_function_name_max_length];

   char tmp_char = source_string[tmp_fun_name_pos.ui_second];
   source_string[tmp_fun_name_pos.ui_second] = '\0';

   unsigned new_name_length = snprintf(new_name_data,c_function_name_max_length,c_function_name_format,source_string.data + tmp_fun_name_pos.ui_first,fun_param_cnt);

   // - string size exceed test -
   err_test3(new_name_length < c_function_name_max_length,c_DP_ERR_FUN_NAME_EXCEED_MAX_SIZE,_this.line_cnt,(unsigned)"Function",(unsigned)(source_string.data + tmp_fun_name_pos.ui_first));

   source_string[tmp_fun_name_pos.ui_second] = tmp_char;

   // - retrieval of function name index -
   unsigned n_idx = _this.get_symbol_name_idx(new_name_length,new_name_data);

   // - insert of additional information to function symbol -
   symbol_record_s &record = symbol_records[sa_idx_stack[sa_idx_stack.used - 2]];
   symbols_s &symbols = record.symbols_array[c_symbol_type_function];

   // - test of function uniqueness -
   unsigned n_idx_test = symbols.get_idx_by_ui_first(n_idx);
   err_test3(n_idx_test == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Function",(unsigned)_this.symbol_names[n_idx].data);

   symbol_s &symbol = symbols.last();
   symbol.set(n_idx,pc_idx_stack.last(),fun_record_idx);
}

/*
 * process of function parameter
 */

void pa_definition_fun_parameter(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;

   // *****

   // - retrieval of parameter name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieval of parameter name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - insertion of parameter name index to record -
   symbol_record_s &record = symbol_records[sa_idx_stack.last()];
   symbols_s &symbols = record.symbols_array[c_symbol_type_fun_param];

   // - test of function parameter uniqueness -
   unsigned s_idx = symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Function parameter",(unsigned)_this.symbol_names[n_idx].data);

   symbols.push_blank();
   symbols.last().set(n_idx,c_parm_symbol_type_copy,0);
}

/*
 * process of function parameter which is passed as reference
 */

void pa_definition_fun_ref_parameter(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;

   // *****

   // - retrieve of parameter name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieve of parameter name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - insertion of name index to actual symbol record -
   symbol_record_s &record = symbol_records[sa_idx_stack.last()];
   symbols_s &symbols = record.symbols_array[c_symbol_type_fun_param];

   // - test of function parameter uniqueness -
   unsigned s_idx = symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Function parameter",(unsigned)_this.symbol_names[n_idx].data);

   symbols.push_blank();
   symbols.last().set(n_idx,c_parm_symbol_type_ref,0);
}

/*
 * process of end of nested command block
 */

void pa_definition_cmd_block_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   sa_idx_stack.pop();

   run_code.code.push(i_cmd_block_end); _this.instr_per_line++;
}

/*
 * process of begin of nested command block
 */

void pa_definition_cmd_block_begin(string_s &source_string,script_parser_s &_this)
{
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - creation of new record of symbols -
   symbol_records.push_blank();

   symbol_record_s &new_record = symbol_records.last();
   new_record.p_record_idx = c_idx_not_exist;
   new_record.p_symbol_type = c_idx_not_exist;
   new_record.p_symbol_idx = c_idx_not_exist;

   symbols_array_s &new_symbols_array = new_record.symbols_array;
   new_symbols_array.copy_resize(c_symbol_type_cnt);
   new_symbols_array.used = c_symbol_type_cnt;

   // - insertion of new record to record stack -
   sa_idx_stack.push(symbol_records.used - 1);

   run_code.code.push(i_cmd_block_begin); _this.instr_per_line++;
}

/*
 * process of end of "if" statement
 */

void pa_if_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - setting of jump target to instruction after "if" body -
   run_code.code[jmp_code_idxs.pop()] = run_code.code.used;
}

/*
 * process of condition of "if" statement
 */

void pa_if_cond(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - insert instructions to code -
   run_code.code.push(i_false_jmp); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;

   jmp_code_idxs.push(run_code.code.used - 1);
}

/*
 * process of "else" part of "if" statement
 */

void pa_if_else(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_jmp); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   
   run_code.code[jmp_code_idxs.pop()] = run_code.code.used;
   jmp_code_idxs.push(run_code.code.used - 1);
}

/*
 * process of begin of cycle "do_while"
 */

void pa_do_begin(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &break_pos_arrays = _this.break_pos_arrays;
   break_continue_pos_arrays_s &continue_pos_arrays = _this.continue_pos_arrays;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   break_pos_arrays.push_blank();
   break_pos_arrays.last().used = 0;

   continue_pos_arrays.push_blank();
   continue_pos_arrays.last().used = 0;

   jmp_code_idxs.push(run_code.code.used);
}

/*
 * process of condition of cycle "do_while"
 */

void pa_do_cond(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &break_pos_arrays = _this.break_pos_arrays;
   break_continue_pos_arrays_s &continue_pos_arrays = _this.continue_pos_arrays;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire target of continue jumps -
   unsigned continue_code_idx = jmp_code_idxs.pop();

   // - process of recorded continue commands -
   break_continue_pos_array_s &continue_array = continue_pos_arrays.pop();

   if (continue_array.used != 0) {
      unsigned c_idx = 0;
      do {
	 break_continue_pos_s &continue_pos = continue_array[c_idx];

	 run_code.code[continue_pos.ui_second] = continue_pos.ui_first - sa_idx_stack.used;
	 run_code.code[continue_pos.ui_second + 1] = continue_code_idx;
      } while(++c_idx < continue_array.used);
   }

   // - loop jumps -
   run_code.code.push(i_true_jmp); _this.instr_per_line++;
   run_code.code.push(jmp_code_idxs.pop()); _this.instr_per_line++;

   // - process of recorded break commands -
   break_continue_pos_array_s &break_array = break_pos_arrays.pop();

   if (break_array.used != 0) {
      unsigned b_idx = 0;
      do {
	 break_continue_pos_s &break_pos = break_array[b_idx];

	 run_code.code[break_pos.ui_second] = break_pos.ui_first - sa_idx_stack.used;
	 run_code.code[break_pos.ui_second + 1] = run_code.code.used;
      } while(++b_idx < break_array.used);
   }
}

/*
 * process of begin of expression of cycle "do_while"
 */

void pa_do_exp(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   jmp_code_idxs.push(run_code.code.used);
}

/*
 * process of end of cycle while
 */

void pa_while_end(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &break_pos_arrays = _this.break_pos_arrays;
   break_continue_pos_arrays_s &continue_pos_arrays = _this.continue_pos_arrays;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   unsigned cond_jmp_idx = jmp_code_idxs.pop();
   unsigned continue_code_idx = jmp_code_idxs.pop();

   // - process of recorded continue commands -
   break_continue_pos_array_s &continue_array = continue_pos_arrays.pop();

   if (continue_array.used != 0) {
      unsigned c_idx = 0;
      do {
	 break_continue_pos_s &continue_pos = continue_array[c_idx];

	 run_code.code[continue_pos.ui_second] = continue_pos.ui_first - sa_idx_stack.used;
	 run_code.code[continue_pos.ui_second + 1] = continue_code_idx;
      } while(++c_idx < continue_array.used);
   }

   // - process of loop jump -
   run_code.code.push(i_jmp); _this.instr_per_line++;
   run_code.code.push(continue_code_idx); _this.instr_per_line++;

   run_code.code[cond_jmp_idx] = run_code.code.used;

   // - process of recorded break commands -
   break_continue_pos_array_s &break_array = break_pos_arrays.pop();

   if (break_array.used != 0) {
      unsigned b_idx = 0;
      do {
	 break_continue_pos_s &break_pos = break_array[b_idx];

	 run_code.code[break_pos.ui_second] = break_pos.ui_first - sa_idx_stack.used;
	 run_code.code[break_pos.ui_second + 1] = run_code.code.used;
      } while(++b_idx < break_array.used);
   }
}

/*
 * process of condition of "while" cycle
 */

void pa_while_cond(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_false_jmp); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   
   jmp_code_idxs.push(run_code.code.used - 1);
}

/*
 * process of begin of cycle "while"
 */

void pa_while_exp(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &break_pos_arrays = _this.break_pos_arrays;
   break_continue_pos_arrays_s &continue_pos_arrays = _this.continue_pos_arrays;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   break_pos_arrays.push_blank();
   break_pos_arrays.last().used = 0;

   continue_pos_arrays.push_blank();
   continue_pos_arrays.last().used = 0;

   jmp_code_idxs.push(run_code.code.used);
}

/*
 * process of command break
 */

void pa_cmd_break(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &break_pos_arrays = _this.break_pos_arrays;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - test if break is inside any loop -
   err_test2(break_pos_arrays.used != 0,c_P_ERR_CONTINUE_BREAK_OUTSIDE_OF_LOOP,_this.line_cnt,(unsigned)"break");
      
   run_code.code.push(i_local_cross_jmp); _this.instr_per_line++;

   // - insert record of break command -
   break_continue_pos_array_s &break_pos_array = break_pos_arrays.last();
   break_pos_array.push_blank();
   break_pos_array.last().set(sa_idx_stack.used,run_code.code.used);

   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

/*
 * process of command continue
 */

void pa_cmd_continue(string_s &source_string,script_parser_s &_this)
{
   break_continue_pos_arrays_s &continue_pos_arrays = _this.continue_pos_arrays;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - test if continue command is inside any loop -
   err_test2(continue_pos_arrays.used != 0,c_P_ERR_CONTINUE_BREAK_OUTSIDE_OF_LOOP,_this.line_cnt,(unsigned)"continue");
      
   run_code.code.push(i_local_cross_jmp); _this.instr_per_line++;

   // - insert record of continue command -
   break_continue_pos_array_s &continue_pos_array = continue_pos_arrays.last();
   continue_pos_array.push_blank();
   continue_pos_array.last().set(sa_idx_stack.used,run_code.code.used);

   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

/*
 * process of command return
 */

void pa_cmd_return(string_s &source_string,script_parser_s &_this)
{
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   unsigned sas_idx = sa_idx_stack.used;

   // - computing of count of nested blocks without structures or functions -
   unsigned block_cnt = 0;
   do {
      sas_idx--;
      unsigned record_p_symbol_type = symbol_records[sa_idx_stack[sas_idx]].p_symbol_type;
      block_cnt++;
      
      if (record_p_symbol_type == c_symbol_type_structure || record_p_symbol_type == c_symbol_type_function) {
	 break;
      }
   } while(sas_idx > 0);

   // - test if command return is in code of any function -
   err_test1(sas_idx > 0,c_P_ERR_RETURN_OUTSIDE_OF_FUNCTION,_this.line_cnt);

   run_code.code.push(i_cmd_return); _this.instr_per_line++;
   run_code.code.push(block_cnt); _this.instr_per_line++;
}

/*
 * process of end of expression
 */

void pa_exp_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_exp_end); _this.instr_per_line++;
}

/*
 * next function describes processing of operators
 */

void pa_operator_binary_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_plus_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_plus_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_minus_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_minus_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_asterisk_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_asterisk_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_slash_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_slash_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_percent_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_percent_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_ls_br_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_ls_br_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_rs_br_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_rs_br_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_ampersand_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_ampersand_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_pipe_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_pipe_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_circumflex_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_circumflex_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_ampersand(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_ampersand); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_pipe(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_pipe); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_ampersand(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_ampersand); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_pipe(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_pipe); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_circumflex(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_circumflex); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_exclamation_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_exclamation_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_rs_br(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_rs_br); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_ls_br(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_ls_br); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_rs_br_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_rs_br_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_ls_br_equal(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_ls_br_equal); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_rs_br(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_rs_br); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_double_ls_br(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_double_ls_br); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_plus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_plus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_minus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_minus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_asterisk(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_asterisk); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_slash(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_slash); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_percent(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_percent); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_post_double_plus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_post_double_plus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_post_double_minus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_post_double_minus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_double_plus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_double_plus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_double_minus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_double_minus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_plus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_plus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_minus(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_minus); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_exclamation(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_exclamation); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_unary_pre_tilde(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(0); _this.instr_per_line++;
   run_code.code.push(c_operator_unary_pre_tilde); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_operator_binary_le_br_re_br(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(1); _this.instr_per_line++;
   run_code.code.push(c_operator_binary_le_br_re_br); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

/*
 * process of identifiers
 */

void pa_identifier(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire of variable name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - acquire of variable name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - test if symbol is defined yet -
   bool exist = false;
   unsigned sas_idx = sa_idx_stack.used;
   unsigned deep_counter = sas_idx;
   do {
      sas_idx--;
      symbol_record_s &record = symbol_records[sa_idx_stack[sas_idx]];

      if (record.p_symbol_type != c_symbol_type_structure) {
	 deep_counter--;
      }

      unsigned s_idx = record.symbols_array[c_symbol_type_struct_variable].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 run_code.code.push(i_this_var); _this.instr_per_line++;
	 run_code.code.push(s_idx); _this.instr_per_line++;
	 break;
      }

      s_idx = record.symbols_array[c_symbol_type_fun_param].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 run_code.code.push(i_param_var); _this.instr_per_line++;
	 run_code.code.push(s_idx); _this.instr_per_line++;
	 break;
      }

      s_idx = record.symbols_array[c_symbol_type_local_variable].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 // - global variable -
	 if (sas_idx == 0) {
	    run_code.code.push(i_global_var); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }

	 // - local variable -
	 else {
	    run_code.code.push(i_local_var); _this.instr_per_line++;
	    run_code.code.push(sa_idx_stack.used - 1 - deep_counter); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }

	 break;
      }

   } while(sas_idx > 0);

   // - if symbol not exist yet, new variable will be created -
   if (!exist) {
      symbols_s &symbols = symbol_records[sa_idx_stack.last()].symbols_array[c_symbol_type_local_variable];

      symbols.push_blank();
      symbols.last().set(n_idx,0,0);
      
      // - global variable -
      if (sa_idx_stack.used == 1) {
	 run_code.code.push(i_global_var); _this.instr_per_line++;
	 run_code.code.push(symbols.used - 1); _this.instr_per_line++;
      }
      
      // - local variable -
      else {
	 run_code.code.push(i_local_var); _this.instr_per_line++;
	 run_code.code.push(0); _this.instr_per_line++;
	 run_code.code.push(symbols.used - 1); _this.instr_per_line++;
      }
   }
}

/*
 * process of function call
 */

void pa_function_call(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire of function name description -
   lalr_stack_element_s &lse = lalr_stack[lalr_stack.used - 3];
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieve of function parameter count -
   unsigned fun_param_cnt = fm_param_cnt.pop();

   // - modification of function name, based on parameter count -
   char tmp_char = name_data[name_length];
   name_data[name_length] = '\0';

   char new_name_data[c_function_name_max_length];
   unsigned new_name_length = snprintf(new_name_data,c_function_name_max_length,c_function_name_format,name_data,fun_param_cnt);

   // - test of string size exceed -
   err_test3(new_name_length < c_function_name_max_length,c_DP_ERR_FUN_NAME_EXCEED_MAX_SIZE,_this.line_cnt,(unsigned)"Function call",(unsigned)name_data);
   
   name_data[name_length] = tmp_char;

   // - acquire of function name index -
   unsigned n_idx = _this.get_symbol_name_idx(new_name_length,new_name_data);

   // - searching for called function in table of symbols -
   bool exist = false;
   unsigned sas_idx = sa_idx_stack.used;
   do {
      --sas_idx;
      symbol_record_s &record = symbol_records[sa_idx_stack[sas_idx]];

      unsigned s_idx = record.symbols_array[c_symbol_type_function].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 if (record.p_symbol_type == c_symbol_type_structure) {
	    run_code.code.push(i_this_call); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }
	 else {
	    run_code.code.push(i_global_call); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }

	 break;
      }
   } while(sas_idx > 0);

   // - test if function was found -
   err_test3(exist == true,c_P_ERR_X_NOT_DEFINED,_this.line_cnt,(unsigned)"Called function",(unsigned)_this.symbol_names[n_idx].data);
}

/*
 * process of begin of counting of function parameters
 */

void pa_fcall_param_begin(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;

   // *****

   fm_param_cnt.push(0);
}

/*
 * process of function parameter
 */

void pa_fcall_parameter(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;

   // *****

   // - increase of function parameter counter -
   fm_param_cnt.last()++;
}

/*
 * process of acquiring element of structure
 */

void pa_struct_element(string_s &source_string,script_parser_s &_this)
{
   source_string_pos_array_s &tmp_sm_name_pos_array = _this.tmp_sm_name_pos_array;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire of element name description -
   source_string_pos_s &name_pos = tmp_sm_name_pos_array.pop();
   unsigned name_length = name_pos.ui_second - name_pos.ui_first;
   char *name_data = source_string.data + name_pos.ui_first;

   // - retrieval of element name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   run_code.code.push(i_s_element); _this.instr_per_line++;
   run_code.code.push(n_idx); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

/*
 * process of method call
 */

void pa_method_call(string_s &source_string,script_parser_s &_this)
{
   source_string_pos_array_s &tmp_sm_name_pos_array = _this.tmp_sm_name_pos_array;
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire of description of method name -
   source_string_pos_s &name_pos = tmp_sm_name_pos_array.pop();
   unsigned name_length = name_pos.ui_second - name_pos.ui_first;
   char *name_data = source_string.data + name_pos.ui_first;

   // - count of method parameters -
   unsigned fun_param_cnt = fm_param_cnt.pop();

   // - modification of method name, based on parameter count -
   char tmp_char = name_data[name_length];
   name_data[name_length] = '\0';

   char new_name_data[c_function_name_max_length];
   unsigned new_name_length = snprintf(new_name_data,c_function_name_max_length,c_function_name_format,name_data,fun_param_cnt);

   // - test of string size exceed -
   err_test3(new_name_length < c_function_name_max_length,c_DP_ERR_FUN_NAME_EXCEED_MAX_SIZE,_this.line_cnt,(unsigned)"Method call",(unsigned)name_data);

   name_data[name_length] = tmp_char;

   // - retrieval of method name index -
   unsigned n_idx = _this.get_symbol_name_idx(new_name_length,new_name_data);

   run_code.code.push(i_s_method_call); _this.instr_per_line++;
   run_code.code.push(fun_param_cnt); _this.instr_per_line++;
   run_code.code.push(n_idx); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

/*
 * process of name of structure member
 */

void pa_struct_member(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   source_string_pos_array_s &tmp_sm_name_pos_array = _this.tmp_sm_name_pos_array;

   // *****
   
   // - retrieve of variable name description from parse stack -
   lalr_stack_element_s &lse = lalr_stack.last();
   
   // - store of name description for later use -
   tmp_sm_name_pos_array.push_blank();
   tmp_sm_name_pos_array.last().set(lse.ui_second,lse.ui_third);
}

/*
 * process of begin of creating record of method parameters
 */

void pa_mcall_param_begin(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;

   // *****

   fm_param_cnt.push(0);
}

/*
 * process of method parameters
 */

void pa_mcall_parameter(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &fm_param_cnt = _this.fm_param_cnt;

   // *****

   fm_param_cnt.last()++;
}

/*
 * process of new object creation
 */

void pa_new_object(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - retrieve of description of object name -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieve of object name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - retrieve of structure symbol -
   symbols_s &struct_symbols = symbol_records[0].symbols_array[c_symbol_type_structure];

   unsigned s_idx = struct_symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx != c_idx_not_exist,c_P_ERR_X_NOT_DEFINED,_this.line_cnt,(unsigned)"Object type",(unsigned)_this.symbol_names[n_idx].data);

   run_code.code.push(i_new_object); _this.instr_per_line++;
   run_code.code.push(struct_symbols[s_idx].ui_third); _this.instr_per_line++;
}

/*
 * process of keyword this which points to actual object
 */

void pa_this(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****
   
   run_code.code.push(i_this); _this.instr_per_line++;
}

/*
 * process of end of thread definition
 */

void pa_thread_def_end(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****
 
   // - remove of record from record stack -
   sa_idx_stack.pop();

   run_code.code.push(i_cmd_block_end); _this.instr_per_line++;
   run_code.code.push(i_flow_end); _this.instr_per_line++;

   // - setting of jump target for original thread -
   run_code.code[jmp_code_idxs.pop()] = run_code.code.used;
}

/*
 * process of begin of thread definition
 */

void pa_thread_def_begin(string_s &source_string,script_parser_s &_this)
{
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - creation of new record for command block -
   symbol_records.push_blank();

   symbol_record_s &new_record = symbol_records.last();
   new_record.p_record_idx = c_idx_not_exist;
   new_record.p_symbol_type = c_idx_not_exist;
   new_record.p_symbol_idx = c_idx_not_exist;

   symbols_array_s &new_symbols_array = new_record.symbols_array;
   new_symbols_array.copy_resize(c_symbol_type_cnt);
   new_symbols_array.used = c_symbol_type_cnt;

   // - insertion of record to record stack -
   sa_idx_stack.push(symbol_records.used - 1);

   // - insertion of instruction which creates new thread -
   run_code.code.push(i_thread); _this.instr_per_line++;
  
   // - save source of jump of original thread -
   jmp_code_idxs.push(run_code.code.used);

   // - index of instruction at which will original thread continue -
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;

   // - count of parameter elements in code -
   run_code.code.push(c_idx_not_exist); _this.instr_per_line++;
}

void pa_thread_def_parameters(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &jmp_code_idxs = _this.jmp_code_idxs;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - setting of count of thread parameters -
   unsigned jmp_code_idx_last_po = jmp_code_idxs.last() + 1;
   run_code.code[jmp_code_idx_last_po] = (run_code.code.used - 1) - jmp_code_idx_last_po;
}

/*
 * process of handover of thread parameter
 */

void pa_thread_parameter(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   symbol_records_s &symbol_records = _this.symbol_records;
   ui_array_s &sa_idx_stack = _this.sa_idx_stack;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   // - acquire of parameter name description -
   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned name_length = lse.ui_third - lse.ui_second;
   char *name_data = source_string.data + lse.ui_second;

   // - retrieval of parameter name index -
   unsigned n_idx = _this.get_symbol_name_idx(name_length,name_data);

   // - test if symbol is defined yet -
   bool exist = false;
   unsigned sas_idx = sa_idx_stack.used - 1;
   unsigned deep_counter = sas_idx;
   do {
      sas_idx--;
      symbol_record_s &record = symbol_records[sa_idx_stack[sas_idx]];

      if (record.p_symbol_type != c_symbol_type_structure) {
	 deep_counter--;
      }

      unsigned s_idx = record.symbols_array[c_symbol_type_struct_variable].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 run_code.code.push(i_this_var); _this.instr_per_line++;
	 run_code.code.push(s_idx); _this.instr_per_line++;
	 break;
      }

      s_idx = record.symbols_array[c_symbol_type_fun_param].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 run_code.code.push(i_param_var); _this.instr_per_line++;
	 run_code.code.push(s_idx); _this.instr_per_line++;
	 break;
      }

      s_idx = record.symbols_array[c_symbol_type_local_variable].get_idx_by_ui_first(n_idx);
      if (s_idx != c_idx_not_exist) {
	 exist = true;

	 // - global variable -
	 if (sas_idx == 0) {
	    run_code.code.push(i_global_var); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }

	 // - local variable -
	 else {
	    run_code.code.push(i_local_var); _this.instr_per_line++;
	    run_code.code.push(sa_idx_stack.used - 2 - deep_counter); _this.instr_per_line++;
	    run_code.code.push(s_idx); _this.instr_per_line++;
	 }

	 break;
      }

   } while(sas_idx > 0);

   // - test if variable exist in original thread -
   err_test3(exist,c_P_ERR_X_NOT_DEFINED,_this.line_cnt,(unsigned)"Object ",(unsigned)_this.symbol_names[n_idx].data);

   // - creation of new local variable in new thread -
   symbols_s &symbols = symbol_records[sa_idx_stack.last()].symbols_array[c_symbol_type_local_variable];

   // - test if new local variable not exist yet -
   unsigned s_idx = symbols.get_idx_by_ui_first(n_idx);
   err_test3(s_idx == c_idx_not_exist,c_P_ERR_IDENTIFIER_ALREADY_EXIST,_this.line_cnt,(unsigned)"Thread parameter",(unsigned)_this.symbol_names[n_idx].data);

   symbols.push_blank();
   symbols.last().set(n_idx,0,0);
}

/*
 * process of begin of array definition
 */

void pa_new_char_array(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_new_char_array); _this.instr_per_line++;
}

/*
 * process of begin of definition array of integers
 */

void pa_new_int_array(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****
   
   run_code.code.push(i_new_int_array); _this.instr_per_line++;
}

/*
 * process of begin of definition array float point numbers
 */

void pa_new_double_array(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_new_double_array); _this.instr_per_line++;
}

/*
 * process of begin of definition of array of objects
 */

void pa_new_array(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_new_array); _this.instr_per_line++;
}

/*
 * process of insertion element to array
 */

void pa_array_element(string_s &source_string,script_parser_s &_this)
{
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   run_code.code.push(i_array_element); _this.instr_per_line++;
}

/*
 * process of constants
 */

void pa_single_char_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   char new_char = source_string.data[lalr_stack.last().ui_second + 1];

   unsigned c_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)new_char,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_octal_char_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned char_num_end = (lse.ui_third - lse.ui_second) - 1;
   char *char_num_data = source_string.data + lse.ui_second;

   // - retrieve of char number -
   char_num_data[char_num_end] = '\0';
   char new_char = strtol(char_num_data + 2,NULL,8);
   char_num_data[char_num_end] = '\'';

   unsigned c_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)new_char,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_hex_char_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned char_num_end = (lse.ui_third - lse.ui_second) - 1;
   char *char_num_data = source_string.data + lse.ui_second;

   // - retrieve of char number -
   char_num_data[char_num_end] = '\0';
   char new_char = strtol(char_num_data + 3,NULL,16);
   char_num_data[char_num_end] = '\'';

   unsigned c_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)new_char,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_backslash_char_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   char new_char = 0;

   switch (source_string.data[lalr_stack.last().ui_second + 2]) {
   case 'a': new_char = '\a'; break;
   case 'b': new_char = '\b'; break;
   case 'f': new_char = '\f'; break;
   case 'n': new_char = '\n'; break;
   case 'r': new_char = '\r'; break;
   case 't': new_char = '\t'; break;
   case 'v': new_char = '\v'; break;
   case '\\': new_char = '\\'; break;
   case '?': new_char = '\?'; break;
   case '\'': new_char = '\''; break;
   case '"': new_char = '"'; break;
   default:
      err_test3(0,c_P_ERR_WRONG_ESCAPE_CODE,_this.line_cnt,(unsigned)(source_string.data[lalr_stack.last().ui_second + 2]),(unsigned)"char");
   }

   unsigned c_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)new_char,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_oct_int_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned num_end = lse.ui_third - lse.ui_second;
   char *num_data = source_string.data + lse.ui_second;

   // - retrieve of number -
   char tmp_char = num_data[num_end];
   num_data[num_end] = '\0';
   int num = strtol(num_data,NULL,8);
   num_data[num_end] = tmp_char;

   unsigned c_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)num,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_dec_int_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];
   
   // *****

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned num_end = lse.ui_third - lse.ui_second;
   char *num_data = source_string.data + lse.ui_second;

   // - retrieve of number -
   char tmp_char = num_data[num_end];
   num_data[num_end] = '\0';
   int num = strtol(num_data,NULL,10);
   num_data[num_end] = tmp_char;

   unsigned c_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)num,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_hex_int_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned num_end = lse.ui_third - lse.ui_second;
   char *num_data = source_string.data + lse.ui_second;

   // - retrieve of number -
   char tmp_char = num_data[num_end];
   num_data[num_end] = '\0';
   int num = strtol(num_data,NULL,16);
   num_data[num_end] = tmp_char;

   unsigned c_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)num,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_oct_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"octal long int");
}

void pa_dec_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"decadic long int");
}

void pa_hex_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"hexadecimal long int");
}

void pa_oct_unsigned_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"octal unsigned int");
}

void pa_dec_unsigned_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"decadic unsigned int");
}

void pa_hex_unsigned_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"hexadecimal long int");
}

void pa_oct_unsigned_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"octal unsigned long int");
}

void pa_dec_unsigned_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"decadic unsigned long int");
}

void pa_hex_unsigned_long_int_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"hexadecimal unsigned long int");
}

void pa_double_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];
   
   // *****

   lalr_stack_element_s &lse = lalr_stack.last();
   unsigned double_num_end = lse.ui_third - lse.ui_second;
   char *double_num_data = source_string.data + lse.ui_second;

   // - retrieve of number from string -
   char tmp_char = double_num_data[double_num_end];
   double_num_data[double_num_end] = '\0';
   double double_num = strtod(double_num_data,NULL);
   double_num_data[double_num_end] = tmp_char;

   unsigned c_idx = value_location_pool.insert(c_value_type_DOUBLE,*(unsigned long long *)&double_num,c_value_modifier_NOTHING);

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

void pa_float_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"float");
}

void pa_long_double_const(string_s &source_string,script_parser_s &_this)
{
   err_test2(0,c_DP_UNIMPLEMENTED_CONST_NOTATION,_this.line_cnt,(unsigned)"long double");
}

void pa_string_const(string_s &source_string,script_parser_s &_this)
{
   lalr_stack_s &lalr_stack = _this.lalr_stack;
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   ui_array_s &pc_idx_stack = _this.pc_idx_stack;
   run_code_s &run_code = _this.run_codes[pc_idx_stack.last()];

   // *****

   lalr_stack_element_s &lse = lalr_stack.last();

   char *ptr = source_string.data + lse.ui_second + 1;
   char *ptr_end = source_string.data + lse.ui_third - 1;

   bc_array_s char_buffer;
   char_buffer.init();
  
   if (ptr < ptr_end) {
      do {
	 if (*ptr == '\\') {
	    ptr++;

	    // - process of char represented by octal number -
	    if (*ptr >= '0' && *ptr <= '7') {
	       char new_char = *ptr++ - '0';

	       if (*ptr >= '0' && *ptr <= '7') {
		  new_char = (new_char << 3) | (*ptr++ - '0');

		  if (*ptr >= '0' && *ptr <= '7') {
		     new_char = (new_char << 3) | (*ptr++ - '0');
		  }
	       }

	       char_buffer.push(new_char);
	    }
	    // - process of char representation by hexadecimal number -
	    else if (*ptr == 'x') {
	       ptr++;
	       char new_char = 0;

	       // - first char in hexadecimal representation -
	       if (*ptr >= '0' && *ptr <= '9') {
		  new_char = *ptr++ - '0';
	       }
	       else if (*ptr >= 'a' && *ptr <= 'f') {
		  new_char = 10 + (*ptr++ - 'a');
	       }
	       else if (*ptr >= 'A' && *ptr <= 'F') {
		  new_char = 10 + (*ptr++ - 'A');
	       }

	       // - second char in hexadecimal representation -
	       if (*ptr >= '0' && *ptr <= '9') {
		  new_char = (new_char << 4) | (*ptr++ - '0');
	       }
	       else if (*ptr >= 'a' && *ptr <= 'f') {
		  new_char = (new_char << 4) | (10 + (*ptr++ - 'a'));
	       }
	       else if (*ptr >= 'A' && *ptr <= 'F') {
		  new_char = (new_char << 4) | (10 + (*ptr++ - 'A'));
	       }

	       char_buffer.push(new_char);
	    }
	    else {
	       switch (*ptr++) {
	       case 'a': char_buffer.push('\a'); break;
	       case 'b': char_buffer.push('\b'); break;
	       case 'f': char_buffer.push('\f'); break;
	       case 'n': char_buffer.push('\n'); break;
	       case 'r': char_buffer.push('\r'); break;
	       case 't': char_buffer.push('\t'); break;
	       case 'v': char_buffer.push('\v'); break;
	       case '\\': char_buffer.push('\\'); break;
	       case '?': char_buffer.push('?'); break;
	       case '\'': char_buffer.push('\''); break;
	       case '"': char_buffer.push('"'); break;
	       default:
		  err_test3(0,c_P_ERR_WRONG_ESCAPE_CODE,_this.line_cnt,(unsigned)*(ptr - 1),(unsigned)"string");
	       }
	    }
	 }
	 else {
	    char_buffer.push(*ptr++);
	 }
      } while(ptr < ptr_end);
   }

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->set(char_buffer.used,char_buffer.data);

   unsigned c_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_NOTHING);

   char_buffer.clear();

   run_code.code.push(i_const); _this.instr_per_line++;
   run_code.code.push(c_idx); _this.instr_per_line++;
}

