/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.DefaultConfiguration;

public final class Configurator {
    private Configurator() {
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation) {
        try {
            URI uri = configLocation == null ? null : new URI(configLocation);
            return Configurator.initialize(name, loader, uri);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation) {
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)loader, (boolean)false);
            Configuration config = ConfigurationFactory.getInstance().getConfiguration(name, configLocation);
            ctx.setConfiguration(config);
            return ctx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationFactory.ConfigurationSource source) {
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)loader, (boolean)false);
            Configuration config = ConfigurationFactory.getInstance().getConfiguration(source);
            ctx.setConfiguration(config);
            return ctx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void shutdown(LoggerContext ctx) {
        if (ctx != null) {
            ctx.setConfiguration(new DefaultConfiguration());
        }
    }
}

