/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Failover", type="Core", elementType="appender", printObject=true)
public final class FailoverAppender
extends AbstractAppender {
    private static final int DEFAULT_INTERVAL = 60000;
    private final String primaryRef;
    private final String[] failovers;
    private final Configuration config;
    private AppenderControl primary;
    private final List<AppenderControl> failoverAppenders = new ArrayList<AppenderControl>();
    private final long interval;
    private long nextCheck = 0L;
    private volatile boolean failure = false;

    private FailoverAppender(String name, Filter filter, String primary, String[] failovers, int interval, Configuration config, boolean handleExceptions) {
        super(name, filter, null, handleExceptions);
        this.primaryRef = primary;
        this.failovers = failovers;
        this.config = config;
        this.interval = interval;
    }

    public void start() {
        Map<String, Appender<?>> map = this.config.getAppenders();
        int errors = 0;
        if (map.containsKey(this.primaryRef)) {
            this.primary = new AppenderControl(map.get(this.primaryRef), null, null);
        } else {
            LOGGER.error("Unable to locate primary Appender " + this.primaryRef);
            ++errors;
        }
        for (String name : this.failovers) {
            if (map.containsKey(name)) {
                this.failoverAppenders.add(new AppenderControl(map.get(name), null, null));
                continue;
            }
            LOGGER.error("Failover appender " + name + " is not configured");
        }
        if (this.failoverAppenders.size() == 0) {
            LOGGER.error("No failover appenders are available");
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    public void append(LogEvent event) {
        Object re = null;
        if (!this.isStarted()) {
            this.error("FailoverAppender " + this.getName() + " did not start successfully");
            return;
        }
        if (!this.failure) {
            this.callAppender(event);
        } else {
            long current = System.currentTimeMillis();
            if (current >= this.nextCheck) {
                this.callAppender(event);
            } else {
                this.failover(event, null);
            }
        }
    }

    private void callAppender(LogEvent event) {
        try {
            this.primary.callAppender(event);
        }
        catch (Exception ex) {
            this.nextCheck = System.currentTimeMillis() + this.interval;
            this.failure = true;
            this.failover(event, ex);
        }
    }

    private void failover(LogEvent event, Exception ex) {
        LoggingException re = ex != null ? new LoggingException(ex) : null;
        boolean written = false;
        Exception failoverException = null;
        for (AppenderControl control : this.failoverAppenders) {
            try {
                control.callAppender(event);
                written = true;
                break;
            }
            catch (Exception fex) {
                if (failoverException != null) continue;
                failoverException = fex;
            }
        }
        if (!written && !this.isExceptionSuppressed()) {
            if (re != null) {
                throw re;
            }
            throw new LoggingException("Unable to write to failover appenders", failoverException);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" primary=").append(this.primary).append(", failover={");
        boolean first = true;
        for (String str : this.failovers) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(str);
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    @PluginFactory
    public static FailoverAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="primary") String primary, @PluginElement(value="failovers") String[] failovers, @PluginAttr(value="retryInterval") String interval, @PluginConfiguration Configuration config, @PluginElement(value="filters") Filter filter, @PluginAttr(value="suppressExceptions") String suppress) {
        int retryInterval;
        if (name == null) {
            LOGGER.error("A name for the Appender must be specified");
            return null;
        }
        if (primary == null) {
            LOGGER.error("A primary Appender must be specified");
            return null;
        }
        if (failovers == null || failovers.length == 0) {
            LOGGER.error("At least one failover Appender must be specified");
            return null;
        }
        if (interval == null) {
            retryInterval = 60000;
        } else {
            try {
                int value = Integer.parseInt(interval);
                if (value >= 0) {
                    retryInterval = value * 1000;
                } else {
                    LOGGER.warn("Interval " + interval + " is less than zero. Using default");
                    retryInterval = 60000;
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Interval " + interval + " is non-numeric. Using default");
                retryInterval = 60000;
            }
        }
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        return new FailoverAppender(name, filter, primary, failovers, retryInterval, config, handleExceptions);
    }
}

