/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="Asynch", type="Core", elementType="appender", printObject=true)
public final class AsynchAppender<T extends Serializable>
extends AbstractAppender<T> {
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final String SHUTDOWN = "Shutdown";
    private final BlockingQueue<Serializable> queue;
    private final boolean blocking;
    private final Configuration config;
    private final AppenderRef[] appenderRefs;
    private final String errorRef;
    private AppenderControl errorAppender;
    private AsynchThread thread;

    private AsynchAppender(String name, Filter filter, AppenderRef[] appenderRefs, String errorRef, int queueSize, boolean blocking, boolean handleExceptions, Configuration config) {
        super(name, filter, null, handleExceptions);
        this.queue = new ArrayBlockingQueue<Serializable>(queueSize);
        this.blocking = blocking;
        this.config = config;
        this.appenderRefs = appenderRefs;
        this.errorRef = errorRef;
    }

    @Override
    public void start() {
        Map<String, Appender<?>> map = this.config.getAppenders();
        ArrayList<AppenderControl> appenders = new ArrayList<AppenderControl>();
        for (AppenderRef appenderRef : this.appenderRefs) {
            if (map.containsKey(appenderRef.getRef())) {
                appenders.add(new AppenderControl(map.get(appenderRef.getRef()), null, null));
                continue;
            }
            LOGGER.error("No appender named {} was configured", new Object[]{appenderRef});
        }
        if (this.errorRef != null) {
            if (map.containsKey(this.errorRef)) {
                this.errorAppender = new AppenderControl(map.get(this.errorRef), null, null);
            } else {
                LOGGER.error("Unable to set up error Appender. No appender named {} was configured", new Object[]{this.errorRef});
            }
        }
        if (appenders.size() > 0) {
            this.thread = new AsynchThread(appenders, this.queue);
        } else if (this.errorRef == null) {
            throw new ConfigurationException("No appenders are available for AsynchAppender " + this.getName());
        }
        this.thread.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.thread.shutdown();
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Interrupted while stopping AsynchAppender {}", new Object[]{this.getName()});
        }
    }

    @Override
    public void append(LogEvent event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("AsynchAppender " + this.getName() + " is not active");
        }
        if (event instanceof Log4jLogEvent) {
            if (this.blocking && this.queue.remainingCapacity() > 0) {
                try {
                    this.queue.add(Log4jLogEvent.serialize((Log4jLogEvent)event));
                    return;
                }
                catch (IllegalStateException ex) {
                    this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
                }
            }
            if (this.errorAppender != null) {
                if (!this.blocking) {
                    this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
                }
                this.errorAppender.callAppender(event);
            }
        }
    }

    @PluginFactory
    public static <S extends Serializable> AsynchAppender<S> createAppender(@PluginElement(value="appender-ref") AppenderRef[] appenderRefs, @PluginAttr(value="error-ref") String errorRef, @PluginAttr(value="blocking") String blocking, @PluginAttr(value="bufferSize") String size, @PluginAttr(value="name") String name, @PluginElement(value="filter") Filter filter, @PluginConfiguration Configuration config, @PluginAttr(value="suppressExceptions") String suppress) {
        if (name == null) {
            LOGGER.error("No name provided for AsynchAppender");
            return null;
        }
        if (appenderRefs == null) {
            LOGGER.error("No appender references provided to AsynchAppender {}", new Object[]{name});
        }
        boolean isBlocking = blocking == null ? true : Boolean.valueOf(blocking);
        int queueSize = size == null ? 128 : Integer.parseInt(size);
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        return new AsynchAppender(name, filter, appenderRefs, errorRef, queueSize, isBlocking, handleExceptions, config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsynchThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final List<AppenderControl> appenders;
        private final BlockingQueue<Serializable> queue;

        public AsynchThread(List<AppenderControl> appenders, BlockingQueue<Serializable> queue) {
            this.appenders = appenders;
            this.queue = queue;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                Serializable s;
                try {
                    s = this.queue.take();
                    if (s != null && s instanceof String && AsynchAppender.SHUTDOWN.equals(s.toString())) {
                        this.shutdown = true;
                    }
                }
                catch (InterruptedException ex) {}
                continue;
                Log4jLogEvent event = Log4jLogEvent.deserialize(s);
                boolean success = false;
                for (AppenderControl control : this.appenders) {
                    try {
                        control.callAppender(event);
                        success = true;
                    }
                    catch (Exception ex) {}
                }
                if (success || AsynchAppender.this.errorAppender == null) continue;
                try {
                    AsynchAppender.this.errorAppender.callAppender(event);
                }
                catch (Exception ex) {}
            }
            while (!this.queue.isEmpty()) {
                try {
                    Log4jLogEvent event = Log4jLogEvent.deserialize(this.queue.take());
                    for (AppenderControl control : this.appenders) {
                        control.callAppender(event);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public void shutdown() {
            this.shutdown = true;
            if (this.queue.isEmpty()) {
                this.queue.offer((Serializable)((Object)AsynchAppender.SHUTDOWN));
            }
        }
    }
}

