/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import simulator.algorithms.AbstractAlgorithm;
import simulator.gui.ControlPanel;
import simulator.gui.TextLineNumber;

public class VisualizationPseudocodePanel
extends JPanel {
    protected ControlPanel controlPanel = new ControlPanel();
    protected TextLineNumber tln;
    protected AbstractAlgorithm algorithm;
    protected JTextPane textPane;

    public VisualizationPseudocodePanel(AbstractAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane(algorithm);
        this.textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        this.tln = new TextLineNumber((JTextComponent)this.textPane, 2);
        scrollPane.setRowHeaderView(this.tln);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.controlPanel, "South");
    }

    public AbstractAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public TextLineNumber getTln() {
        return this.tln;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.tln.setScrollEnabled(scrollEnabled);
    }

    public void clearAllHighlights() {
        this.tln.clearAllHighlight();
    }

    public void highlightLine(int part, int line, Color color) {
        this.tln.highlightLine(this.algorithm.getRealLineNumber(part, line), color);
    }

    public void setActualLineHighlightColor(Color actualLineHighlightColor) {
        this.tln.setActualLineHighlightColor(actualLineHighlightColor);
    }
}

