/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;

public class ControlPanel
extends JPanel {
    public static final int MAX_TIME = 6;
    public static final int MIN_TIME = 0;
    public static final int STANDARD_TIME = 4;
    public static final int MAX_DELAY = 10000;
    public static final int MIN_DELAY = 0;
    protected JButton backButton = new JButton();
    protected JButton playButton = new JButton();
    protected JButton resetButton = new JButton();
    protected JButton forwardButton = new JButton();
    protected JSlider speedSlider = new JSlider(0, 0, 6, 4);

    public ControlPanel() {
        super(new BorderLayout());
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.setInverted(true);
        Enumeration e = this.speedSlider.getLabelTable().keys();
        int speed = 1;
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            JLabel label = (JLabel)this.speedSlider.getLabelTable().get(i);
            if (i == 0) {
                label.setText("Max");
                continue;
            }
            label.setText(speed + "x");
            speed *= 2;
        }
        this.speedSlider.setPaintLabels(true);
        JToolBar toolBar = new JToolBar();
        toolBar.setName("Control of the algorithm simulation");
        toolBar.setLayout(new GridBagLayout());
        this.speedSlider.setFocusable(false);
        this.backButton.setFocusable(false);
        this.backButton.setHideActionText(true);
        this.backButton.setBorderPainted(false);
        this.playButton.setFocusable(false);
        this.playButton.setHideActionText(true);
        this.playButton.setBorderPainted(false);
        this.resetButton.setFocusable(false);
        this.resetButton.setHideActionText(true);
        this.resetButton.setBorderPainted(false);
        this.forwardButton.setFocusable(false);
        this.forwardButton.setHideActionText(true);
        this.forwardButton.setBorderPainted(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        toolBar.add((Component)this.backButton, c);
        c.gridx = 1;
        toolBar.add((Component)this.resetButton, c);
        c.gridx = 2;
        toolBar.add((Component)this.playButton, c);
        c.gridx = 3;
        toolBar.add((Component)this.forwardButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        toolBar.add((Component)this.speedSlider, c);
        toolBar.setRollover(false);
        this.add((Component)toolBar, "Before");
    }

    public void setButtonsEnabled(boolean enabled) {
        this.backButton.setEnabled(enabled);
        this.playButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        this.forwardButton.setEnabled(enabled);
    }

    public void setAllEnabled(boolean enabled) {
        this.speedSlider.setEnabled(enabled);
        this.setButtonsEnabled(enabled);
    }

    public AbstractButton getBackButton() {
        return this.backButton;
    }

    public AbstractButton getPlayButton() {
        return this.playButton;
    }

    public AbstractButton getResetButton() {
        return this.resetButton;
    }

    public AbstractButton getForwardButton() {
        return this.forwardButton;
    }

    public JSlider getSpeedSlider() {
        return this.speedSlider;
    }

    public static int getDelayBySliderValue(int sliderValue, int max, int min) {
        if (sliderValue == 0) {
            return 0;
        }
        sliderValue = (int)Math.pow(2.0, max - sliderValue);
        int delay = 10000 / sliderValue;
        return delay;
    }

    public static int getStandardTime() {
        return ControlPanel.getDelayBySliderValue(4, 6, 0);
    }
}

