/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LayerUI;
import simulator.algorithms.AbstractAlgorithm;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.gui.ControlPanel;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractSimulatorPanel
extends JPanel {
    protected VisualizationPseudocodePanel codePanel;
    protected AlgorithmGraph graph;
    protected AbstractAlgorithm algorithm;
    protected AlgorithmGraphComponent graphComponent;
    protected JPopupMenu popup;
    protected AbstractController controller;
    protected VariablesPanel variablesPanel;
    protected JSplitPane codeAndVariablesPanel;
    protected JPanel graphPanel;
    protected JLabel label;
    protected PropertyChangeListener playPropertyChangeListener;

    public AbstractSimulatorPanel(final AlgorithmGraph graph, AbstractAlgorithm algorithm) {
        if (graph == null || algorithm == null) {
            throw new NullPointerException();
        }
        this.algorithm = algorithm;
        this.graph = graph;
        this.setLayout(new GridLayout(0, 1));
        this.graphComponent = AbstractSimulatorPanel.getmxGraphComponent(graph);
        graph.getModel().addListener("change", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                new mxParallelEdgeLayout(graph).execute(graph.getDefaultParent());
                graph.refresh();
            }
        });
        mxRubberband rubberBand = new mxRubberband(this.graphComponent);
        this.graphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    if (e.getWheelRotation() < 0) {
                        AbstractSimulatorPanel.this.graphComponent.zoomIn();
                    } else {
                        AbstractSimulatorPanel.this.graphComponent.zoomOut();
                    }
                }
            }
        });
        this.codePanel = new VisualizationPseudocodePanel(algorithm);
        this.variablesPanel = new VariablesPanel();
        this.codePanel.getControlPanel().getForwardButton().setAction(new AbstractAction("Forward", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_fwd_48.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractSimulatorPanel.this.controller.performNext();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "forward");
        this.getActionMap().put("forward", this.codePanel.getControlPanel().getForwardButton().getAction());
        this.codePanel.getControlPanel().getBackButton().setAction(new AbstractAction("Backward", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_rew_48.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractSimulatorPanel.this.controller.performBefore();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "backward");
        this.getActionMap().put("backward", this.codePanel.getControlPanel().getBackButton().getAction());
        this.codePanel.getControlPanel().getPlayButton().setAction(new AbstractAction("Play", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_play_48.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractSimulatorPanel.this.controller.runSimulation();
            }
        });
        this.playPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    AbstractSimulatorPanel.this.codePanel.getControlPanel().getPlayButton().setIcon(new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_pause_48.png")));
                } else {
                    AbstractSimulatorPanel.this.codePanel.getControlPanel().getPlayButton().setIcon(new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_play_48.png")));
                }
            }
        };
        this.codePanel.getControlPanel().getResetButton().setAction(new AbstractAction("Reset", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_stop_48.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean running = AbstractSimulatorPanel.this.controller.isTimerRunning();
                AbstractSimulatorPanel.this.controller.setTimerStart(false);
                int n = JOptionPane.showConfirmDialog(AbstractSimulatorPanel.this.codePanel, "Do you want to start simulation from the beginning?", "Restart Algorithm", 0);
                if (n == 0) {
                    AbstractSimulatorPanel.this.controller.resetController();
                } else {
                    AbstractSimulatorPanel.this.controller.setTimerStart(running);
                }
            }
        });
        this.codePanel.getControlPanel().getSpeedSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!slider.getValueIsAdjusting()) {
                    int delay = ControlPanel.getDelayBySliderValue(slider.getValue(), slider.getMaximum(), slider.getMinimum());
                    AbstractSimulatorPanel.this.controller.setDelay(delay);
                }
            }
        });
        this.popup = new JPopupMenu();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new AbstractAction("Scroll"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimulatorPanel.this.controller.setScrollEnabled(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        menuItem.setState(true);
        this.popup.add(menuItem);
        menuItem = new JCheckBoxMenuItem(new AbstractAction("Scroll"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimulatorPanel.this.codePanel.setScrollEnabled(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        menuItem.setState(true);
        this.popup.add(menuItem);
        this.popup.addSeparator();
        menuItem = new JCheckBoxMenuItem(new AbstractAction("Interactive mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimulatorPanel.this.controller.setInteractiveMode(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        menuItem.setState(false);
        this.popup.add(menuItem);
        this.popup.addSeparator();
        JMenuItem menuItem1 = new JMenuItem(new AbstractAction("Return panels"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimulatorPanel.this.variablesPanel.dockTables();
            }
        });
        this.popup.add(menuItem1);
        LayerUI<JComponent> ui = new LayerUI<JComponent>(){

            @Override
            public void eventDispatched(AWTEvent e, JLayer<? extends JComponent> l) {
                if (e instanceof MouseEvent) {
                    switch (e.getID()) {
                        case 501: {
                            this.showPopup((MouseEvent)e);
                            break;
                        }
                        case 502: {
                            this.showPopup((MouseEvent)e);
                        }
                    }
                }
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AbstractSimulatorPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        JLayer<JComponent> layer = new JLayer<JComponent>(this.codePanel, ui);
        layer.setLayerEventMask(16L);
        this.codeAndVariablesPanel = new JSplitPane(0, this.variablesPanel, layer);
        this.codeAndVariablesPanel.setContinuousLayout(true);
        this.codeAndVariablesPanel.setResizeWeight(0.2);
        this.codeAndVariablesPanel.setDividerSize(6);
        this.graphPanel = new JPanel(new BorderLayout());
        this.label = this.getAlgorithmLabel();
        this.graphPanel.add((Component)this.label, "North");
        JSplitPane pane = new JSplitPane(1, this.graphPanel, this.codeAndVariablesPanel);
        pane.setContinuousLayout(true);
        pane.setResizeWeight(0.8);
        pane.setDividerSize(6);
        this.add(pane);
    }

    protected final JLabel getAlgorithmLabel() {
        JLabel newLabel = new JLabel("<html></html>", 0){

            @Override
            public Dimension getPreferredSize() {
                Dimension pSize = super.getPreferredSize();
                Dimension mSize = this.getMinimumSize();
                int wid = pSize.width < mSize.width ? mSize.width : pSize.width;
                int ht = pSize.height < mSize.height ? mSize.height : pSize.height;
                return new Dimension(wid, ht);
            }
        };
        Font labelFont = new Font("Serif", 0, 18);
        newLabel.setFont(labelFont);
        newLabel.setPreferredSize(new Dimension(Short.MAX_VALUE, newLabel.getFontMetrics(labelFont).getHeight() * 2 + 10));
        return newLabel;
    }

    public static AlgorithmGraphComponent getmxGraphComponent(AlgorithmGraph graph) {
        AlgorithmGraphComponent gc = new AlgorithmGraphComponent(graph);
        gc.getViewport().setBackground(Color.WHITE);
        gc.setConnectable(false);
        gc.setToolTips(true);
        gc.setImportEnabled(false);
        gc.setEnterStopsCellEditing(true);
        return gc;
    }

    public VisualizationPseudocodePanel getCodePanel() {
        return this.codePanel;
    }

    public AlgorithmGraph getGraph() {
        return this.graph;
    }

    public AbstractAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public VariablesPanel getVariablesPanel() {
        return this.variablesPanel;
    }

    public JSplitPane getCodeAndVariablesPanel() {
        return this.codeAndVariablesPanel;
    }

    public JPanel getGraphPanel() {
        return this.graphPanel;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public PropertyChangeListener getPlayPropertyChangeListener() {
        return this.playPropertyChangeListener;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
        controller.addTimerPropertyChangeListener(this.playPropertyChangeListener);
        controller.setDelay(ControlPanel.getStandardTime());
    }
}

