/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.dfs;

import simulator.graphs.AbstractGraphCell;
import simulator.graphs.dfs.DfsNodeData;
import simulator.graphs.dfs.DfsOperations;

public class DfsGraphVertex
extends AbstractGraphCell
implements DfsOperations {
    protected DfsNodeData state = null;

    public DfsGraphVertex() {
        this((String)null);
    }

    public DfsGraphVertex(String name) {
        this(name, false);
    }

    public DfsGraphVertex(String name, Boolean selected) {
        this(name, new DfsNodeData(), selected);
    }

    public DfsGraphVertex(String name, DfsNodeData state, Boolean selected) {
        super(name, selected);
        this.state = state;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled()) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(this.getName() + '\n');
        if (this.state.getFirstTimestamp() != null) {
            sb.append(this.state.getFirstTimestamp());
        }
        sb.append(" / ");
        if (this.state.getSecondTimestamp() != null) {
            sb.append(this.state.getSecondTimestamp());
        }
        return sb.toString();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.state.setEnabled(enabled);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.state.setActive(active);
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean toolTipsEnabled) {
        this.state.setToolTipsEnabled(toolTipsEnabled);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    @Override
    public Integer getFirstTimestamp() {
        return this.state.getFirstTimestamp();
    }

    @Override
    public Integer getSecondTimestamp() {
        return this.state.getSecondTimestamp();
    }

    @Override
    public DfsGraphVertex getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(DfsGraphVertex nodePath) {
        this.state.setNodePath(nodePath);
    }

    @Override
    public void setFirstTimestamp(Integer firstTimestamp) {
        this.state.setFirstTimestamp(firstTimestamp);
    }

    @Override
    public void setSecondTimestamp(Integer secondTimestamp) {
        this.state.setSecondTimestamp(secondTimestamp);
    }
}

