/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.dfs;

import com.mxgraph.model.mxCell;
import simulator.graphs.AbstractGraphCell;
import simulator.graphs.BasicNodeData;
import simulator.graphs.dfs.DfsGraphVertex;

public class DfsGraphEdge
extends AbstractGraphCell {
    protected BasicNodeData state;
    protected DfsEdgeType edgeType;
    protected DfsEdgeType iniEdgeType;

    public DfsGraphEdge() {
        this(DfsEdgeType.NOTHING, false);
    }

    public DfsGraphEdge(boolean enabled) {
        this(DfsEdgeType.NOTHING, enabled);
    }

    public DfsGraphEdge(DfsEdgeType edgeType, boolean enabled) {
        this.edgeType = this.iniEdgeType = edgeType;
        this.state = new BasicNodeData();
        this.state.setEnabled(enabled);
    }

    public DfsEdgeType getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(DfsEdgeType edgeType) {
        this.edgeType = edgeType;
    }

    @Override
    public String getLabel() {
        if (this.state.isEnabled()) {
            return this.edgeType.getStrRepresentation();
        }
        return "";
    }

    @Override
    public String getToolTips() {
        return "";
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.state.setEnabled(enabled);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.state.setActive(active);
    }

    @Override
    public void resetState() {
        this.edgeType = this.iniEdgeType;
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean toolTipsEnabled) {
        this.state.setToolTipsEnabled(toolTipsEnabled);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    public static enum DfsEdgeType {
        NOTHING(""),
        BACK("B"),
        FORWARD("F"),
        CROSS("C"),
        TREE("");

        private String strRepresentation;

        private DfsEdgeType(String strRepresentation) {
            this.strRepresentation = strRepresentation;
        }

        public String getStrRepresentation() {
            return this.strRepresentation;
        }

        public static DfsEdgeType getType(mxCell edge, String style) {
            DfsGraphVertex sValue = (DfsGraphVertex)edge.getSource().getValue();
            DfsGraphVertex tValue = (DfsGraphVertex)edge.getTarget().getValue();
            if (edge.getStyle().equals(style) || tValue.getFirstTimestamp() == null) {
                return NOTHING;
            }
            if (tValue.getSecondTimestamp() == null) {
                return BACK;
            }
            if (tValue.getSecondTimestamp() != null && sValue.getFirstTimestamp() < tValue.getFirstTimestamp()) {
                return FORWARD;
            }
            return CROSS;
        }
    }
}

