/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.bfs;

import simulator.graphs.AbstractGraphCell;
import simulator.graphs.bfs.BfsNodeData;
import simulator.graphs.bfs.BfsOperations;

public class BfsGraphCell
extends AbstractGraphCell
implements BfsOperations {
    protected BfsNodeData state = null;

    public BfsGraphCell() {
        this((String)null);
    }

    public BfsGraphCell(String name) {
        this(name, false);
    }

    public BfsGraphCell(String name, Boolean selected) {
        this(name, new BfsNodeData(), selected);
    }

    public BfsGraphCell(String name, BfsNodeData state, Boolean selected) {
        super(name, selected);
        this.state = state;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled()) {
            return this.getName();
        }
        if (this.state.isInfinity()) {
            return this.getName() + ",\u221e";
        }
        return this.getName() + "," + this.state.getIntValue();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public boolean isInfinity() {
        return this.state.isInfinity();
    }

    @Override
    public void setInfinity(boolean infinity) {
        this.state.setInfinity(infinity);
    }

    @Override
    public int getIntValue() {
        return this.state.getIntValue();
    }

    @Override
    public void setIntValue(int intValue) {
        this.state.setIntValue(intValue);
    }

    @Override
    public BfsGraphCell getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(BfsGraphCell nodePath) {
        this.state.setNodePath(nodePath);
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.state.setEnabled(enabled);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.state.setActive(active);
    }

    @Override
    public void setToolTipsEnabled(boolean toolTipsEnabled) {
        this.state.setToolTipsEnabled(toolTipsEnabled);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }
}

