/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs;

import simulator.graphs.GraphCell;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.GraphVertexData;

public abstract class AbstractGraphCell
implements GraphCell {
    protected boolean editable = false;
    protected GraphVertexData vertexData = new GraphVertexData();
    protected GraphEdgeData edgeData = new GraphEdgeData();

    public AbstractGraphCell() {
        this("");
    }

    public AbstractGraphCell(String name) {
        this(name, false);
    }

    public AbstractGraphCell(String name, Boolean selected) {
        this.vertexData.setName(name);
        this.vertexData.setSelected(selected);
    }

    public AbstractGraphCell(Double distance) {
        this.edgeData.setDistance(distance);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String toString() {
        return "AbstractGraphCell{editable=" + this.editable + ", vertexData=" + this.vertexData + ", edgeData=" + this.edgeData + '}';
    }

    @Override
    public String getName() {
        return this.vertexData.getName();
    }

    @Override
    public void setName(String name) {
        this.vertexData.setName(name);
    }

    @Override
    public Boolean isSelected() {
        return this.vertexData.isSelected();
    }

    @Override
    public Boolean getSelected() {
        return this.vertexData.getSelected();
    }

    @Override
    public void setSelected(Boolean selected) {
        this.vertexData.setSelected(selected);
    }

    @Override
    public GraphVertexBasicData getBasicVertexData() {
        return this.vertexData.getBasicVertexData();
    }

    @Override
    public Double getDistance() {
        return this.edgeData.getDistance();
    }

    @Override
    public void setDistance(Double distance) {
        this.edgeData.setDistance(distance);
    }

    @Override
    public GraphEdgeBasicData getBasicEdgeData() {
        return this.edgeData.getBasicEdgeData();
    }

    @Override
    public void edit(String newValue) {
    }
}

