/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractDfsController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.scc.SccGraphCell;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class SccController
extends AbstractDfsController {
    protected AlgorithmGraphComponent standardGraph;
    protected AlgorithmGraphComponent transposeGraph;
    protected AlgorithmGraphComponent componentsGraph;
    protected AlgorithmGraph mainGraph;
    protected Deque<mxCell> componentNodes = new LinkedList<mxCell>();
    protected SccControllerState state = SccControllerState.NORMAL_GRAPH_DFS_CALL;

    public SccController(AlgorithmGraphComponent graphCom, JLabel graphComponentLabel, VisualizationPseudocodePanel completeCodePanel, VariablesPanel variablesPanel, AlgorithmGraphComponent transposeGraph, AlgorithmGraphComponent componentsGraph) {
        super(graphCom, graphComponentLabel, completeCodePanel, variablesPanel);
        this.mainGraph = this.graph;
        this.transposeGraph = transposeGraph;
        this.standardGraph = graphCom;
        new ExtendedColorStyle((BasicStylesheet)transposeGraph.getGraph().getAlgorithmStylesheet(), transposeGraph.getGraph().getAlgorithmStylesheet().getRootVertexStyle());
        this.componentsGraph = componentsGraph;
        new ExtendedColorStyle((BasicStylesheet)componentsGraph.getGraph().getAlgorithmStylesheet(), componentsGraph.getGraph().getAlgorithmStylesheet().getComponentVertexStyle());
        this.interactiveMode = false;
        this.resetControllerImpl();
        AbstractController.LabelInstruction dfsLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction dfsReturnLabel1 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction dfsReturnLabel2 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 4), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), Color.GREEN));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The first calling DFS"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SelectStartNodeInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.LabelInstruction(dfsLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(dfsReturnLabel1);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Make the transposed graph"));
        this.tape.add(new SetSccAlgStateInstruction(SccControllerState.TRANSPOSE_GRAPH_DFS_CALL));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction(true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 2), this.algorithm.getRealLineNumber(0, 2), this.doneColor));
        this.tape.add(new MakeTransposeGraphInstruction());
        this.tape.add((AbstractController)this.new AbstractController.SetNewActiveGraphInstruction(transposeGraph));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The second calling DFS"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 3), this.algorithm.getRealLineNumber(0, 3), this.doneColor));
        this.tape.add(new AbstractController.LabelInstruction(dfsLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(dfsReturnLabel2);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 4), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), this.doneColor));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(dfsLabel);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        AbstractController.LabelInstruction forLabel = new AbstractController.LabelInstruction();
        this.tape.add(forLabel);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractDfsController.SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 5)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time initialization"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("time", true));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        this.tape.add(new OrderVertexListBySecondTimestampInstruction());
        AbstractController.LabelInstruction forLabel2 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 6)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method\nto all unvisited nodes"));
        this.tape.add(new AbstractController.SetSelectedCellFirstInstruction(this.vertexList));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 7)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        AbstractController.LabelInstruction ifEnd = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(ifEnd, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)SccController.this.activeVariable).getStyle().equals(SccController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new SelectNextScComponentInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 8)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Calling the DFS-VISIT method"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ClearQueueInstruction(this.componentNodes));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        AbstractController.LabelInstruction dfsReturnLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction dfsVisitLabel = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, dfsReturnLabel));
        this.tape.add(new AbstractController.LabelInstruction(dfsVisitLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(dfsReturnLabel);
        this.tape.add(new AbstractController.LabelInstruction(ifEnd, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.NORMAL_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Adding of new strong components"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AddNewScComponentInstruction());
        this.tape.add(ifEnd);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.LabelInstruction(dfsReturnLabel1, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.NORMAL_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(new AbstractController.LabelInstruction(dfsReturnLabel2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(dfsVisitLabel);
        this.tape.add(new AbstractController.EnqueueInstruction(this.componentNodes));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.PushInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The beginning of DFS-VISIT"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("First visit of the node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time increment"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set up of the first time stamp"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(true));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction forEndLabel = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction forLabel3 = new AbstractController.LabelInstruction();
        this.tape.add(forLabel3);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in progress"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forEndLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited yet,\nadjust path and call DFS-VISIT for him"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 6)));
        AbstractController.LabelInstruction ifEnd2 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(ifEnd2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)SccController.this.activeVariable).getStyle().equals(SccController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting of path"));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method on neghboring nodes"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 7)));
        this.tape.add(new AbstractDfsController.SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, ifEnd2));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableV));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.LabelInstruction(dfsVisitLabel, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(ifEnd2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 8)));
        this.tape.add(new AbstractDfsController.SetDfsEdgeTypeInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(forLabel3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(forEndLabel);
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 10)));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Second visit of the node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 11)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getDoneVertexStyle()));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting the second time stamp"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(false));
        this.tape.add(new AbstractController.DequeueInstruction(this.visitStack));
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Algorithm in order to search strongly connected components");
        this.codePanel.setCurrentLine(1);
        ExtendedColorStyle.resetIndex();
        this.variables.put("Stack S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(SccController.this.visitStack);
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return SccController.this.getNodeName(SccController.this.getRegisterValue(SccController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return SccController.this.getNodeName(SccController.this.getRegisterValue(SccController.this.variableV));
            }
        });
        this.variables.put("time", new VariableObject(true, false){

            @Override
            public String getVariableValue() {
                return Integer.toString(SccController.this.timeVariable);
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(SccController.this.vertexList);
            }
        });
        for (Map.Entry e : this.variables.entrySet()) {
            if (!((VariableObject)e.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)e.getKey());
        }
        this.vertexList.clear();
        this.contextStack.clear();
        this.visitStack.clear();
        this.timeVariable = 0;
        this.state = SccControllerState.NORMAL_GRAPH_DFS_CALL;
        this.clearGraphComponent(this.transposeGraph);
        this.transposeGraph.getGraph().refresh();
        this.clearGraphComponent(this.componentsGraph);
        this.transposeGraph.getGraph().refresh();
    }

    @Override
    public void resetController() {
        this.graph = this.mainGraph;
        this.graphComponent = this.standardGraph;
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class SetSccAlgStateEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected SccControllerState newState;
        protected SccControllerState oldState;

        public SetSccAlgStateEdit(SccControllerState newState) {
            this.newState = newState;
            this.oldState = SccController.this.state;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            SccController.this.state = this.oldState;
        }

        @Override
        protected void action() {
            SccController.this.state = this.newState;
        }
    }

    protected class SetSccAlgStateInstruction
    extends AbstractController.BasicInstruction {
        protected SccControllerState newState;

        public SetSccAlgStateInstruction(SccControllerState newState) {
            this.newState = newState;
        }

        @Override
        public void preform() {
            SccController.this.editBlock.addEdit(new SetSccAlgStateEdit(this.newState));
        }
    }

    protected final class MakeTransposeGraphVisibleEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent gc;

        public MakeTransposeGraphVisibleEdit(AlgorithmGraphComponent gc) {
            this.gc = gc;
            this.action();
        }

        protected void setVisible(AlgorithmGraph tg, final boolean visible) {
            tg.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell cell, GraphCell value) {
                    cell.setVisible(visible);
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }

        @Override
        public void undo() {
            super.undo();
            this.setVisible(this.gc.getGraph(), false);
            this.gc.getGraph().refresh();
        }

        @Override
        protected void action() {
            this.setVisible(this.gc.getGraph(), true);
            this.gc.getGraph().refresh();
        }
    }

    protected class MakeTransposeGraphInstruction
    extends AbstractController.BasicInstruction {
        protected MakeTransposeGraphInstruction() {
        }

        @Override
        public void preform() {
            AlgorithmGraph tg = SccController.this.transposeGraph.getGraph();
            tg.addCells(SccController.this.graph.cloneCells(SccController.this.graph.getChildCells(SccController.this.graph.getDefaultParent())));
            tg.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell cell, GraphCell node) {
                    if (cell.isVertex()) {
                        cell.setValue(new DfsGraphVertex(node.getName()));
                        cell.setStyle(SccController.this.stylesheet.getVertexStyle());
                    } else if (cell.isEdge()) {
                        cell.setValue(new DfsGraphEdge());
                        cell.setStyle(SccController.this.stylesheet.getEdgeStyle());
                        mxCell target = (mxCell)cell.getTarget();
                        mxCell source = (mxCell)cell.getSource();
                        cell.setSource(target);
                        cell.setTarget(source);
                    }
                    cell.setVisible(false);
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
            SccController.this.editBlock.addEdit(new MakeTransposeGraphVisibleEdit(SccController.this.transposeGraph));
        }
    }

    protected final class AddNewScComponentEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent gc;
        protected Deque<mxCell> nodesList;
        protected Deque<mxCell> oldList;
        protected mxGraph originalGraph;
        protected List<mxCell> newCells = new ArrayList<mxCell>();
        protected String newStyle;

        public AddNewScComponentEdit(AlgorithmGraphComponent gc, Deque<mxCell> nodesList, mxGraph originalGraph, String newStyle) {
            this.gc = gc;
            this.nodesList = nodesList;
            this.originalGraph = originalGraph;
            this.newStyle = newStyle;
            this.oldList = new LinkedList<mxCell>();
            this.oldList.addAll(nodesList);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.nodesList.clear();
            this.nodesList.addAll(this.oldList);
            for (mxCell cell : this.newCells) {
                this.gc.getGraph().getModel().remove(cell);
            }
            this.newCells.clear();
        }

        protected void makeEdges(AlgorithmGraph cg) {
            HashMap<mxCell, Set<mxCell>> adjs = new HashMap<mxCell, Set<mxCell>>();
            for (int i = 0; i < cg.getModel().getChildCount(cg.getDefaultParent()); ++i) {
                mxCell cell1 = (mxCell)cg.getModel().getChildAt(cg.getDefaultParent(), i);
                if (!cell1.isVertex()) continue;
                adjs.put(cell1, ((SccGraphCell)cell1.getValue()).makeAdj(this.originalGraph, true));
            }
            for (Map.Entry e1 : adjs.entrySet()) {
                block2: for (Map.Entry e2 : adjs.entrySet()) {
                    if (e1.getKey() == e2.getKey() || cg.getEdgesBetween(e1.getKey(), e2.getKey(), false).length != 0) continue;
                    for (mxCell cellInSet : (Set)e1.getValue()) {
                        if (!((SccGraphCell)((mxCell)e2.getKey()).getValue()).getNodes().contains(cellInSet)) continue;
                        this.newCells.add((mxCell)cg.insertEdge(cg.getDefaultParent(), null, new DfsGraphEdge(), e1.getKey(), e2.getKey(), SccController.this.stylesheet.getEdgeStyle()));
                        continue block2;
                    }
                }
            }
        }

        @Override
        protected void action() {
            AlgorithmGraph cg = this.gc.getGraph();
            double x = 0.0;
            double y = 0.0;
            StringBuilder name = new StringBuilder();
            if (this.nodesList.size() > 0) {
                SccGraphCell newCell = new SccGraphCell();
                for (mxCell cell : this.nodesList) {
                    DfsGraphVertex value = (DfsGraphVertex)cell.getValue();
                    name.append(value.getName());
                    x += cell.getGeometry().getX();
                    y += cell.getGeometry().getY();
                    newCell.addNode(cell);
                }
                newCell.setName(name.toString());
                this.newCells.add((mxCell)cg.insertVertex(cg.getDefaultParent(), null, newCell, x /= (double)this.nodesList.size(), y /= (double)this.nodesList.size(), 80.0, 80.0, this.newStyle));
                this.nodesList.clear();
                this.makeEdges(cg);
            }
        }
    }

    protected class AddNewScComponentInstruction
    extends AbstractController.BasicInstruction {
        protected AddNewScComponentInstruction() {
        }

        @Override
        public void preform() {
            String style = ExtendedColorStyle.getNextStyle();
            for (mxCell cell : SccController.this.componentNodes) {
                SccController.this.editBlock.addEdit(new AbstractController.SetColorEdit(style, cell));
            }
            SccController.this.editBlock.addEdit(new AddNewScComponentEdit(SccController.this.componentsGraph, SccController.this.componentNodes, SccController.this.graph, style));
        }
    }

    protected final class OrderVertexListBySecondTimestampEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<mxCell> cellList;
        protected Deque<mxCell> oldCellList;
        protected AlgorithmGraph cellsGraph;

        public OrderVertexListBySecondTimestampEdit(Deque<mxCell> cellList, AlgorithmGraph cellsGraph) {
            this.cellList = cellList;
            this.oldCellList = new LinkedList<mxCell>();
            this.oldCellList.addAll(cellList);
            this.cellsGraph = cellsGraph;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.cellList.clear();
            this.cellList.addAll(this.oldCellList);
        }

        @Override
        protected void action() {
            Collections.sort((List)((Object)this.cellList), new Comparator<mxCell>(){
                private int firstCellTime;
                private int secondCellTime;

                @Override
                public int compare(mxCell o1, mxCell o2) {
                    final DfsGraphVertex value1 = (DfsGraphVertex)o1.getValue();
                    final DfsGraphVertex value2 = (DfsGraphVertex)o2.getValue();
                    this.firstCellTime = 0;
                    this.secondCellTime = 0;
                    OrderVertexListBySecondTimestampEdit.this.cellsGraph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                        @Override
                        public boolean visit(mxCell cell, GraphCell node) {
                            if (value1.getName().equals(node.getName())) {
                                firstCellTime = ((DfsGraphVertex)node).getSecondTimestamp();
                            } else if (value2.getName().equals(node.getName())) {
                                secondCellTime = ((DfsGraphVertex)node).getSecondTimestamp();
                            }
                            return firstCellTime == 0 || secondCellTime == 0;
                        }

                        @Override
                        public boolean allowEdge() {
                            return false;
                        }
                    });
                    return this.secondCellTime - this.firstCellTime;
                }
            });
        }
    }

    protected class OrderVertexListBySecondTimestampInstruction
    extends AbstractController.BasicInstruction {
        protected OrderVertexListBySecondTimestampInstruction() {
        }

        @Override
        public void preform() {
            if (SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL) {
                SccController.this.editBlock.addEdit(new OrderVertexListBySecondTimestampEdit(SccController.this.vertexList, SccController.this.mainGraph));
            }
        }
    }

    protected class SelectNextScComponentInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected Deque<mxCell> expectedNodes = new LinkedList<mxCell>();

        public SelectNextScComponentInstruction() {
            this.adapter = new SelectCellsMouseAdapter(SccController.this.transposeGraph, SccController.this.graph);
            this.adapter.setActivated(false);
            SccController.this.transposeGraph.getGraphControl().addMouseListener(this.adapter);
        }

        protected void makeExpectedList(mxCell startCell) {
            LinkedList<mxCell> stack = new LinkedList<mxCell>();
            stack.push(startCell);
            while (!stack.isEmpty()) {
                mxCell cell = (mxCell)stack.pop();
                for (int i = 0; i < SccController.this.graph.getModel().getEdgeCount(cell); ++i) {
                    mxCell edge = (mxCell)SccController.this.graph.getModel().getEdgeAt(cell, i);
                    mxCell source = (mxCell)edge.getSource();
                    mxCell target = (mxCell)edge.getTarget();
                    if (source != cell || this.expectedNodes.contains(target) || !target.getStyle().equals(SccController.this.stylesheet.getInitVertexStyle())) continue;
                    stack.push(target);
                }
                if (this.expectedNodes.contains(cell)) continue;
                this.expectedNodes.add(cell);
            }
        }

        @Override
        public void preform() {
            if (SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL) {
                if (!this.adapter.isActivated()) {
                    this.expectedNodes.clear();
                    this.makeExpectedList((mxCell)SccController.this.getRegisterValue(SccController.this.variableU));
                    SccController.this.graphComponentLabel.setText(SccController.this.getTextForLabel("Select nodes of the next component and continue\n[u\u017eivatelsk\u00e1 akce]"));
                    SccController.this.timer.setEnabled(false);
                    this.adapter.setActivated(true);
                } else if (this.adapter.getLastSelected() != null) {
                    Deque<mxCell> selected = this.adapter.getSelectedNodes();
                    if (selected.size() == this.expectedNodes.size() && selected.containsAll(this.expectedNodes)) {
                        this.stop();
                        return;
                    }
                    SccController.this.graphComponentLabel.setText(SccController.this.getTextForLabel("Wrong nodes of the strong components selected\n[u\u017eivatelsk\u00e1 akce]"));
                }
                SccController.this.pause = true;
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return SccController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                SccController.this.timer.setEnabled(true);
            }
        }
    }

    protected static class ExtendedColorStyle {
        protected BasicStylesheet extendedSheet;
        private static String[] names = new String[]{"AERO", "AMETHYST", "APPLE", "X11GRAY", "AURELION", "BLUSH", "CADMIUM_ORANGE", "MAROON", "CG Blue", "DARK_PASTER_GREEN", "CHARCOAL", "CAFE_AU_LAIT", "HAN_PURPLE", "MODE_NEIGE", "MINT", "FERRARI_RED"};
        protected String fromStyle;
        private static int index = 0;

        public ExtendedColorStyle(BasicStylesheet transposeStylesheet, String fromStyle) {
            this.extendedSheet = transposeStylesheet;
            this.fromStyle = fromStyle;
            this.addNewColorStyle(names[0], "#7CB9E8");
            this.addNewColorStyle(names[1], "#9966CC");
            this.addNewColorStyle(names[2], "#8DB600");
            this.addNewColorStyle(names[3], "#BEBEBE");
            this.addNewColorStyle(names[4], "#FDEE00");
            this.addNewColorStyle(names[5], "#DE5D83");
            this.addNewColorStyle(names[6], "#ED872D");
            this.addNewColorStyle(names[7], "#800000");
            this.addNewColorStyle(names[8], "#007AA5");
            this.addNewColorStyle(names[9], "#03C03C");
            this.addNewColorStyle(names[10], "#36454F");
            this.addNewColorStyle(names[11], "#A67B5B");
            this.addNewColorStyle(names[12], "#5218FA");
            this.addNewColorStyle(names[13], "#967117");
            this.addNewColorStyle(names[14], "#3EB489");
            this.addNewColorStyle(names[15], "#FF2800");
        }

        private void addNewColorStyle(String name, String color) {
            HashMap<String, Object> newStyles = new HashMap<String, Object>();
            newStyles.putAll(this.extendedSheet.getStyles().get(this.fromStyle));
            newStyles.put(mxConstants.STYLE_FILLCOLOR, color);
            this.extendedSheet.putCellStyle(name, newStyles);
        }

        public static String getNextStyle() {
            return names[index++ % names.length];
        }

        public static void resetIndex() {
            index = 0;
        }
    }

    protected static enum SccControllerState {
        NORMAL_GRAPH_DFS_CALL,
        TRANSPOSE_GRAPH_DFS_CALL;

    }
}

