/*
 * Decompiled with CFR 0.152.
 */
package simulator.algorithms;

import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class AlgorithmBase {
    public static final String algorithmNumLineAttribut = "lineNum";
    public static final String algorithmRealLineAttribut = "line";
    public static final String algorithmHeadingName = "AlgorithmHeading";
    public static final String algorithmLineName0 = "AlgorithmLine0";
    public static final String algorithmLineName1 = "AlgorithmLine1";
    public static final String algorithmLineName2 = "AlgorithmLine2";
    public static final String algorithmLineName3 = "AlgorithmLine3";
    public static final String algorithmLineName4 = "AlgorithmLine4";
    public static final String algorithmLineName5 = "AlgorithmLine5";
    public static final String algorithmName = "AlgorithmName";
    public static final String algorithmKeywordsName = "AlgorithmKeywords";
    public static final String algorithmVariableName = "AlgorithmVariable";
    public static final String algorithmMethodsName = "AlgorithmMethods";
    public static final String algorithmOthersName = "AlgorithmOthers";
    public static final String algorithmSuperscriptName = "AlgorithmSuperscript";
    protected StyleContext algorithmsStyleContext = new StyleContext();

    public AlgorithmBase() {
        this.makeStyle();
    }

    private void makeStyle() {
        Style defaultStyle = this.algorithmsStyleContext.getStyle("default");
        Style mainStyle = this.algorithmsStyleContext.addStyle(algorithmHeadingName, defaultStyle);
        StyleConstants.setFontFamily(mainStyle, "serif");
        StyleConstants.setFontSize(mainStyle, 22);
        Style lineStyle0 = this.algorithmsStyleContext.addStyle(algorithmLineName0, defaultStyle);
        StyleConstants.setFontFamily(lineStyle0, "serif");
        StyleConstants.setFontSize(lineStyle0, 18);
        StyleConstants.setLeftIndent(lineStyle0, 15.0f);
        Style lineStyle1 = this.algorithmsStyleContext.addStyle(algorithmLineName1, lineStyle0);
        StyleConstants.setLeftIndent(lineStyle1, 30.0f);
        Style lineStyle2 = this.algorithmsStyleContext.addStyle(algorithmLineName2, lineStyle0);
        StyleConstants.setLeftIndent(lineStyle2, 45.0f);
        Style lineStyle3 = this.algorithmsStyleContext.addStyle(algorithmLineName3, lineStyle0);
        StyleConstants.setLeftIndent(lineStyle3, 60.0f);
        Style mainNameStyle = this.algorithmsStyleContext.addStyle(algorithmName, defaultStyle);
        StyleConstants.setBold(mainNameStyle, true);
        Style keywordsStyle = this.algorithmsStyleContext.addStyle(algorithmKeywordsName, defaultStyle);
        StyleConstants.setBold(keywordsStyle, true);
        Style variablesStyle = this.algorithmsStyleContext.addStyle(algorithmVariableName, defaultStyle);
        StyleConstants.setItalic(variablesStyle, true);
        Style methodsStyle = this.algorithmsStyleContext.addStyle(algorithmMethodsName, defaultStyle);
        Style othersStyle = this.algorithmsStyleContext.addStyle(algorithmOthersName, defaultStyle);
        Style superscriptStyle = this.algorithmsStyleContext.addStyle(algorithmSuperscriptName, defaultStyle);
        StyleConstants.setSuperscript(superscriptStyle, true);
    }

    public Style getAlgorithmsStyle(String styleName) {
        return this.algorithmsStyleContext.getStyle(styleName);
    }

    public static class AlgorithmElement {
        protected String styleName;
        protected AlgorithmContent[] contentArray;

        public AlgorithmElement(String styleName, AlgorithmContent[] contentArray) {
            this.styleName = styleName;
            this.contentArray = contentArray;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public AlgorithmContent[] getContentArray() {
            return this.contentArray;
        }
    }

    public static class AlgorithmContent {
        protected String styleName;
        protected String content;

        public AlgorithmContent(String styleName, String content) {
            this.styleName = styleName;
            this.content = content;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public String getContent() {
            return this.content;
        }
    }
}

