/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUndoManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import program.MainPanel;
import program.actions.ActionLogger;
import program.actions.BasicActions;

public class MenuBar
extends JMenuBar
implements mxEventSource.mxIEventListener,
PropertyChangeListener {
    private static Logger logger = LogManager.getLogger(MenuBar.class.getName());
    protected MainPanel mainPanel;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem aboutItem;
    protected JMenuItem fullscreenItem;

    public MenuBar(MainPanel mainPanel) {
        logger.entry(mainPanel);
        if (mainPanel == null) {
            throw new NullPointerException();
        }
        this.mainPanel = mainPanel;
        this.addFileItems();
        this.addEditMenu();
        this.addViewMenu();
        this.addSimulateMenu();
        this.addWindowMenu();
        this.addLanguageItems();
        this.addHelpMenu();
        logger.exit();
    }

    private void addFileItems() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("file")));
        menu.add(this.mainPanel.bind(mxResources.get("newGraph"), new ActionLogger(new BasicActions.NewAction()), "/images/new.gif")).setAccelerator(KeyStroke.getKeyStroke(78, 3));
        menu.add(this.mainPanel.bind(mxResources.get("openFile"), new ActionLogger(new BasicActions.OpenAction()), "/images/open.gif")).setAccelerator(KeyStroke.getKeyStroke(79, 3));
        menu.addSeparator();
        menu.add(this.mainPanel.bind(mxResources.get("save"), new ActionLogger(new BasicActions.SaveAction(false)), "/images/save.gif")).setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menu.add(this.mainPanel.bind(mxResources.get("saveAs"), new ActionLogger(new BasicActions.SaveAction(true)), "/images/saveas.gif"));
        menu.addSeparator();
        menu.add(this.mainPanel.bind(mxResources.get("exit"), new BasicActions.ExitAction()));
        logger.exit();
    }

    private void addEditMenu() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("edit")));
        this.undoItem = menu.add(this.mainPanel.bind(mxResources.get("undo"), new ActionLogger(new BasicActions.UndoAction()), "/images/undo.gif"));
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoItem.setEnabled(false);
        this.redoItem = menu.add(this.mainPanel.bind(mxResources.get("redo"), new ActionLogger(new BasicActions.RedoAction()), "/images/redo.gif"));
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoItem.setEnabled(false);
        menu.addSeparator();
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("cut"), new ActionLogger(TransferHandler.getCutAction()), "/images/cut.gif")).setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("copy"), new ActionLogger(TransferHandler.getCopyAction()), "/images/copy.gif")).setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("paste"), new ActionLogger(TransferHandler.getPasteAction()), "/images/paste.gif")).setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menu.addSeparator();
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("delete"), new ActionLogger(mxGraphActions.getDeleteAction()), "/images/delete.gif")).setAccelerator(KeyStroke.getKeyStroke(127, 0));
        menu.addSeparator();
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("selectAll"), new ActionLogger(mxGraphActions.getSelectAllAction()))).setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("selectAllEdges"), new ActionLogger(mxGraphActions.getSelectEdgesAction())));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("selectAllVertices"), new ActionLogger(mxGraphActions.getSelectVerticesAction())));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("selectNone"), new ActionLogger(mxGraphActions.getSelectNoneAction())));
        menu.addSeparator();
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("setSelected"), new ActionLogger(new BasicActions.SetCellSelectedAction()))).setAccelerator(KeyStroke.getKeyStroke(' '));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("edit"), new ActionLogger(mxGraphActions.getEditAction())));
        menu.add(this.mainPanel.bindGraphAction(mxResources.get("setStyle"), new ActionLogger(new BasicActions.SetStyleAction())));
        logger.exit();
    }

    private void addViewMenu() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("view")));
        JMenu submenu = (JMenu)menu.add(new JMenu(mxResources.get("zoom")));
        submenu.add(this.mainPanel.bind("400%", new BasicActions.ZoomAction(4.0)));
        submenu.add(this.mainPanel.bind("200%", new BasicActions.ZoomAction(2.0)));
        submenu.add(this.mainPanel.bind("150%", new BasicActions.ZoomAction(1.5)));
        submenu.add(this.mainPanel.bind("100%", new BasicActions.ZoomAction(1.0)));
        submenu.add(this.mainPanel.bind("75%", new BasicActions.ZoomAction(0.75)));
        submenu.add(this.mainPanel.bind("50%", new BasicActions.ZoomAction(0.5)));
        menu.add(submenu);
        menu.addSeparator();
        menu.add(this.mainPanel.bind(mxResources.get("maximize"), new ActionLogger(new BasicActions.MaximizeAction())));
        logger.exit();
    }

    private void addSimulateMenu() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("simulate")));
        menu.add(this.mainPanel.bind(mxResources.get("BFS"), new ActionLogger(new BasicActions.BfsSimulatorAction())));
        menu.addSeparator();
        menu.add(this.mainPanel.bind(mxResources.get("DFS"), new ActionLogger(new BasicActions.DfsSimulatorAction())));
        menu.add(this.mainPanel.bind(mxResources.get("TopologicalSort"), new ActionLogger(new BasicActions.TopologicalSortSimulatorAction())));
        menu.add(this.mainPanel.bind(mxResources.get("SCC"), new ActionLogger(new BasicActions.SccSimulatorAction())));
        menu.addSeparator();
        menu.add(this.mainPanel.bind(mxResources.get("BellmanFord"), new ActionLogger(new BasicActions.BellmanFordSimulatorAction())));
        menu.add(this.mainPanel.bind(mxResources.get("Dijkstra"), new ActionLogger(new BasicActions.DijkstraSimulatorAction())));
        logger.exit();
    }

    private void addLanguageItems() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("language")));
        menu.add(this.mainPanel.bind(mxResources.get("czech"), new ActionLogger(new BasicActions.CzechLanguageAction()), "/images/cze.gif"));
        menu.add(this.mainPanel.bind(mxResources.get("english"), new ActionLogger(new BasicActions.EnglishLanguageAction()), "/images/uk.gif"));
        logger.exit();
    }

    private void addWindowMenu() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("window")));
        menu.add(new JCheckBoxMenuItem(this.mainPanel.bind(mxResources.get("toolBarLabel"), new ActionLogger(new BasicActions.ToolBarLabelsAction()))));
        menu.addSeparator();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < lafs.length; ++i) {
            final String className = lafs[i].getClassName();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(new AbstractAction(lafs[i].getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuBar.this.mainPanel.setLookAndFeel(className);
                }
            });
            if (lafs[i].getName().equals(UIManager.getLookAndFeel().getName())) {
                item.setSelected(true);
            }
            buttonGroup.add(item);
            menu.add(item);
        }
        logger.exit();
    }

    private void addHelpMenu() {
        logger.entry();
        JMenu menu = this.add(new JMenu(mxResources.get("help")));
        this.aboutItem = menu.add(this.mainPanel.bind(mxResources.get("about"), new ActionLogger(new BasicActions.AboutAction())));
        menu.add(this.mainPanel.bind(mxResources.get("manual"), new ActionLogger(new BasicActions.ShowManualAction())));
        logger.exit();
    }

    @Override
    public void invoke(Object sender, mxEventObject evt) {
        logger.entry(sender, evt);
        if (sender != null && sender instanceof mxUndoManager) {
            mxUndoManager undoManager = (mxUndoManager)sender;
            this.redoItem.setEnabled(undoManager.canRedo());
            this.undoItem.setEnabled(undoManager.canUndo());
        }
        logger.exit();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.entry(evt);
        switch (evt.getPropertyName()) {
            case "Fullscreen": {
                this.aboutItem.setEnabled((Boolean)evt.getNewValue() == false);
            }
        }
        logger.exit();
    }
}

