/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import simulator.algorithms.AlgorithmScc;
import simulator.controllers.SccController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.scc.SccStyleSheet;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class SccPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public SccPanel(AlgorithmGraph algorithmGraph) {
        this.makeSccGraph(algorithmGraph);
        algorithmGraph.setOriented(true);
        if (!algorithmGraph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            algorithmGraph.getAlgorithmStylesheet().setDirected(true);
        }
        algorithmGraph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(algorithmGraph, new AlgorithmScc());
        final AlgorithmGraphComponent algorithmGraphComponent = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(SccStyleSheet.getStylesheet(), true));
        mxRubberband mxRubberband2 = new mxRubberband((mxGraphComponent)algorithmGraphComponent);
        algorithmGraphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() < 0) {
                        algorithmGraphComponent.zoomIn();
                    } else {
                        algorithmGraphComponent.zoomOut();
                    }
                }
            }
        });
        final AlgorithmGraphComponent algorithmGraphComponent2 = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(SccStyleSheet.getStylesheet(), true));
        algorithmGraphComponent2.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() < 0) {
                        algorithmGraphComponent2.zoomIn();
                    } else {
                        algorithmGraphComponent2.zoomOut();
                    }
                }
            }
        });
        mxRubberband mxRubberband3 = new mxRubberband((mxGraphComponent)algorithmGraphComponent2);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Transpose Graph", (Component)((Object)algorithmGraphComponent));
        jTabbedPane.add("Component Graph", (Component)((Object)algorithmGraphComponent2));
        JSplitPane jSplitPane = new JSplitPane(0, (Component)((Object)this.simulatorPanel.getGraphComponent()), jTabbedPane);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(350);
        jSplitPane.setResizeWeight(1.0);
        this.simulatorPanel.getGraphPanel().add((Component)jSplitPane, "Center");
        SccController sccController = new SccController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel(), algorithmGraphComponent, algorithmGraphComponent2);
        this.simulatorPanel.setController(sccController);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeSccGraph(AlgorithmGraph algorithmGraph) {
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)algorithmGraph.getModel(), (Object)algorithmGraph.getDefaultParent())) {
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.isVertex()) {
                if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(mxCell2.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData graphVertexBasicData = (GraphVertexBasicData)mxCell2.getValue();
                    mxCell2.setValue((Object)new DfsGraphVertex(graphVertexBasicData.getName(), graphVertexBasicData.isSelected()));
                }
                mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (mxCell2.getValue() != null && !(mxCell2.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            mxCell2.setValue((Object)new DfsGraphEdge());
            mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

