/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import simulator.algorithms.AlgorithmBfs;
import simulator.controllers.BfsController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.bfs.BfsGraphCell;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class BfsPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public BfsPanel(AlgorithmGraph algorithmGraph) {
        this.makeBfsGraph(algorithmGraph);
        algorithmGraph.refresh();
        algorithmGraph.setOriented(algorithmGraph.getAlgorithmStylesheet().isDirectedEgeStyle());
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(algorithmGraph, new AlgorithmBfs());
        this.simulatorPanel.getGraphPanel().add((Component)((Object)this.simulatorPanel.getGraphComponent()), "Center");
        BfsController bfsController = new BfsController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(bfsController);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeBfsGraph(AlgorithmGraph algorithmGraph) {
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)algorithmGraph.getModel(), (Object)algorithmGraph.getDefaultParent())) {
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.isVertex()) {
                if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(mxCell2.getValue() instanceof BfsGraphCell)) {
                    GraphVertexBasicData graphVertexBasicData = (GraphVertexBasicData)mxCell2.getValue();
                    mxCell2.setValue((Object)new BfsGraphCell(graphVertexBasicData.getName(), graphVertexBasicData.isSelected()));
                }
                mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            mxCell2.setValue(null);
            mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

