/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import simulator.algorithms.AlgorithmBellmanFord;
import simulator.controllers.BellmanFordController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class BellmanFordPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public BellmanFordPanel(AlgorithmGraph algorithmGraph) {
        this.makeBellmanFordGraph(algorithmGraph);
        algorithmGraph.setOriented(true);
        if (!algorithmGraph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            algorithmGraph.getAlgorithmStylesheet().setDirected(true);
        }
        algorithmGraph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(algorithmGraph, new AlgorithmBellmanFord());
        this.simulatorPanel.getGraphPanel().add((Component)((Object)this.simulatorPanel.getGraphComponent()), "Center");
        BellmanFordController bellmanFordController = new BellmanFordController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(bellmanFordController);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeBellmanFordGraph(AlgorithmGraph algorithmGraph) {
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)algorithmGraph.getModel(), (Object)algorithmGraph.getDefaultParent())) {
            Serializable serializable;
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.isVertex()) {
                if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(mxCell2.getValue() instanceof BellmanFordGraphVertex)) {
                    serializable = (GraphVertexBasicData)mxCell2.getValue();
                    mxCell2.setValue((Object)new BellmanFordGraphVertex(serializable.getName(), serializable.isSelected()));
                }
                mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            if (mxCell2.getValue() instanceof BellmanFordGraphEdge) continue;
            serializable = (GraphEdgeBasicData)mxCell2.getValue();
            mxCell2.setValue((Object)new BellmanFordGraphEdge(serializable.getDistance()));
            mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

