/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class VariablesPanel
extends JPanel {
    private JTable varTable;
    private JTable nodeMatrixTable;
    private VariablesTableModel tableModelVar;
    private VariablesTableModel tableModelNodeMatrix;
    private JTextField textField = new JTextField();
    private JToolBar toolBar1;
    private JToolBar toolBar2;

    public VariablesPanel() {
        this.setLayout(new BorderLayout());
        this.tableModelVar = new VariablesTableModel(new String[]{"Variable name", "Value"});
        this.varTable = new JTable(this.tableModelVar);
        this.varTable.setSelectionMode(0);
        this.tableModelNodeMatrix = new VariablesTableModel(new String[]{"Nodel", "List of neighbours"});
        this.nodeMatrixTable = new JTable(this.tableModelNodeMatrix);
        this.toolBar1 = new JToolBar();
        this.toolBar1.setRollover(false);
        this.toolBar1.setUI(new VariablesToolBarUI());
        this.toolBar2 = new JToolBar();
        this.toolBar2.setRollover(false);
        this.toolBar2.setUI(new VariablesToolBarUI());
        this.toolBar1.add(new JScrollPane(this.varTable));
        this.toolBar2.add(new JScrollPane(this.nodeMatrixTable));
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.add(this.toolBar1);
        box.add(jPanel);
        box.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        jPanel2.add(this.toolBar2);
        box.add(jPanel2);
        this.add((Component)box, "Center");
        this.tablesSetting(this.varTable, this.tableModelVar);
        this.tablesSetting(this.nodeMatrixTable, this.tableModelNodeMatrix);
    }

    private void tablesSetting(final JTable jTable, final VariablesTableModel variablesTableModel) {
        jTable.setSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jTable.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor());
        jTable.getColumnModel().getColumn(0).setMinWidth(95);
        jTable.getColumnModel().getColumn(1).setMinWidth(95);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(Short.MAX_VALUE);
        Font font = new Font("SansSerif", 0, 16);
        jTable.setFont(font);
        jTable.setRowHeight(jTable.getFontMetrics(font).getHeight());
        variablesTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (variablesTableModel.getValueAt(jTable.getSelectedRow(), jTable.getSelectedColumn()) != null) {
                    VariablesPanel.this.textField.setText(variablesTableModel.getValueAt(jTable.getSelectedRow(), jTable.getSelectedColumn()).toString());
                }
            }
        });
        jTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((JTable)keyEvent.getSource()).clearSelection();
                }
            }
        });
    }

    public void dockTables() {
        ((VariablesToolBarUI)this.toolBar1.getUI()).returnPanel();
        ((VariablesToolBarUI)this.toolBar2.getUI()).returnPanel();
    }

    public void addNodeAdjList(String string, String string2) {
        this.addData(this.tableModelNodeMatrix, string, string2);
    }

    public void addVariable(String string) {
        this.addVariable(string, null);
    }

    public void addVariable(String string, String string2) {
        this.addData(this.tableModelVar, string, string2);
    }

    private void addData(VariablesTableModel variablesTableModel, String string, String string2) {
        if (variablesTableModel.getData().containsKey(string)) {
            variablesTableModel.getData().get(string).put(variablesTableModel.getColumnName(1), string2);
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(variablesTableModel.getColumnName(0), string);
            hashMap.put(variablesTableModel.getColumnName(1), string2);
            variablesTableModel.getData().put(string, hashMap);
        }
        variablesTableModel.fireTableDataChanged();
    }

    public void removeVariable(String string) {
        if (this.tableModelVar.getData().containsKey(string)) {
            this.tableModelVar.getData().remove(string);
            this.tableModelVar.fireTableDataChanged();
        }
    }

    public class MyTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public MyTableCellEditor() {
            super(VariablesPanel.this.textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl, n, 1);
            jTextField.setFont(new Font("Serif", 0, 12));
            jTextField.setEditable(false);
            return jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    public static class VariablesTableModel
    extends DefaultTableModel {
        private String[] columnNames;
        private Map<String, Map<String, String>> data = new LinkedHashMap<String, Map<String, String>>();

        public VariablesTableModel(String[] stringArray) {
            this.columnNames = stringArray;
        }

        public Map<String, Map<String, String>> getData() {
            return this.data;
        }

        public void setData(Map<String, Map<String, String>> map) {
            this.data = map;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = 0;
            for (Map<String, String> map : this.data.values()) {
                if (n3 == n) {
                    return map.get(this.columnNames[n2]);
                }
                ++n3;
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class VariablesToolBarUI
    extends BasicToolBarUI {
        private JDialog dialog;
        private Dimension toolBarPreferredSize;
        private Dimension newBarPreferredSize = new Dimension(300, 100);

        VariablesToolBarUI() {
        }

        public void returnPanel() {
            this.toolBar.setPreferredSize(this.toolBarPreferredSize);
            this.setFloating(false, null);
        }

        @Override
        protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
            Window window = SwingUtilities.getWindowAncestor(jToolBar);
            this.dialog = new JDialog((Frame)null, jToolBar.getName(), false);
            this.dialog.getRootPane().setName("ToolBar.FloatingWindow");
            this.dialog.setTitle(jToolBar.getName());
            this.dialog.setResizable(true);
            this.dialog.setAlwaysOnTop(false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    VariablesToolBarUI.this.toolBar.setPreferredSize(VariablesToolBarUI.this.toolBarPreferredSize);
                }
            });
            WindowListener windowListener = this.createFrameListener();
            this.dialog.addWindowListener(windowListener);
            return this.dialog;
        }

        @Override
        protected void dragTo(Point point, Point point2) {
            if (!this.toolBar.getPreferredSize().equals(this.newBarPreferredSize)) {
                this.toolBarPreferredSize = this.toolBar.getPreferredSize();
                this.toolBar.setPreferredSize(this.newBarPreferredSize);
            }
            super.dragTo(point, point2);
        }
    }
}

