/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LineHighlighter
implements Highlighter.HighlightPainter {
    protected int actualLine = 0;
    protected Color actualLineHighlightColor;
    protected Map<Integer, Color> highlighedLines = new HashMap<Integer, Color>();
    protected Map<Integer, Color> highlighedStartOfLines = new HashMap<Integer, Color>();
    protected boolean resetCarretsetting = true;

    public LineHighlighter(Color color) {
        this.actualLineHighlightColor = color;
    }

    protected void paintBeginHighlight(Graphics graphics, JTextComponent jTextComponent, Element element) throws BadLocationException {
        TextUI textUI = jTextComponent.getUI();
        Rectangle rectangle = textUI.modelToView(jTextComponent, element.getStartOffset());
        Rectangle rectangle2 = textUI.modelToView(jTextComponent, element.getEndOffset());
        graphics.fillRect(0, rectangle.y, 10, rectangle2.y - rectangle.y);
    }

    protected void paintWholeHighlight(Graphics graphics, JTextComponent jTextComponent, Element element) throws BadLocationException {
        TextUI textUI = jTextComponent.getUI();
        Rectangle rectangle = textUI.modelToView(jTextComponent, element.getStartOffset());
        Rectangle rectangle2 = textUI.modelToView(jTextComponent, element.getEndOffset());
        graphics.fillRect(0, rectangle.y, jTextComponent.getWidth(), rectangle2.y - rectangle.y);
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        try {
            Element element = jTextComponent.getDocument().getDefaultRootElement();
            int n3 = element.getStartOffset();
            int n4 = element.getEndOffset();
            while (n3 <= n4) {
                Element element2 = element.getElement(element.getElementIndex(n3));
                Object object = element2.getAttributes().getAttribute("line");
                if (object != null) {
                    int n5 = (Integer)object;
                    if (n5 == this.actualLine && this.actualLineHighlightColor != null) {
                        graphics.setColor(this.actualLineHighlightColor);
                        this.paintWholeHighlight(graphics, jTextComponent, element2);
                    }
                    if (this.highlighedStartOfLines.containsKey(n5)) {
                        graphics.setColor(this.highlighedStartOfLines.get(n5));
                        this.paintBeginHighlight(graphics, jTextComponent, element2);
                    } else if (this.highlighedLines.containsKey(n5)) {
                        graphics.setColor(this.highlighedLines.get(n5));
                        this.paintWholeHighlight(graphics, jTextComponent, element2);
                    }
                }
                n3 = element2.getEndOffset() + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(LineHighlighter.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    public void clearAllHighlight() {
        this.highlighedLines.clear();
    }

    public void highlightLine(int n, Color color) {
        this.highlighedLines.put(n, color);
    }

    public void clearAllhighlightStart() {
        this.highlighedStartOfLines.clear();
    }

    public Map<Integer, Color> getAllhighlightStart() {
        HashMap<Integer, Color> hashMap = new HashMap<Integer, Color>();
        hashMap.putAll(this.highlighedStartOfLines);
        return hashMap;
    }

    public void highlightLineStart(int n, Color color) {
        this.highlighedStartOfLines.put(n, color);
    }

    public void setActualLineHighlightColor(Color color) {
        this.actualLineHighlightColor = color;
    }

    public Color getActualLineHighlightColor() {
        return this.actualLineHighlightColor;
    }

    public int getActualLine() {
        return this.actualLine;
    }

    public void setActualLine(int n) {
        this.resetCarretsetting = true;
        this.actualLine = n;
    }
}

