/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LayerUI;
import simulator.algorithms.AbstractAlgorithm;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.gui.ControlPanel;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractSimulatorPanel
extends JPanel {
    protected VisualizationPseudocodePanel codePanel;
    protected AlgorithmGraph graph;
    protected AbstractAlgorithm algorithm;
    protected AlgorithmGraphComponent graphComponent;
    protected JPopupMenu popup;
    protected AbstractController controller;
    protected VariablesPanel variablesPanel;
    protected JSplitPane codeAndVariablesPanel;
    protected JPanel graphPanel;
    protected JLabel label;
    protected PropertyChangeListener playPropertyChangeListener;

    public AbstractSimulatorPanel(final AlgorithmGraph algorithmGraph, AbstractAlgorithm abstractAlgorithm) {
        if (algorithmGraph == null || abstractAlgorithm == null) {
            throw new NullPointerException();
        }
        this.algorithm = abstractAlgorithm;
        this.graph = algorithmGraph;
        this.setLayout(new GridLayout(0, 1));
        this.graphComponent = AbstractSimulatorPanel.getmxGraphComponent(algorithmGraph);
        algorithmGraph.getModel().addListener("change", new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
                algorithmGraph.refresh();
            }
        });
        mxRubberband mxRubberband2 = new mxRubberband((mxGraphComponent)this.graphComponent);
        this.graphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() < 0) {
                        AbstractSimulatorPanel.this.graphComponent.zoomIn();
                    } else {
                        AbstractSimulatorPanel.this.graphComponent.zoomOut();
                    }
                }
            }
        });
        this.codePanel = new VisualizationPseudocodePanel(abstractAlgorithm);
        this.variablesPanel = new VariablesPanel();
        this.codePanel.getControlPanel().getForwardButton().setAction(new AbstractAction("Forward", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_fwd_48.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.controller.performNext();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "forward");
        this.getActionMap().put("forward", this.codePanel.getControlPanel().getForwardButton().getAction());
        this.codePanel.getControlPanel().getBackButton().setAction(new AbstractAction("Backward", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_rew_48.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.controller.performBefore();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "backward");
        this.getActionMap().put("backward", this.codePanel.getControlPanel().getBackButton().getAction());
        this.codePanel.getControlPanel().getPlayButton().setAction(new AbstractAction("Play", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_play_48.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.controller.runSimulation();
            }
        });
        this.playPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    AbstractSimulatorPanel.this.codePanel.getControlPanel().getPlayButton().setIcon(new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_pause_48.png")));
                } else {
                    AbstractSimulatorPanel.this.codePanel.getControlPanel().getPlayButton().setIcon(new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_play_48.png")));
                }
            }
        };
        this.codePanel.getControlPanel().getResetButton().setAction(new AbstractAction("Reset", new ImageIcon(AbstractSimulatorPanel.class.getResource("/images/player_stop_48.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AbstractSimulatorPanel.this.controller.isTimerRunning();
                AbstractSimulatorPanel.this.controller.setTimerStart(false);
                int n = JOptionPane.showConfirmDialog(AbstractSimulatorPanel.this.codePanel, "Do you want to start simulation from the beginning?", "Restart Algorithm", 0);
                if (n == 0) {
                    AbstractSimulatorPanel.this.controller.resetController();
                } else {
                    AbstractSimulatorPanel.this.controller.setTimerStart(bl);
                }
            }
        });
        this.codePanel.getControlPanel().getSpeedSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    int n = ControlPanel.getDelayBySliderValue(jSlider.getValue(), jSlider.getMaximum(), jSlider.getMinimum());
                    AbstractSimulatorPanel.this.controller.setDelay(n);
                }
            }
        });
        this.popup = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction("Scroll"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.controller.setScrollEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            }
        });
        jCheckBoxMenuItem.setState(true);
        this.popup.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction("Scroll"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.codePanel.setScrollEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            }
        });
        jCheckBoxMenuItem.setState(true);
        this.popup.add(jCheckBoxMenuItem);
        this.popup.addSeparator();
        jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction("Interactive mode"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.controller.setInteractiveMode(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            }
        });
        jCheckBoxMenuItem.setState(false);
        this.popup.add(jCheckBoxMenuItem);
        this.popup.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Return panels"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSimulatorPanel.this.variablesPanel.dockTables();
            }
        });
        this.popup.add(jMenuItem);
        LayerUI<JComponent> layerUI = new LayerUI<JComponent>(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent, JLayer<? extends JComponent> jLayer) {
                if (aWTEvent instanceof MouseEvent) {
                    switch (aWTEvent.getID()) {
                        case 501: {
                            this.showPopup((MouseEvent)aWTEvent);
                            break;
                        }
                        case 502: {
                            this.showPopup((MouseEvent)aWTEvent);
                        }
                    }
                }
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AbstractSimulatorPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        JLayer<JComponent> jLayer = new JLayer<JComponent>(this.codePanel, layerUI);
        jLayer.setLayerEventMask(16L);
        this.codeAndVariablesPanel = new JSplitPane(0, this.variablesPanel, jLayer);
        this.codeAndVariablesPanel.setContinuousLayout(true);
        this.codeAndVariablesPanel.setResizeWeight(0.2);
        this.codeAndVariablesPanel.setDividerSize(6);
        this.graphPanel = new JPanel(new BorderLayout());
        this.label = this.getAlgorithmLabel();
        this.graphPanel.add((Component)this.label, "North");
        JSplitPane jSplitPane = new JSplitPane(1, this.graphPanel, this.codeAndVariablesPanel);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.8);
        jSplitPane.setDividerSize(6);
        this.add(jSplitPane);
    }

    protected final JLabel getAlgorithmLabel() {
        JLabel jLabel = new JLabel("<html></html>", 0){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                int n = dimension.width < dimension2.width ? dimension2.width : dimension.width;
                int n2 = dimension.height < dimension2.height ? dimension2.height : dimension.height;
                return new Dimension(n, n2);
            }
        };
        Font font = new Font("Serif", 0, 18);
        jLabel.setFont(font);
        jLabel.setPreferredSize(new Dimension(Short.MAX_VALUE, jLabel.getFontMetrics(font).getHeight() * 2 + 10));
        return jLabel;
    }

    public static AlgorithmGraphComponent getmxGraphComponent(AlgorithmGraph algorithmGraph) {
        AlgorithmGraphComponent algorithmGraphComponent = new AlgorithmGraphComponent(algorithmGraph);
        algorithmGraphComponent.getViewport().setBackground(Color.WHITE);
        algorithmGraphComponent.setConnectable(false);
        algorithmGraphComponent.setToolTips(true);
        algorithmGraphComponent.setImportEnabled(false);
        algorithmGraphComponent.setEnterStopsCellEditing(true);
        return algorithmGraphComponent;
    }

    public VisualizationPseudocodePanel getCodePanel() {
        return this.codePanel;
    }

    public AlgorithmGraph getGraph() {
        return this.graph;
    }

    public AbstractAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public VariablesPanel getVariablesPanel() {
        return this.variablesPanel;
    }

    public JSplitPane getCodeAndVariablesPanel() {
        return this.codeAndVariablesPanel;
    }

    public JPanel getGraphPanel() {
        return this.graphPanel;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public PropertyChangeListener getPlayPropertyChangeListener() {
        return this.playPropertyChangeListener;
    }

    public void setController(AbstractController abstractController) {
        this.controller = abstractController;
        abstractController.addTimerPropertyChangeListener(this.playPropertyChangeListener);
        abstractController.setDelay(ControlPanel.getStandardTime());
    }
}

