/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.bellmanford;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simulator.graphs.AbstractGraphCell;
import simulator.graphs.bellmanford.BellmanFordNodeData;
import simulator.graphs.bellmanford.BellmanFordOperations;

public class BellmanFordGraphVertex
extends AbstractGraphCell
implements BellmanFordOperations {
    protected BellmanFordNodeData state = null;

    public BellmanFordGraphVertex() {
        this((String)null);
    }

    public BellmanFordGraphVertex(String string) {
        this(string, false);
    }

    public BellmanFordGraphVertex(String string, Boolean bl) {
        this(string, new BellmanFordNodeData(), bl);
    }

    public BellmanFordGraphVertex(String string, BellmanFordNodeData bellmanFordNodeData, Boolean bl) {
        super(string, bl);
        this.state = bellmanFordNodeData;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled() || this.state.getDistance() == null) {
            return this.getName();
        }
        if (this.state.getDistance() == Double.POSITIVE_INFINITY) {
            return this.getName() + " / \u221e";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(" / ");
        if (this.state.getDistance() != null) {
            stringBuilder.append(new DecimalFormat("#").format(this.state.getDistance()));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.state.setEnabled(bl);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean bl) {
        this.state.setActive(bl);
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean bl) {
        this.state.setToolTipsEnabled(bl);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    @Override
    public void setDistance(Double d) {
        this.state.setDistance(d);
    }

    @Override
    public Double getDistance() {
        return this.state.getDistance();
    }

    @Override
    public BellmanFordGraphVertex getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(BellmanFordGraphVertex bellmanFordGraphVertex) {
        this.state.setNodePath(bellmanFordGraphVertex);
    }

    @Override
    public void edit(String string) {
        if (this.isEditable()) {
            if (string.contains("\u221e") || string.contains("inf")) {
                this.state.setDistance(Double.POSITIVE_INFINITY);
                return;
            }
            Pattern pattern = Pattern.compile("-?\\d+");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                double d = Double.parseDouble(matcher.group());
                this.state.setDistance(d);
            }
        }
    }
}

