/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs;

import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.view.mxGraph;
import editor.GraphIO;
import java.io.IOException;
import java.nio.file.Paths;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.graphs.bellmanford.BellmanFordStylesheet;
import simulator.graphs.bfs.BfsGraphCell;
import simulator.graphs.bfs.BfsStylesheet;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.dfs.DfsStylesheet;
import simulator.graphs.dijkstra.DijkstraStyleSheet;
import simulator.graphs.scc.SccStyleSheet;
import simulator.graphs.toposort.TopologicalSortStylesheet;

public class BasicGraphs {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphDijkstra() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(new BellmanFordGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphScc() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(SccStyleSheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphTopoSort() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphBfs() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(new BfsGraphCell("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphDfs() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        Object object = algorithmGraph.getDefaultParent();
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(object, null, new DfsGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0, "VERTEX_STYLE");
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getOneNodeGraphBellmanFord() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            algorithmGraph.insertVertex(new BellmanFordGraphVertex("A", true), 250.0, 250.0, 80.0, 60.0);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDijkstraGraph2() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new BellmanFordGraphVertex("S", true), 40.0, 175.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("T"), 180.0, 50.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Z"), 520.0, 300.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("X"), 520.0, 50.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Y"), 180.0, 300.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(10.0), object, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(5.0), object, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object2, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(1.0), object2, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(3.0), object5, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object5, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(9.0), object5, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-4.0), object4, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(7.0), object3, object);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-6.0), object3, object4);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        new mxEdgeLabelLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDijkstraGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DijkstraStyleSheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new BellmanFordGraphVertex("S", true), 40.0, 175.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("T"), 180.0, 50.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Z"), 520.0, 300.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("X"), 520.0, 50.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Y"), 180.0, 300.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(10.0), object, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(5.0), object, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object2, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(1.0), object2, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(3.0), object5, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object5, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(9.0), object5, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(4.0), object4, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(7.0), object3, object);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(6.0), object3, object4);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        new mxEdgeLabelLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBellmanFordGraph2() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new BellmanFordGraphVertex("S", true), 80.0, 200.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("T"), 220.0, 50.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Z"), 460.0, 350.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("X"), 460.0, 50.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Y"), 220.0, 430.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(6.0), object, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(7.0), object, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(8.0), object2, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(5.0), object2, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-4.0), object2, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(9.0), object5, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-3.0), object5, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-2.0), object4, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object3, object);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-7.0), object3, object4);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        new mxEdgeLabelLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBellmanFordGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BellmanFordStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new BellmanFordGraphVertex("S", true), 80.0, 200.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("T"), 220.0, 50.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Z"), 460.0, 350.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("X"), 460.0, 50.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new BellmanFordGraphVertex("Y"), 220.0, 350.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(6.0), object, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(7.0), object, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(8.0), object2, object5);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(5.0), object2, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-4.0), object2, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(9.0), object5, object3);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-3.0), object5, object4);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(-2.0), object4, object2);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(2.0), object3, object);
            algorithmGraph.insertEdge(new BellmanFordGraphEdge(7.0), object3, object4);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        new mxEdgeLabelLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getSccGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(SccStyleSheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new DfsGraphVertex("A"), 40.0, 60.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new DfsGraphVertex("B"), 180.0, 60.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new DfsGraphVertex("C"), 320.0, 60.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new DfsGraphVertex("D"), 460.0, 60.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new DfsGraphVertex("E"), 40.0, 200.0, 80.0, 60.0);
            Object object6 = algorithmGraph.insertVertex(new DfsGraphVertex("F"), 180.0, 200.0, 80.0, 60.0);
            Object object7 = algorithmGraph.insertVertex(new DfsGraphVertex("G"), 320.0, 200.0, 80.0, 60.0);
            Object object8 = algorithmGraph.insertVertex(new DfsGraphVertex("H", true), 460.0, 200.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object5);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object3, object4);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object3, object7);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object5, object);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object5, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object6, object7);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object8, object8);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getTopologicalSortGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new DfsGraphVertex("shirt", true), 180.0, 280.0, 80.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new DfsGraphVertex("tie"), 180.0, 400.0, 80.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new DfsGraphVertex("jacket"), 180.0, 520.0, 80.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new DfsGraphVertex("belt"), 60.0, 360.0, 80.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new DfsGraphVertex("watch"), 360.0, 130.0, 80.0, 60.0);
            Object object6 = algorithmGraph.insertVertex(new DfsGraphVertex("underwear"), 60.0, 60.0, 80.0, 60.0);
            Object object7 = algorithmGraph.insertVertex(new DfsGraphVertex("trousers"), 60.0, 200.0, 80.0, 60.0);
            Object object8 = algorithmGraph.insertVertex(new DfsGraphVertex("shoes"), 260.0, 200.0, 80.0, 60.0);
            Object object9 = algorithmGraph.insertVertex(new DfsGraphVertex("socks"), 260.0, 60.0, 80.0, 60.0);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object6, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object6, object7);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object9, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object4);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object4);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object3);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDfsGraph2() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new DfsGraphVertex("A"), 40.0, 60.0, 60.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new DfsGraphVertex("B"), 180.0, 60.0, 60.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new DfsGraphVertex("C"), 320.0, 60.0, 60.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new DfsGraphVertex("D"), 460.0, 60.0, 60.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new DfsGraphVertex("E"), 40.0, 200.0, 60.0, 60.0);
            Object object6 = algorithmGraph.insertVertex(new DfsGraphVertex("F"), 180.0, 200.0, 60.0, 60.0);
            Object object7 = algorithmGraph.insertVertex(new DfsGraphVertex("G"), 320.0, 200.0, 60.0, 60.0);
            Object object8 = algorithmGraph.insertVertex(new DfsGraphVertex("H"), 460.0, 200.0, 60.0, 60.0);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object5);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object3, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object3, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object7);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object8);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object5, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object6, object5);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object7, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object8, object7);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object8, object4);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        new mxParallelEdgeLayout((mxGraph)algorithmGraph).execute(algorithmGraph.getDefaultParent());
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getDfsGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(DfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            DfsGraphVertex dfsGraphVertex = new DfsGraphVertex("A");
            Object object = algorithmGraph.insertVertex(dfsGraphVertex, 60.0, 60.0, 60.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new DfsGraphVertex("B"), 220.0, 60.0, 60.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new DfsGraphVertex("C"), 220.0, 220.0, 60.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new DfsGraphVertex("D"), 60.0, 220.0, 60.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new DfsGraphVertex("E"), 380.0, 60.0, 60.0, 60.0);
            Object object6 = algorithmGraph.insertVertex(new DfsGraphVertex("F"), 380.0, 220.0, 60.0, 60.0);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object, object4);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object3, object4);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object4, object2);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object2, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object5, object3);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object5, object6);
            algorithmGraph.insertEdge(new DfsGraphEdge(), object6, object6);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBfsGraph2() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(true);
        algorithmGraph.getModel().beginUpdate();
        try {
            Object object = algorithmGraph.insertVertex(new BfsGraphCell("1"), 130.0, 130.0, 60.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BfsGraphCell("a"), 20.0, 20.0, 40.0, 40.0);
            Object object3 = algorithmGraph.insertVertex(new BfsGraphCell("b"), 200.0, 60.0, 40.0, 40.0);
            Object object4 = algorithmGraph.insertVertex(new BfsGraphCell("c"), 240.0, 240.0, 40.0, 40.0);
            Object object5 = algorithmGraph.insertVertex(new BfsGraphCell("d"), 10.0, 200.0, 40.0, 40.0);
            Object object6 = algorithmGraph.insertVertex(new BfsGraphCell("e"), 120.0, 260.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object2, object);
            algorithmGraph.insertEdge(null, object3, object);
            algorithmGraph.insertEdge(null, object4, object);
            algorithmGraph.insertEdge(null, object5, object);
            algorithmGraph.insertEdge(null, object6, object);
            Object object7 = algorithmGraph.insertVertex(new BfsGraphCell("2"), 320.0, 130.0, 60.0, 60.0);
            Object object8 = algorithmGraph.insertVertex(new BfsGraphCell("q"), 320.0, 10.0, 40.0, 40.0);
            Object object9 = algorithmGraph.insertVertex(new BfsGraphCell("r"), 440.0, 80.0, 40.0, 40.0);
            Object object10 = algorithmGraph.insertVertex(new BfsGraphCell("h"), 400.0, 240.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object4, object7);
            algorithmGraph.insertEdge(null, object10, object7);
            algorithmGraph.insertEdge(null, object8, object7);
            algorithmGraph.insertEdge(null, object9, object7);
            Object object11 = algorithmGraph.insertVertex(new BfsGraphCell("3"), 510.0, 130.0, 60.0, 60.0);
            Object object12 = algorithmGraph.insertVertex(new BfsGraphCell("p"), 600.0, 90.0, 40.0, 40.0);
            Object object13 = algorithmGraph.insertVertex(new BfsGraphCell("o"), 590.0, 240.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object10, object11);
            algorithmGraph.insertEdge(null, object12, object11);
            algorithmGraph.insertEdge(null, object13, object11);
            Object object14 = algorithmGraph.insertVertex(new BfsGraphCell("4"), 130.0, 360.0, 60.0, 60.0);
            Object object15 = algorithmGraph.insertVertex(new BfsGraphCell("f"), 80.0, 440.0, 40.0, 40.0);
            Object object16 = algorithmGraph.insertVertex(new BfsGraphCell("g"), 260.0, 450.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object6, object14);
            algorithmGraph.insertEdge(null, object15, object14);
            algorithmGraph.insertEdge(null, object16, object14);
            BfsGraphCell bfsGraphCell = new BfsGraphCell("5");
            bfsGraphCell.setSelected(true);
            Object object17 = algorithmGraph.insertVertex(bfsGraphCell, 320.0, 360.0, 60.0, 60.0);
            Object object18 = algorithmGraph.insertVertex(new BfsGraphCell("i"), 380.0, 480.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object4, object17);
            algorithmGraph.insertEdge(null, object16, object17);
            algorithmGraph.insertEdge(null, object18, object17);
            Object object19 = algorithmGraph.insertVertex(new BfsGraphCell("6"), 510.0, 360.0, 60.0, 60.0);
            Object object20 = algorithmGraph.insertVertex(new BfsGraphCell("n"), 450.0, 420.0, 40.0, 40.0);
            Object object21 = algorithmGraph.insertVertex(new BfsGraphCell("m"), 620.0, 400.0, 40.0, 40.0);
            Object object22 = algorithmGraph.insertVertex(new BfsGraphCell("k"), 550.0, 490.0, 40.0, 40.0);
            algorithmGraph.insertEdge(null, object13, object19);
            algorithmGraph.insertEdge(null, object20, object19);
            algorithmGraph.insertEdge(null, object21, object19);
            algorithmGraph.insertEdge(null, object22, object19);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgorithmGraph getBfsGraph() {
        AlgorithmGraph algorithmGraph = new AlgorithmGraph(BfsStylesheet.getStylesheet());
        algorithmGraph.setOriented(false);
        algorithmGraph.getModel().beginUpdate();
        try {
            BfsGraphCell bfsGraphCell = new BfsGraphCell("s");
            bfsGraphCell.setSelected(true);
            Object object = algorithmGraph.insertVertex(bfsGraphCell, 200.0, 120.0, 60.0, 60.0);
            Object object2 = algorithmGraph.insertVertex(new BfsGraphCell("r"), 40.0, 60.0, 60.0, 60.0);
            Object object3 = algorithmGraph.insertVertex(new BfsGraphCell("v"), 40.0, 300.0, 60.0, 60.0);
            Object object4 = algorithmGraph.insertVertex(new BfsGraphCell("t"), 350.0, 40.0, 60.0, 60.0);
            Object object5 = algorithmGraph.insertVertex(new BfsGraphCell("x"), 350.0, 300.0, 60.0, 60.0);
            Object object6 = algorithmGraph.insertVertex(new BfsGraphCell("w"), 200.0, 400.0, 60.0, 60.0);
            Object object7 = algorithmGraph.insertVertex(new BfsGraphCell("u"), 460.0, 160.0, 60.0, 60.0);
            Object object8 = algorithmGraph.insertVertex(new BfsGraphCell("z"), 460.0, 380.0, 60.0, 60.0);
            algorithmGraph.insertEdge(null, object, object2);
            algorithmGraph.insertEdge(null, object2, object3);
            algorithmGraph.insertEdge(null, object, object6);
            algorithmGraph.insertEdge(null, object6, object4);
            algorithmGraph.insertEdge(null, object6, object5);
            algorithmGraph.insertEdge(null, object5, object4);
            algorithmGraph.insertEdge(null, object5, object7);
            algorithmGraph.insertEdge(null, object5, object8);
            algorithmGraph.insertEdge(null, object7, object4);
            algorithmGraph.insertEdge(null, object7, object8);
        }
        finally {
            algorithmGraph.getModel().endUpdate();
        }
        return algorithmGraph;
    }

    public static void main(String[] stringArray) throws IOException {
        GraphIO.writeGraph(BasicGraphs.getBfsGraph(), Paths.get(System.getProperty("user.dir"), "BfsGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getBfsGraph2(), Paths.get(System.getProperty("user.dir"), "BfsGraph2.xml"));
        GraphIO.writeGraph(BasicGraphs.getDfsGraph(), Paths.get(System.getProperty("user.dir"), "DfsGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDfsGraph2(), Paths.get(System.getProperty("user.dir"), "DfsGraph2.xml"));
        GraphIO.writeGraph(BasicGraphs.getTopologicalSortGraph(), Paths.get(System.getProperty("user.dir"), "TopologicalSortGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getSccGraph(), Paths.get(System.getProperty("user.dir"), "SccGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getBellmanFordGraph(), Paths.get(System.getProperty("user.dir"), "BellmanFordGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDijkstraGraph(), Paths.get(System.getProperty("user.dir"), "DijkstraGraph1.xml"));
        GraphIO.writeGraph(BasicGraphs.getDijkstraGraph2(), Paths.get(System.getProperty("user.dir"), "DijkstraGraph2.xml"));
    }
}

