/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Deque;
import java.util.LinkedList;
import simulator.controllers.SimulatorMouseAdapter;
import simulator.graphs.AlgorithmGraph;

public class SelectCellsMouseAdapter
extends SimulatorMouseAdapter {
    public static final String PROPERTY_SELECTED_NODES = "selectedNodes";
    protected int maxSelected;
    protected mxGraphComponent graphComponent;
    protected AlgorithmGraph graph;
    protected Deque<mxCell> selectedCells;
    protected boolean vertices;
    protected boolean edges;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SelectCellsMouseAdapter(mxGraphComponent mxGraphComponent2, AlgorithmGraph algorithmGraph) {
        this(mxGraphComponent2, algorithmGraph, true, false);
    }

    public SelectCellsMouseAdapter(int n, mxGraphComponent mxGraphComponent2, AlgorithmGraph algorithmGraph) {
        this(n, mxGraphComponent2, algorithmGraph, true, false);
    }

    public SelectCellsMouseAdapter(mxGraphComponent mxGraphComponent2, AlgorithmGraph algorithmGraph, boolean bl, boolean bl2) {
        this(algorithmGraph.getChildCells(algorithmGraph.getDefaultParent(), true, false).length, mxGraphComponent2, algorithmGraph, bl, bl2);
    }

    public SelectCellsMouseAdapter(int n, mxGraphComponent mxGraphComponent2, AlgorithmGraph algorithmGraph, boolean bl, boolean bl2) {
        this.vertices = bl;
        this.edges = bl2;
        this.maxSelected = n;
        this.graphComponent = mxGraphComponent2;
        this.graph = algorithmGraph;
        this.selectedCells = new LinkedList<mxCell>();
    }

    public mxCell getLastSelected() {
        return this.selectedCells.peekLast();
    }

    public Deque<mxCell> getSelectedNodes() {
        return this.selectedCells;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void reset() {
        super.reset();
        this.selectedCells.clear();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mxCell mxCell2;
        if (this.activated && (mxCell2 = (mxCell)this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY())) != null && (mxCell2.isVertex() && this.vertices || mxCell2.isEdge() && this.edges)) {
            if (this.selectedCells.contains(mxCell2)) {
                mxCell2.setStyle((String)this.oldStyles.get(mxCell2));
                this.oldStyles.remove(mxCell2);
                this.selectedCells.remove(mxCell2);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_NODES, null, this.selectedCells);
            } else {
                if (this.selectedCells.size() == this.maxSelected) {
                    mxCell mxCell3 = this.selectedCells.removeFirst();
                    mxCell3.setStyle((String)this.oldStyles.get(mxCell3));
                    this.oldStyles.remove(mxCell3);
                }
                this.selectedCells.add(mxCell2);
                this.oldStyles.put(mxCell2, mxCell2.getStyle());
                if (!this.vertices || !this.edges) {
                    mxCell2.setStyle(this.graph.getAlgorithmStylesheet().getSelectedStyle(this.edges));
                }
                this.propertyChangeSupport.firePropertyChange(PROPERTY_SELECTED_NODES, null, this.selectedCells);
            }
            this.graphComponent.getGraph().getSelectionModel().clear();
            this.graphComponent.refresh();
        }
    }
}

