/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

public class ControllerTimer
extends Timer {
    boolean enable = true;
    boolean wasRunning = false;
    public static final String PROP_TIMER_RUNNING = "timerRunning";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ControllerTimer(int n, ActionListener actionListener) {
        super(n, actionListener);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.enable) {
            return;
        }
        this.enable = bl;
        if (!this.enable) {
            this.wasRunning = this.isRunning();
            if (this.wasRunning) {
                this.stop();
            }
        } else if (this.wasRunning) {
            this.start();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void stop() {
        boolean bl = this.isRunning();
        this.wasRunning = false;
        super.stop();
        this.propertyChangeSupport.firePropertyChange(PROP_TIMER_RUNNING, bl, false);
    }

    @Override
    public void start() {
        this.wasRunning = true;
        if (this.enable) {
            boolean bl = this.isRunning();
            super.start();
            this.propertyChangeSupport.firePropertyChange(PROP_TIMER_RUNNING, bl, true);
        }
    }
}

