/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.bfs.BfsGraphCell;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class BfsController
extends AbstractController {
    protected Deque<mxCell> queue = new LinkedList<mxCell>();
    protected Deque<mxCell> vertexList = new LinkedList<mxCell>();
    protected Deque<mxCell> userQueue;
    protected Integer variableS = 0;
    protected Integer variableV = 1;
    protected Integer variableU = 2;

    public BfsController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
        this.resetControllerImpl();
        this.interactiveMode = false;
        this.tape.add(new AbstractController.SelectStartNodeInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialize all node except initial node"));
        this.tape.add(new InitInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Q", false));
        AbstractController.LabelInstruction labelInstruction = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction2 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction);
        this.tape.add(new AbstractController.SetCursorInstruction(2));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 22, Color.GREEN));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return BfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(3));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(4));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(5));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new SetVertexInfinityInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(6));
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction2);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Itera\u010dn\u00ed seznam", false));
        this.tape.add(new AbstractController.SetCursorInstruction(7));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 6, this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialize initial node"));
        this.tape.add(new AbstractController.PauseInstruction().setBigPause(true));
        this.tape.add(new AbstractController.SetCursorInstruction(8));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableS));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 7, this.doneColor));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(9));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new SetDistanceInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 8, this.doneColor));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(10));
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new SetPathInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 9, this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of the queue Q"));
        this.tape.add(new AbstractController.PauseInstruction().setBigPause(true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Q", true));
        this.tape.add(new AbstractController.SetCursorInstruction(11));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.queue));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 10, this.doneColor));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.EnqueueInstruction(this.queue));
        AbstractController.LabelInstruction labelInstruction3 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction4 = new AbstractController.LabelInstruction(labelInstruction3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BfsController.this.queue.isEmpty();
            }
        });
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction4, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return BfsController.this.queue.isEmpty();
            }
        }));
        this.tape.add(labelInstruction3);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Processing of the next node in queue"));
        this.tape.add(new AbstractController.SetCursorInstruction(12));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 11, this.doneColor));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Select the first node from queue"));
        this.tape.add(new AbstractController.SetCursorInstruction(13));
        this.tape.add(new SelectNextDequeNodeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.DequeueInstruction(this.queue));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", true));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getDoneVertexStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(14));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, this.graph.isOriented()));
        this.tape.add(new SelectNodesToQNodeInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Itera\u010dn\u00ed seznam", true));
        AbstractController.LabelInstruction labelInstruction5 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction6 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction5);
        this.tape.add(new AbstractController.SetCursorInstruction(14));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in progress"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return BfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetCursorInstruction(15));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited\nadjust color, distance, path and put it in the queue"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(16));
        AbstractController.LabelInstruction labelInstruction7 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction7, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)BfsController.this.activeVariable).getStyle().equals(BfsController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), this.graph.isOriented()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(17));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(18));
        this.tape.add(new SetVertexInfinityInstruction());
        this.tape.add(new SetDistanceInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(19));
        this.tape.add(new SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.EnqueueInstruction(this.queue));
        this.tape.add(labelInstruction7);
        this.tape.add(new AbstractController.SetCursorInstruction(20));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(21));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction6);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Itera\u010dn\u00ed seznam", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.SetCursorInstruction(22));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(labelInstruction4);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(2, 22, this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(22));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Algorithm BFS is completed"));
        this.tape.add(new AbstractController.EndInstruction());
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("BFS algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("s", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BfsController.this.getNodeName(BfsController.this.getRegisterValue(BfsController.this.variableS));
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BfsController.this.getNodeName(BfsController.this.getRegisterValue(BfsController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BfsController.this.getNodeName(BfsController.this.getRegisterValue(BfsController.this.variableV));
            }
        });
        this.variables.put("Q", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(BfsController.this.queue);
            }
        });
        this.variables.put("Itera\u010dn\u00ed seznam", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(BfsController.this.vertexList);
            }
        });
        this.variables.put("UserQueue", new VariableObject(false){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(BfsController.this.userQueue);
            }
        });
        for (Map.Entry entry : this.variables.entrySet()) {
            if (!((VariableObject)entry.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)entry.getKey());
        }
        this.queue.clear();
        this.vertexList.clear();
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected int getDistance(Object object, Object object2) {
        if (object2 instanceof mxCell) {
            return ((BfsGraphCell)((mxCell)object2).getValue()).getIntValue() + 1;
        }
        return 0;
    }

    protected final class SetDistanceEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BfsGraphCell graphNode;
        protected Integer newValue;
        protected Integer oldValue;

        public SetDistanceEdit(mxCell mxCell2, Integer n) {
            this.graphNode = (BfsGraphCell)mxCell2.getValue();
            this.newValue = n;
            this.oldValue = this.graphNode.getIntValue();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setIntValue(this.oldValue);
        }

        @Override
        protected void action() {
            this.graphNode.setIntValue(this.newValue);
        }
    }

    protected final class SetPathEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BfsGraphCell graphNode;
        protected BfsGraphCell newPath;
        protected BfsGraphCell oldPath;

        public SetPathEdit(mxCell mxCell2, mxCell mxCell3) {
            this.graphNode = (BfsGraphCell)mxCell2.getValue();
            this.oldPath = this.graphNode.getNodePath();
            this.newPath = mxCell3 != null ? (BfsGraphCell)mxCell3.getValue() : null;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setNodePath(this.oldPath);
        }

        @Override
        protected void action() {
            this.graphNode.setNodePath(this.newPath);
        }
    }

    protected final class SetInfinityEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BfsGraphCell graphNode;
        protected boolean infinity;

        public SetInfinityEdit(mxCell mxCell2) {
            this.graphNode = (BfsGraphCell)mxCell2.getValue();
            this.infinity = this.graphNode.isInfinity();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setInfinity(this.infinity);
        }

        @Override
        protected void action() {
            this.graphNode.setInfinity(!this.infinity);
        }
    }

    protected class SetDistanceInstruction
    extends AbstractController.BasicInstruction {
        protected boolean zero = false;
        protected int regIndex;

        public SetDistanceInstruction() {
            this.zero = true;
        }

        public SetDistanceInstruction(int n) {
            this.zero = false;
            this.regIndex = n;
        }

        @Override
        public void preform() {
            if (this.zero) {
                BfsController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)BfsController.this.activeVariable, 0));
            } else {
                int n = BfsController.this.getDistance(BfsController.this.activeVariable, BfsController.this.getRegisterValue(this.regIndex));
                BfsController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)BfsController.this.activeVariable, n));
            }
        }
    }

    protected class SetPathInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regNum = null;

        public SetPathInstruction() {
        }

        public SetPathInstruction(int n) {
            this.regNum = n;
        }

        @Override
        public void preform() {
            if (this.regNum != null) {
                BfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)BfsController.this.activeVariable, (mxCell)BfsController.this.getRegisterValue(this.regNum)));
            } else {
                BfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)BfsController.this.activeVariable, null));
            }
        }
    }

    protected class ColorActiveEdgesInstruction
    extends AbstractController.BasicInstruction {
        protected String newStyle;

        public ColorActiveEdgesInstruction(String string) {
            this.newStyle = string;
        }

        @Override
        public void preform() {
            for (int i = 0; i < BfsController.this.graph.getModel().getEdgeCount(BfsController.this.activeVariable); ++i) {
                mxCell mxCell2 = (mxCell)BfsController.this.graph.getModel().getEdgeAt(BfsController.this.activeVariable, i);
                BfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(mxCell2, this.newStyle));
            }
        }
    }

    protected class SetVertexInfinityInstruction
    extends AbstractController.BasicInstruction {
        protected SetVertexInfinityInstruction() {
        }

        @Override
        public void preform() {
            BfsController.this.editBlock.addEdit(new SetInfinityEdit((mxCell)BfsController.this.activeVariable));
        }
    }

    protected class InitInstruction
    extends AbstractController.BasicInstruction {
        protected boolean selectedFound = false;

        protected InitInstruction() {
        }

        @Override
        public void preform() {
            Object[] objectArray;
            BfsController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (!graphCell.isSelected().booleanValue()) {
                        BfsController.this.vertexList.add(mxCell2);
                    } else {
                        InitInstruction.this.selectedFound = true;
                        BfsController.this.editBlock.addEdit(new AbstractController.SetColorEdit(BfsController.this.stylesheet.getSelectedVertexStyle(), mxCell2));
                        BfsController.this.setRegisterValue(mxCell2, BfsController.this.variableS);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return false;
                }
            });
            if (!this.selectedFound && (objectArray = BfsController.this.graph.getChildVertices(BfsController.this.graph.getDefaultParent())).length > 0) {
                mxCell mxCell2 = (mxCell)objectArray[0];
                BfsController.this.vertexList.remove(mxCell2);
                ((GraphCell)mxCell2.getValue()).setSelected(true);
                BfsController.this.editBlock.addEdit(new AbstractController.SetColorEdit(BfsController.this.stylesheet.getSelectedVertexStyle(), mxCell2));
                BfsController.this.setRegisterValue(mxCell2, BfsController.this.variableS);
            }
        }
    }

    protected class SelectNextDequeNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectNextDequeNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, BfsController.this.graphComponent, BfsController.this.graph);
            this.adapter.setActivated(false);
            BfsController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            BfsController.this.graphComponentLabel.setText(BfsController.this.getTextForLabel("Select node to be taken from a queue and click continue\n[u\u017eivatelsk\u00e1 akce]"));
            if (!this.adapter.isActivated()) {
                BfsController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                if (BfsController.this.queue.peekFirst().equals(this.adapter.getLastSelected())) {
                    this.stop();
                    return;
                }
                BfsController.this.graphComponentLabel.setText(BfsController.this.getTextForLabel("Incorrectly selected node\n[u\u017eivatelsk\u00e1 akce]"));
            }
            BfsController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return BfsController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.reset();
                BfsController.this.timer.setEnabled(true);
            }
        }
    }

    protected class SelectNodesToQNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected Deque<mxCell> expectedQueue = new LinkedList<mxCell>();

        public SelectNodesToQNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(BfsController.this.graphComponent, BfsController.this.graph);
            this.adapter.setActivated(false);
            this.adapter.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BfsController.this.userQueue = SelectNodesToQNodeInstruction.this.adapter.getSelectedNodes();
                    BfsController.this.variablesPanel.addVariable("UserQueue", ((VariableObject)BfsController.this.variables.get("UserQueue")).toString());
                }
            });
            BfsController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        protected void MakeExpectedQueue() {
            this.expectedQueue.clear();
            for (mxCell mxCell2 : BfsController.this.vertexList) {
                if (!mxCell2.getStyle().equals(BfsController.this.stylesheet.getInitVertexStyle())) continue;
                this.expectedQueue.add(mxCell2);
            }
        }

        protected boolean isSelectedCorrect(Deque<mxCell> deque) {
            if (deque.size() != this.expectedQueue.size()) {
                return false;
            }
            for (mxCell mxCell2 : this.expectedQueue) {
                if (deque.contains(mxCell2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void preform() {
            BfsController.this.graphComponentLabel.setText(BfsController.this.getTextForLabel("Select all nodes to insert in a queue and click continue\n[u\u017eivatelsk\u00e1 akce]"));
            if (!this.adapter.isActivated()) {
                BfsController.this.timer.setEnabled(false);
                this.MakeExpectedQueue();
                this.adapter.setActivated(true);
                ((VariableObject)BfsController.this.variables.get("UserQueue")).setEnabled(true);
            } else {
                if (this.isSelectedCorrect(this.adapter.getSelectedNodes())) {
                    BfsController.this.vertexList.removeAll(this.adapter.getSelectedNodes());
                    BfsController.this.vertexList.addAll(this.adapter.getSelectedNodes());
                    this.stop();
                    return;
                }
                BfsController.this.graphComponentLabel.setText(BfsController.this.getTextForLabel("Incorrectly selected nodes\n[u\u017eivatelsk\u00e1 akce]"));
            }
            BfsController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return BfsController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                BfsController.this.timer.setEnabled(true);
            }
        }
    }
}

