/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.util.mxResources;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.logging.log4j.LogManager;
import program.AboutDialog;
import program.MainPanel;
import program.ManualDialog;
import program.MenuBar;
import program.ToolBar;

public final class Program
extends JFrame {
    public static final String FULLSCREEN_PROPERTY = "Fullscreen";
    public static final String MAXIMIZE_PROPERTY = "Maximize";
    private static org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)Program.class.getName());
    protected ToolBar toolBar;
    protected MenuBar menuBar;
    protected boolean fullscreen = false;
    protected DisplayMode dispModeOld;
    protected boolean maximize = false;

    public void about() {
        logger.entry();
        if (this.fullscreen) {
            return;
        }
        AboutDialog aboutDialog = new AboutDialog((Frame)this, true);
        int n = this.getX() + (this.getWidth() - aboutDialog.getWidth()) / 2;
        int n2 = this.getY() + (this.getHeight() - aboutDialog.getHeight()) / 2;
        aboutDialog.setLocation(n, n2);
        aboutDialog.setVisible(true);
        logger.exit();
    }

    public void manual() {
        ManualDialog manualDialog = new ManualDialog((Frame)this, true);
        int n = this.getX() + (this.getWidth() - manualDialog.getWidth()) / 2;
        int n2 = this.getY() + (this.getHeight() - manualDialog.getHeight()) / 2;
        manualDialog.setLocation(n, n2);
        manualDialog.setVisible(true);
    }

    public void showOrHideLabels() {
        logger.entry();
        this.toolBar.showOrHideLabels();
        logger.exit();
    }

    public void setFullscreen(boolean bl) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        this.dispModeOld = graphicsDevice.getDisplayMode();
        if (this.fullscreen != bl) {
            this.fullscreen = bl;
            if (!bl) {
                graphicsDevice.setDisplayMode(this.dispModeOld);
                this.setVisible(false);
                this.dispose();
                this.setUndecorated(false);
                graphicsDevice.setFullScreenWindow(null);
                this.setLocationRelativeTo(null);
                this.setResizable(true);
                this.setVisible(true);
            } else {
                this.setVisible(false);
                this.dispose();
                this.setUndecorated(true);
                graphicsDevice.setFullScreenWindow(this);
                graphicsDevice.setDisplayMode(displayMode);
                this.setResizable(false);
                this.setAlwaysOnTop(false);
                this.setVisible(true);
            }
            this.repaint();
            this.firePropertyChange(FULLSCREEN_PROPERTY, !this.fullscreen, this.fullscreen);
        }
    }

    public void setMaximize(boolean bl) {
        this.setFullscreen(false);
        if (this.maximize != bl) {
            this.maximize = bl;
            if (this.maximize) {
                this.setExtendedState(6);
            } else {
                this.setExtendedState(0);
            }
            this.firePropertyChange(MAXIMIZE_PROPERTY, !this.maximize, this.maximize);
        }
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    private static void createAndShowGUI() {
        Program program = new Program();
        program.setTitle(mxResources.get((String)"mainTitle"));
        MainPanel mainPanel = new MainPanel();
        program.toolBar = new ToolBar(mainPanel, 0);
        program.menuBar = new MenuBar(mainPanel);
        program.addPropertyChangeListener(program.menuBar);
        mainPanel.getEditorUndoManager().addListener(null, program.toolBar);
        mainPanel.getEditorUndoManager().addListener(null, program.menuBar);
        program.setJMenuBar(program.menuBar);
        program.add((Component)program.toolBar, "North");
        JPanel jPanel = new JPanel();
        program.add((Component)jPanel, "South");
        program.getContentPane().add(mainPanel);
        mainPanel.updateTitle();
        program.setDefaultCloseOperation(3);
        program.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        program.setSize(1024, 768);
        program.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, exception);
        }
        UIManager.put("OptionPane.cancelButtonText", "Cancel");
        UIManager.put("OptionPane.noButtonText", "No");
        UIManager.put("OptionPane.okButtonText", "Ok");
        UIManager.put("OptionPane.yesButtonText", "Yes");
        JFrame.setDefaultLookAndFeelDecorated(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Program.createAndShowGUI();
            }
        });
    }

    static {
        mxResources.add((String)"resources/english_language");
    }
}

