/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import editor.EditorGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;

public class GraphViewPanel
extends JPanel {
    protected mxGraphComponent graphComponent;
    protected double vertexWidth = 80.0;
    protected double vertexHeight = 80.0;
    protected EditorGraph graph;
    private int last = 0;
    private char c = (char)65;

    public GraphViewPanel() {
        this.setLayout(new GridLayout(1, 0));
        this.graph = new EditorGraph(BasicStylesheet.getStyleDefaultsheet()){

            private void duplicityNameCheckError() {
                JOptionPane.showMessageDialog((Component)GraphViewPanel.this.graphComponent, mxResources.get((String)"badVertexNameError"), mxResources.get((String)"error"), 0);
            }

            private boolean duplicityNameCheck(Object object, Object object2) {
                return !this.containCellName((String)object2, (mxCell)object);
            }

            public void cellLabelChangedImp(Object object, Object object2, boolean bl) {
                super.cellLabelChanged(object, object2, bl);
                this.refresh();
            }

            @Override
            public void cellLabelChanged(Object object, Object object2, boolean bl) {
                if (this.vertexLabel && ((mxCell)object).isVertex() && ((String)object2).length() == 0) {
                    JOptionPane.showMessageDialog((Component)GraphViewPanel.this.graphComponent, mxResources.get((String)"NewNodeNameError"), mxResources.get((String)"error"), 0);
                    return;
                }
                if (this.duplicityNameCheck(object, object2)) {
                    this.cellLabelChangedImp(object, object2, bl);
                } else {
                    this.duplicityNameCheckError();
                }
            }

            public Object createVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4, String string2, boolean bl) {
                if (object2 == null) {
                    GraphVertexData graphVertexData = new GraphVertexData();
                    Object object3 = super.createVertex(object, string, (Object)graphVertexData, d, d2, d3, d4, "VERTEX_STYLE", bl);
                    this.setNewName(object3);
                    return object3;
                }
                if (this.duplicityNameCheck(null, object2)) {
                    GraphVertexData graphVertexData = new GraphVertexData();
                    graphVertexData.setName((String)object2);
                    return super.createVertex(object, string, (Object)graphVertexData, d, d2, d3, d4, "VERTEX_STYLE", bl);
                }
                this.duplicityNameCheckError();
                return null;
            }

            public Object createEdge(Object object, String string, Object object2, Object object3, Object object4, String string2) {
                return super.createEdge(object, string, (Object)new GraphEdgeData(), object3, object4, "EDGE_STYLE");
            }

            private String getNextName() {
                String string;
                do {
                    string = Character.toString(GraphViewPanel.this.c);
                    if (GraphViewPanel.this.last != 0) {
                        string = string + GraphViewPanel.this.last;
                    }
                    if (GraphViewPanel.this.c == 'Z') {
                        GraphViewPanel.this.c = 'A';
                        GraphViewPanel.this.last++;
                        continue;
                    }
                    GraphViewPanel.access$008(GraphViewPanel.this);
                } while (!this.duplicityNameCheck(null, string));
                return string;
            }

            private void setNewName(Object object) {
                GraphVertexData graphVertexData = (GraphVertexData)((mxCell)object).getValue();
                graphVertexData.setSelected(false);
                graphVertexData.setName(this.getNextName());
            }

            public Object[] moveCells(Object[] objectArray, double d, double d2, boolean bl, Object object, Point point) {
                Object[] objectArray2 = super.moveCells(objectArray, d, d2, bl, object, point);
                if (bl) {
                    for (Object object2 : objectArray2) {
                        if (!((mxCell)object2).isVertex()) continue;
                        ((mxCell)object2).setStyle("VERTEX_STYLE");
                        this.setNewName(object2);
                    }
                    this.refresh();
                }
                return objectArray2;
            }
        };
        this.graphComponent = new mxGraphComponent((mxGraph)this.graph);
        this.graphComponent.setToolTips(true);
        this.graphComponent.setEnterStopsCellEditing(true);
        this.graphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                GraphViewPanel.this.zoomByMouseWheel(mouseWheelEvent, GraphViewPanel.this.graphComponent);
            }
        });
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger() && mouseEvent.isAltDown()) {
                    GraphViewPanel.this.addNewNodeByMouse(mouseEvent, GraphViewPanel.this.graphComponent);
                }
            }
        });
        mxRubberband mxRubberband2 = new mxRubberband(this.graphComponent);
        this.graphComponent.getViewport().setBackground(Color.WHITE);
        this.graphComponent.setBackground(Color.WHITE);
        this.add((Component)this.graphComponent);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public EditorGraph getGraph() {
        return this.graph;
    }

    public void clearGraph() {
        this.graph.removeCells(this.graph.getChildCells(this.graph.getDefaultParent()), true);
        this.resetNewNodesNames();
    }

    public void resetNewNodesNames() {
        this.last = 0;
        this.c = (char)65;
    }

    public void setGraph(mxGraph mxGraph2) {
        if (mxGraph2 == null) {
            this.clearGraph();
            return;
        }
        mxGraph mxGraph3 = this.graphComponent.getGraph();
        mxGraph3.getModel().beginUpdate();
        mxGraph3.setStylesheet(mxGraph2.getStylesheet());
        mxGraph3.removeCells(mxGraph3.getChildCells(mxGraph3.getDefaultParent()), true);
        mxGraph3.addCells(mxGraph2.cloneCells(mxGraph2.getChildCells(mxGraph2.getDefaultParent())));
        for (Object object : mxGraph3.getChildVertices(mxGraph3.getDefaultParent())) {
            mxCell mxCell2 = (mxCell)object;
            GraphVertexData graphVertexData = (GraphVertexData)mxCell2.getValue();
            if (!graphVertexData.isSelected().booleanValue()) continue;
            mxGraph3.getModel().setStyle((Object)mxCell2, "SELECTED_VERTEX_STYLE");
        }
        mxGraph3.getModel().endUpdate();
        this.resetNewNodesNames();
    }

    public mxGraphOutline getGraphOutline() {
        mxGraphOutline mxGraphOutline2 = new mxGraphOutline(this.graphComponent);
        mxGraphOutline2.setAntiAlias(true);
        mxGraphOutline2.setDrawLabels(true);
        mxGraphOutline2.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                GraphViewPanel.this.zoomByMouseWheel(mouseWheelEvent, GraphViewPanel.this.graphComponent);
            }
        });
        return mxGraphOutline2;
    }

    protected void zoomByMouseWheel(MouseWheelEvent mouseWheelEvent, mxGraphComponent mxGraphComponent2) {
        if (mouseWheelEvent.isControlDown()) {
            if (mouseWheelEvent.getWheelRotation() < 0) {
                mxGraphComponent2.zoomIn();
            } else {
                mxGraphComponent2.zoomOut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewNodeByMouse(MouseEvent mouseEvent, mxGraphComponent mxGraphComponent2) {
        double d = mxGraphComponent2.getGraph().getView().getScale();
        double d2 = (double)mouseEvent.getX() / d;
        double d3 = (double)mouseEvent.getY() / d;
        d2 = d2 - this.vertexWidth / 2.0 < 0.0 ? 0.0 : (d2 -= this.vertexWidth / 2.0);
        d3 = d3 - this.vertexHeight / 2.0 < 0.0 ? 0.0 : (d3 -= this.vertexHeight / 2.0);
        Object var9_6 = null;
        mxGraphComponent2.getGraph().getModel().beginUpdate();
        try {
            mxGraphComponent2.getGraph().insertVertex(mxGraphComponent2.getGraph().getDefaultParent(), null, var9_6, d2, d3, this.vertexWidth, this.vertexHeight);
        }
        finally {
            mxGraphComponent2.getGraph().getModel().endUpdate();
        }
    }

    public void doParallelEdgeLayout() {
        new mxParallelEdgeLayout(this.graphComponent.getGraph()).execute(this.graphComponent.getGraph().getDefaultParent());
        this.graphComponent.getGraph().refresh();
    }

    public boolean isVertexLabel() {
        return this.graph.isVertexLabel();
    }

    public void setVertexLabel(boolean bl) {
        if (bl != this.graph.isVertexLabel()) {
            this.graph.setVertexLabel(bl);
            this.graphComponent.getGraph().refresh();
        }
    }

    public boolean isEdgeLabel() {
        return this.graph.isEdgeLabel();
    }

    public void setEdgeLabel(boolean bl) {
        if (bl != this.graph.isEdgeLabel()) {
            this.graph.setEdgeLabel(bl);
            this.graphComponent.getGraph().refresh();
        }
    }

    static /* synthetic */ char access$008(GraphViewPanel graphViewPanel) {
        char c = graphViewPanel.c;
        graphViewPanel.c = (char)(c + '\u0001');
        return c;
    }
}

