/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSplitPane;
import simulator.algorithms.AlgorithmTopologicalSort;
import simulator.controllers.TopologicalSortController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.toposort.TopologicalSortStylesheet;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class TopologicalSortPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public TopologicalSortPanel(AlgorithmGraph algorithmGraph) {
        this.makeTopologicalSortGraph(algorithmGraph);
        algorithmGraph.setOriented(true);
        if (!algorithmGraph.getAlgorithmStylesheet().isDirectedEgeStyle()) {
            algorithmGraph.getAlgorithmStylesheet().setDirected(true);
        }
        algorithmGraph.refresh();
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(algorithmGraph, new AlgorithmTopologicalSort());
        final AlgorithmGraphComponent algorithmGraphComponent = AbstractSimulatorPanel.getmxGraphComponent(new AlgorithmGraph(TopologicalSortStylesheet.getStylesheet()));
        mxRubberband mxRubberband2 = new mxRubberband((mxGraphComponent)algorithmGraphComponent);
        algorithmGraphComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() < 0) {
                        algorithmGraphComponent.zoomIn();
                    } else {
                        algorithmGraphComponent.zoomOut();
                    }
                }
            }
        });
        JSplitPane jSplitPane = new JSplitPane(0, (Component)((Object)this.simulatorPanel.getGraphComponent()), (Component)((Object)algorithmGraphComponent));
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(500);
        jSplitPane.setResizeWeight(1.0);
        this.simulatorPanel.getGraphPanel().add((Component)jSplitPane, "Center");
        TopologicalSortController topologicalSortController = new TopologicalSortController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel(), algorithmGraphComponent);
        this.simulatorPanel.setController(topologicalSortController);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeTopologicalSortGraph(AlgorithmGraph algorithmGraph) {
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)algorithmGraph.getModel(), (Object)algorithmGraph.getDefaultParent())) {
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.isVertex()) {
                if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(mxCell2.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData graphVertexBasicData = (GraphVertexBasicData)mxCell2.getValue();
                    mxCell2.setValue((Object)new DfsGraphVertex(graphVertexBasicData.getName(), graphVertexBasicData.isSelected()));
                }
                mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (mxCell2.getValue() != null && !(mxCell2.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            mxCell2.setValue((Object)new DfsGraphEdge());
            mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

