/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;

public class ControlPanel
extends JPanel {
    public static final int MAX_TIME = 6;
    public static final int MIN_TIME = 0;
    public static final int STANDARD_TIME = 4;
    public static final int MAX_DELAY = 10000;
    public static final int MIN_DELAY = 0;
    protected JButton backButton = new JButton();
    protected JButton playButton = new JButton();
    protected JButton resetButton = new JButton();
    protected JButton forwardButton = new JButton();
    protected JSlider speedSlider = new JSlider(0, 0, 6, 4);

    public ControlPanel() {
        super(new BorderLayout());
        Serializable serializable;
        Serializable serializable2;
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.setInverted(true);
        Enumeration enumeration = this.speedSlider.getLabelTable().keys();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            serializable2 = (Integer)enumeration.nextElement();
            serializable = (JLabel)this.speedSlider.getLabelTable().get(serializable2);
            if ((Integer)serializable2 == 0) {
                serializable.setText("Max");
                continue;
            }
            serializable.setText(n + "x");
            n *= 2;
        }
        this.speedSlider.setPaintLabels(true);
        serializable2 = new JToolBar();
        ((Component)serializable2).setName("Control of the algorithm simulation");
        ((JToolBar)serializable2).setLayout(new GridBagLayout());
        this.speedSlider.setFocusable(false);
        this.backButton.setFocusable(false);
        this.backButton.setHideActionText(true);
        this.backButton.setBorderPainted(false);
        this.playButton.setFocusable(false);
        this.playButton.setHideActionText(true);
        this.playButton.setBorderPainted(false);
        this.resetButton.setFocusable(false);
        this.resetButton.setHideActionText(true);
        this.resetButton.setBorderPainted(false);
        this.forwardButton.setFocusable(false);
        this.forwardButton.setHideActionText(true);
        this.forwardButton.setBorderPainted(false);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((Container)serializable2).add(this.backButton, serializable);
        ((GridBagConstraints)serializable).gridx = 1;
        ((Container)serializable2).add(this.resetButton, serializable);
        ((GridBagConstraints)serializable).gridx = 2;
        ((Container)serializable2).add(this.playButton, serializable);
        ((GridBagConstraints)serializable).gridx = 3;
        ((Container)serializable2).add(this.forwardButton, serializable);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 4;
        ((Container)serializable2).add(this.speedSlider, serializable);
        ((JToolBar)serializable2).setRollover(false);
        this.add((Component)serializable2, "Before");
    }

    public void setButtonsEnabled(boolean bl) {
        this.backButton.setEnabled(bl);
        this.playButton.setEnabled(bl);
        this.resetButton.setEnabled(bl);
        this.forwardButton.setEnabled(bl);
    }

    public void setAllEnabled(boolean bl) {
        this.speedSlider.setEnabled(bl);
        this.setButtonsEnabled(bl);
    }

    public AbstractButton getBackButton() {
        return this.backButton;
    }

    public AbstractButton getPlayButton() {
        return this.playButton;
    }

    public AbstractButton getResetButton() {
        return this.resetButton;
    }

    public AbstractButton getForwardButton() {
        return this.forwardButton;
    }

    public JSlider getSpeedSlider() {
        return this.speedSlider;
    }

    public static int getDelayBySliderValue(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        n = (int)Math.pow(2.0, n2 - n);
        int n4 = 10000 / n;
        return n4;
    }

    public static int getStandardTime() {
        return ControlPanel.getDelayBySliderValue(4, 6, 0);
    }
}

