/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.dfs;

import simulator.graphs.AbstractGraphCell;
import simulator.graphs.dfs.DfsNodeData;
import simulator.graphs.dfs.DfsOperations;

public class DfsGraphVertex
extends AbstractGraphCell
implements DfsOperations {
    protected DfsNodeData state = null;

    public DfsGraphVertex() {
        this((String)null);
    }

    public DfsGraphVertex(String string) {
        this(string, false);
    }

    public DfsGraphVertex(String string, Boolean bl) {
        this(string, new DfsNodeData(), bl);
    }

    public DfsGraphVertex(String string, DfsNodeData dfsNodeData, Boolean bl) {
        super(string, bl);
        this.state = dfsNodeData;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled()) {
            return this.getName();
        }
        StringBuilder stringBuilder = new StringBuilder(this.getName() + '\n');
        if (this.state.getFirstTimestamp() != null) {
            stringBuilder.append(this.state.getFirstTimestamp());
        }
        stringBuilder.append(" / ");
        if (this.state.getSecondTimestamp() != null) {
            stringBuilder.append(this.state.getSecondTimestamp());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.state.setEnabled(bl);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean bl) {
        this.state.setActive(bl);
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean bl) {
        this.state.setToolTipsEnabled(bl);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    @Override
    public Integer getFirstTimestamp() {
        return this.state.getFirstTimestamp();
    }

    @Override
    public Integer getSecondTimestamp() {
        return this.state.getSecondTimestamp();
    }

    @Override
    public DfsGraphVertex getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(DfsGraphVertex dfsGraphVertex) {
        this.state.setNodePath(dfsGraphVertex);
    }

    @Override
    public void setFirstTimestamp(Integer n) {
        this.state.setFirstTimestamp(n);
    }

    @Override
    public void setSecondTimestamp(Integer n) {
        this.state.setSecondTimestamp(n);
    }
}

