/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.dfs;

import com.mxgraph.model.mxCell;
import simulator.graphs.AbstractGraphCell;
import simulator.graphs.BasicNodeData;
import simulator.graphs.dfs.DfsGraphVertex;

public class DfsGraphEdge
extends AbstractGraphCell {
    protected BasicNodeData state;
    protected DfsEdgeType edgeType;
    protected DfsEdgeType iniEdgeType;

    public DfsGraphEdge() {
        this(DfsEdgeType.NOTHING, false);
    }

    public DfsGraphEdge(boolean bl) {
        this(DfsEdgeType.NOTHING, bl);
    }

    public DfsGraphEdge(DfsEdgeType dfsEdgeType, boolean bl) {
        this.edgeType = this.iniEdgeType = dfsEdgeType;
        this.state = new BasicNodeData();
        this.state.setEnabled(bl);
    }

    public DfsEdgeType getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(DfsEdgeType dfsEdgeType) {
        this.edgeType = dfsEdgeType;
    }

    @Override
    public String getLabel() {
        if (this.state.isEnabled()) {
            return this.edgeType.getStrRepresentation();
        }
        return "";
    }

    @Override
    public String getToolTips() {
        return "";
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.state.setEnabled(bl);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean bl) {
        this.state.setActive(bl);
    }

    @Override
    public void resetState() {
        this.edgeType = this.iniEdgeType;
        this.state.resetState();
    }

    @Override
    public void setToolTipsEnabled(boolean bl) {
        this.state.setToolTipsEnabled(bl);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }

    public static enum DfsEdgeType {
        NOTHING(""),
        BACK("B"),
        FORWARD("F"),
        CROSS("C"),
        TREE("");

        private String strRepresentation;

        private DfsEdgeType(String string2) {
            this.strRepresentation = string2;
        }

        public String getStrRepresentation() {
            return this.strRepresentation;
        }

        public static DfsEdgeType getType(mxCell mxCell2, String string) {
            DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell2.getSource().getValue();
            DfsGraphVertex dfsGraphVertex2 = (DfsGraphVertex)mxCell2.getTarget().getValue();
            if (mxCell2.getStyle().equals(string) || dfsGraphVertex2.getFirstTimestamp() == null) {
                return NOTHING;
            }
            if (dfsGraphVertex2.getSecondTimestamp() == null) {
                return BACK;
            }
            if (dfsGraphVertex2.getSecondTimestamp() != null && dfsGraphVertex.getFirstTimestamp() < dfsGraphVertex2.getFirstTimestamp()) {
                return FORWARD;
            }
            return CROSS;
        }
    }
}

