/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxConnectionConstraint;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractDfsController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class TopologicalSortController
extends AbstractDfsController {
    protected Deque<mxCell> listL = new LinkedList<mxCell>();
    protected AlgorithmGraphComponent graphComponentList;

    public TopologicalSortController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel, AlgorithmGraphComponent algorithmGraphComponent2) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
        this.graphComponentList = algorithmGraphComponent2;
        this.interactiveMode = false;
        this.resetControllerImpl();
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 3), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), Color.GREEN));
        this.tape.add(new AbstractController.SetLabelTextInstruction("DFS algorithm"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        AbstractController.LabelInstruction labelInstruction = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractDfsController.SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 5)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time initialization"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 5), this.algorithm.getRealLineNumber(1, 5), this.doneColor));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("time", true));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        AbstractController.LabelInstruction labelInstruction2 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 6)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method to\nall unvisited nodes"));
        this.tape.add(new SelectNextNodeInstruction());
        this.tape.add(new AbstractController.SetSelectedCellFirstInstruction(this.vertexList));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 7)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        AbstractController.LabelInstruction labelInstruction3 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)TopologicalSortController.this.activeVariable).getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 8)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Calling the DFS-VISIT method"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction3));
        AbstractController.LabelInstruction labelInstruction4 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction4, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction3);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 2), this.algorithm.getRealLineNumber(0, 2), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Return the result as list L"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 3), this.algorithm.getRealLineNumber(0, 3), this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Topological-Sort algorithm is completed"));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(labelInstruction4);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.PushInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The Begining of DFS-VISIT"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("The first visit of the node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time increment"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set first time stamp"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(true));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction labelInstruction5 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction6 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction6);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in progress"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new SelectNextVisitedNodeInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited, adjust path\nand call DFS-visit for him"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 6)));
        AbstractController.LabelInstruction labelInstruction7 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction7, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)TopologicalSortController.this.activeVariable).getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting of path"));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method on neghboring nodes"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 7)));
        this.tape.add(new AbstractDfsController.SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction7));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableV));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction4, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction7);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 8)));
        this.tape.add(new AbstractDfsController.SetDfsEdgeTypeInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !TopologicalSortController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction5);
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 10)));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Second visit of the node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 11)));
        this.tape.add(new AbstractController.SetColorInstruction("DONE_VERTEX_STYLE"));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting the second time stamp"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(false));
        this.tape.add(new AbstractController.DequeueInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Add node into the list L"));
        this.tape.add(new AddActiveNodeToListLInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Topological-Sort algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("Seznam L", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.listL);
            }
        });
        this.variables.put("Stack S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.visitStack);
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return TopologicalSortController.this.getNodeName(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return TopologicalSortController.this.getNodeName(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableV));
            }
        });
        this.variables.put("time", new VariableObject(true, false){

            @Override
            public String getVariableValue() {
                return Integer.toString(TopologicalSortController.this.timeVariable);
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(TopologicalSortController.this.vertexList);
            }
        });
        for (Map.Entry entry : this.variables.entrySet()) {
            if (!((VariableObject)entry.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)entry.getKey());
        }
        this.contextStack.clear();
        this.vertexList.clear();
        this.listL.clear();
        this.visitStack.clear();
        this.timeVariable = 0;
        this.clearGraphComponent(this.graphComponentList);
        this.graphComponentList.getGraph().refresh();
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class AddActiveNodeToListLEdit
    extends AbstractController.AlgorithmUndoableEdit {
        private final int VERTEX_X = 10;
        private final int VERTEX_Y = 60;
        private final int VERTEX_WIDTH = 80;
        private final int VERTEX_HEIGHT = 60;
        private final int VERTEX_MOVE = 120;
        private final int MAX_LEVEL = 4;
        private final int EDGE_LEVEL_STEP = 12;
        protected mxCell inserted;
        protected mxCell newLGraphVertex;

        public AddActiveNodeToListLEdit(mxCell mxCell2) {
            this.inserted = mxCell2;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            TopologicalSortController.this.listL.remove(this.newLGraphVertex);
            AlgorithmGraph algorithmGraph = TopologicalSortController.this.graphComponentList.getGraph();
            for (Object object : algorithmGraph.getEdges(this.newLGraphVertex)) {
                algorithmGraph.getModel().remove(object);
            }
            algorithmGraph.getModel().remove((Object)this.newLGraphVertex);
            algorithmGraph.moveCells(algorithmGraph.getChildCells(algorithmGraph.getDefaultParent()), -120.0, 0.0);
            this.arrangeEdges(algorithmGraph);
            algorithmGraph.refresh();
        }

        protected void insertAllEdges(AlgorithmGraph algorithmGraph, List<List<mxCell>> list) {
            int n;
            int n2 = 1;
            for (n = 1; n < list.size(); ++n) {
                if (list.get(n).size() <= 0) continue;
                n2 = n;
                break;
            }
            if ((n = list.size() - n2 + 1) > 4) {
                n = 4;
            }
            for (int i = 1; i < list.size(); ++i) {
                int n3 = 0;
                for (mxCell mxCell2 : list.get(i)) {
                    n3 += 10 / list.get(i).size();
                    mxCell mxCell3 = (mxCell)mxCell2.getSource();
                    mxCell mxCell4 = (mxCell)mxCell2.getTarget();
                    Point point = algorithmGraph.getModel().getGeometry((Object)mxCell3).getPoint();
                    Point point2 = algorithmGraph.getModel().getGeometry((Object)mxCell4).getPoint();
                    int n4 = i - n2 + 1;
                    mxGeometry mxGeometry2 = algorithmGraph.getModel().getGeometry((Object)mxCell2);
                    mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                    ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
                    if (n4 > 4) {
                        algorithmGraph.setConnectionConstraint(mxCell2, mxCell3, true, new mxConnectionConstraint(new mxPoint(1.0 - (double)(n4 -= 4) / (double)n, 1.0), true));
                        algorithmGraph.setConnectionConstraint(mxCell2, mxCell4, false, new mxConnectionConstraint(new mxPoint((double)n4 / (double)n, 1.0), true));
                        arrayList.add(new mxPoint((double)point.x + 80.0 * (1.0 - (double)n4 / (double)n), (double)(point.y + 60 + 12 * n4 + n3)));
                        arrayList.add(new mxPoint((double)point2.x + 80.0 * ((double)n4 / (double)n), (double)(point2.y + 60 + 12 * n4 + n3)));
                    } else {
                        algorithmGraph.setConnectionConstraint(mxCell2, mxCell3, true, new mxConnectionConstraint(new mxPoint(1.0 - (double)(--n4) / (double)n, 0.0), true));
                        algorithmGraph.setConnectionConstraint(mxCell2, mxCell4, false, new mxConnectionConstraint(new mxPoint((double)n4 / (double)n, 0.0), true));
                        arrayList.add(new mxPoint((double)point.x + 80.0 * (1.0 - (double)n4 / (double)n), (double)(point.y - 12 * (n4 + 1) - n3)));
                        arrayList.add(new mxPoint((double)point2.x + 80.0 * ((double)n4 / (double)n), (double)(point2.y - 12 * (n4 + 1) - n3)));
                    }
                    mxGeometry2.setPoints(arrayList);
                    algorithmGraph.getModel().setGeometry((Object)mxCell2, mxGeometry2);
                }
            }
        }

        protected void arrangeEdges(AlgorithmGraph algorithmGraph) {
            for (mxCell objectArray : TopologicalSortController.this.listL) {
                algorithmGraph.moveCells(algorithmGraph.getChildCells(algorithmGraph.getDefaultParent()), 120.0, 0.0);
                mxGeometry mxGeometry2 = algorithmGraph.getModel().getGeometry((Object)objectArray);
                mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                mxGeometry2.setX(10.0);
                mxGeometry2.setY(60.0);
                algorithmGraph.getModel().setGeometry((Object)objectArray, mxGeometry2);
            }
            ArrayList arrayList = new ArrayList();
            for (Object object : algorithmGraph.getChildEdges(algorithmGraph.getDefaultParent())) {
                mxCell mxCell2 = (mxCell)object;
                Point point = algorithmGraph.getModel().getGeometry((Object)mxCell2.getSource()).getPoint();
                Point point2 = algorithmGraph.getModel().getGeometry((Object)mxCell2.getTarget()).getPoint();
                int n = point.x > point2.x ? (point.x - point2.x) / 120 : (point2.x - point.x) / 120;
                for (int i = arrayList.size(); i < n; ++i) {
                    arrayList.add(i, new ArrayList());
                }
                ((List)arrayList.get(n - 1)).add(mxCell2);
                algorithmGraph.resetEdge(mxCell2);
            }
            this.insertAllEdges(algorithmGraph, arrayList);
        }

        protected void insertNewEdges(AlgorithmGraph algorithmGraph, mxCell mxCell2) {
            for (int i = 0; i < TopologicalSortController.this.graph.getModel().getEdgeCount((Object)mxCell2); ++i) {
                mxCell mxCell3 = (mxCell)TopologicalSortController.this.graph.getModel().getEdgeAt((Object)mxCell2, i);
                GraphCell graphCell = (GraphCell)mxCell3.getSource().getValue();
                GraphCell graphCell2 = (GraphCell)mxCell3.getTarget().getValue();
                mxCell mxCell4 = null;
                mxCell mxCell5 = null;
                for (mxCell mxCell6 : TopologicalSortController.this.listL) {
                    if (mxCell4 == null && ((GraphCell)mxCell6.getValue()).getName().equals(graphCell.getName())) {
                        mxCell4 = mxCell6;
                        continue;
                    }
                    if (mxCell5 != null || !((GraphCell)mxCell6.getValue()).getName().equals(graphCell2.getName())) continue;
                    mxCell5 = mxCell6;
                }
                if (mxCell4 == null || mxCell5 == null) continue;
                algorithmGraph.insertEdge(algorithmGraph.getDefaultParent(), null, null, mxCell4, mxCell5, mxCell3.getStyle());
            }
        }

        @Override
        protected void action() {
            AlgorithmGraph algorithmGraph = TopologicalSortController.this.graphComponentList.getGraph();
            algorithmGraph.moveCells(algorithmGraph.getChildCells(algorithmGraph.getDefaultParent()), 120.0, 0.0);
            this.newLGraphVertex = (mxCell)algorithmGraph.insertVertex(algorithmGraph.getDefaultParent(), null, (DfsGraphVertex)this.inserted.getValue(), 10.0, 60.0, 80.0, 60.0, TopologicalSortController.this.stylesheet.getMiniVertexStyle());
            TopologicalSortController.this.listL.addLast(this.newLGraphVertex);
            this.insertNewEdges(algorithmGraph, this.inserted);
            this.arrangeEdges(algorithmGraph);
            algorithmGraph.refresh();
        }
    }

    protected class AddActiveNodeToListLInstruction
    extends AbstractController.BasicInstruction {
        protected AddActiveNodeToListLInstruction() {
        }

        @Override
        public void preform() {
            TopologicalSortController.this.editBlock.addEdit(new AddActiveNodeToListLEdit((mxCell)TopologicalSortController.this.activeVariable));
        }
    }

    protected class SelectNextNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectNextNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, TopologicalSortController.this.graphComponent, TopologicalSortController.this.graph);
            this.adapter.setActivated(false);
            TopologicalSortController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                TopologicalSortController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                        if (mxCell2.getStyle().equals(TopologicalSortController.this.stylesheet.getInitVertexStyle())) {
                            TopologicalSortController.this.graphComponentLabel.setText(TopologicalSortController.this.getTextForLabel("Select a node which has not been visited and click continue\n[u\u017eivatelsk\u00e1 akce]"));
                            TopologicalSortController.this.timer.setEnabled(false);
                            SelectNextNodeInstruction.this.adapter.setActivated(true);
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
            } else if (this.adapter.getLastSelected() != null) {
                TopologicalSortController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                        if (mxCell2 == SelectNextNodeInstruction.this.adapter.getLastSelected()) {
                            graphCell.setSelected(true);
                        } else {
                            graphCell.setSelected(false);
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
                this.stop();
                return;
            }
            TopologicalSortController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return TopologicalSortController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                TopologicalSortController.this.timer.setEnabled(true);
            }
        }
    }

    protected class SelectNextVisitedNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected mxCell lastClosed = null;
        protected Set<mxCell> canBeVisitedSet = new HashSet<mxCell>();

        public SelectNextVisitedNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, TopologicalSortController.this.graphComponent, TopologicalSortController.this.graph);
            this.adapter.setActivated(false);
            TopologicalSortController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                if (this.lastClosed == TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU)) {
                    return;
                }
                this.canBeVisitedSet.clear();
                for (int i = 0; i < TopologicalSortController.this.graph.getModel().getEdgeCount(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU)); ++i) {
                    mxCell mxCell2 = (mxCell)TopologicalSortController.this.graph.getModel().getEdgeAt(TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU), i);
                    mxCell mxCell3 = (mxCell)mxCell2.getSource();
                    mxCell mxCell4 = (mxCell)mxCell2.getTarget();
                    DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell4.getValue();
                    if (mxCell3 != TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU) || dfsGraphVertex.getFirstTimestamp() != null) continue;
                    this.canBeVisitedSet.add(mxCell4);
                }
                TopologicalSortController.this.graphComponentLabel.setText(TopologicalSortController.this.getTextForLabel("Select a next node to be visited and continue\n[u\u017eivatelsk\u00e1 akce]"));
                TopologicalSortController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                mxCell mxCell5 = this.adapter.getLastSelected();
                if (this.canBeVisitedSet.isEmpty() && mxCell5 == TopologicalSortController.this.getRegisterValue(TopologicalSortController.this.variableU) || this.canBeVisitedSet.contains(mxCell5)) {
                    if (!this.canBeVisitedSet.contains(mxCell5)) {
                        this.lastClosed = mxCell5;
                    }
                    if (!TopologicalSortController.this.vertexList.isEmpty() && TopologicalSortController.this.vertexList.contains(mxCell5)) {
                        TopologicalSortController.this.vertexList.remove(mxCell5);
                        TopologicalSortController.this.vertexList.addFirst(mxCell5);
                    }
                    this.stop();
                    return;
                }
            }
            TopologicalSortController.this.pause = true;
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                TopologicalSortController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return TopologicalSortController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }
}

