/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractDfsController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.graphs.scc.SccGraphCell;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class SccController
extends AbstractDfsController {
    protected AlgorithmGraphComponent standardGraph;
    protected AlgorithmGraphComponent transposeGraph;
    protected AlgorithmGraphComponent componentsGraph;
    protected AlgorithmGraph mainGraph;
    protected Deque<mxCell> componentNodes = new LinkedList<mxCell>();
    protected SccControllerState state = SccControllerState.NORMAL_GRAPH_DFS_CALL;

    public SccController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel, AlgorithmGraphComponent algorithmGraphComponent2, AlgorithmGraphComponent algorithmGraphComponent3) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
        this.mainGraph = this.graph;
        this.transposeGraph = algorithmGraphComponent2;
        this.standardGraph = algorithmGraphComponent;
        new ExtendedColorStyle((BasicStylesheet)algorithmGraphComponent2.getGraph().getAlgorithmStylesheet(), algorithmGraphComponent2.getGraph().getAlgorithmStylesheet().getRootVertexStyle());
        this.componentsGraph = algorithmGraphComponent3;
        new ExtendedColorStyle((BasicStylesheet)algorithmGraphComponent3.getGraph().getAlgorithmStylesheet(), algorithmGraphComponent3.getGraph().getAlgorithmStylesheet().getComponentVertexStyle());
        this.interactiveMode = false;
        this.resetControllerImpl();
        AbstractController.LabelInstruction labelInstruction = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction2 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction3 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 4), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), Color.GREEN));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The first calling DFS"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SelectStartNodeInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction2);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Make the transposed graph"));
        this.tape.add(new SetSccAlgStateInstruction(SccControllerState.TRANSPOSE_GRAPH_DFS_CALL));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction(true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 2), this.algorithm.getRealLineNumber(0, 2), this.doneColor));
        this.tape.add(new MakeTransposeGraphInstruction());
        this.tape.add((AbstractController)this.new AbstractController.SetNewActiveGraphInstruction(algorithmGraphComponent2));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The second calling DFS"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 3), this.algorithm.getRealLineNumber(0, 3), this.doneColor));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction3);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 4), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 11), this.doneColor));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(labelInstruction);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        AbstractController.LabelInstruction labelInstruction4 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction4);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractDfsController.SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction4, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 5)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time initialization"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("time", true));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        this.tape.add(new OrderVertexListBySecondTimestampInstruction());
        AbstractController.LabelInstruction labelInstruction5 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction5);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 6)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method\nto all unvisited nodes"));
        this.tape.add(new AbstractController.SetSelectedCellFirstInstruction(this.vertexList));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 7)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        AbstractController.LabelInstruction labelInstruction6 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)SccController.this.activeVariable).getStyle().equals(SccController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new SelectNextScComponentInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 8)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Calling the DFS-VISIT method"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ClearQueueInstruction(this.componentNodes));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        AbstractController.LabelInstruction labelInstruction7 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction8 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction7));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction8, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction7);
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.NORMAL_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Adding of new strong components"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AddNewScComponentInstruction());
        this.tape.add(labelInstruction6);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.NORMAL_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL;
            }
        }));
        this.tape.add(labelInstruction8);
        this.tape.add(new AbstractController.EnqueueInstruction(this.componentNodes));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.PushInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The beginning of DFS-VISIT"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("First visit of the node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time increment"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set up of the first time stamp"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(true));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction labelInstruction9 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction10 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction10);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in progress"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction9, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited yet,\nadjust path and call DFS-VISIT for him"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 6)));
        AbstractController.LabelInstruction labelInstruction11 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction11, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)SccController.this.activeVariable).getStyle().equals(SccController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting of path"));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method on neghboring nodes"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 7)));
        this.tape.add(new AbstractDfsController.SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction11));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableV));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction8, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction11);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 8)));
        this.tape.add(new AbstractDfsController.SetDfsEdgeTypeInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction10, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !SccController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction9);
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 10)));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Second visit of the node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 11)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getDoneVertexStyle()));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Setting the second time stamp"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(false));
        this.tape.add(new AbstractController.DequeueInstruction(this.visitStack));
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Algorithm in order to search strongly connected components");
        this.codePanel.setCurrentLine(1);
        ExtendedColorStyle.resetIndex();
        this.variables.put("Stack S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(SccController.this.visitStack);
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return SccController.this.getNodeName(SccController.this.getRegisterValue(SccController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return SccController.this.getNodeName(SccController.this.getRegisterValue(SccController.this.variableV));
            }
        });
        this.variables.put("time", new VariableObject(true, false){

            @Override
            public String getVariableValue() {
                return Integer.toString(SccController.this.timeVariable);
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(SccController.this.vertexList);
            }
        });
        for (Map.Entry entry : this.variables.entrySet()) {
            if (!((VariableObject)entry.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)entry.getKey());
        }
        this.vertexList.clear();
        this.contextStack.clear();
        this.visitStack.clear();
        this.timeVariable = 0;
        this.state = SccControllerState.NORMAL_GRAPH_DFS_CALL;
        this.clearGraphComponent(this.transposeGraph);
        this.transposeGraph.getGraph().refresh();
        this.clearGraphComponent(this.componentsGraph);
        this.transposeGraph.getGraph().refresh();
    }

    @Override
    public void resetController() {
        this.graph = this.mainGraph;
        this.graphComponent = this.standardGraph;
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class SetSccAlgStateEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected SccControllerState newState;
        protected SccControllerState oldState;

        public SetSccAlgStateEdit(SccControllerState sccControllerState) {
            this.newState = sccControllerState;
            this.oldState = SccController.this.state;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            SccController.this.state = this.oldState;
        }

        @Override
        protected void action() {
            SccController.this.state = this.newState;
        }
    }

    protected class SetSccAlgStateInstruction
    extends AbstractController.BasicInstruction {
        protected SccControllerState newState;

        public SetSccAlgStateInstruction(SccControllerState sccControllerState) {
            this.newState = sccControllerState;
        }

        @Override
        public void preform() {
            SccController.this.editBlock.addEdit(new SetSccAlgStateEdit(this.newState));
        }
    }

    protected final class MakeTransposeGraphVisibleEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent gc;

        public MakeTransposeGraphVisibleEdit(AlgorithmGraphComponent algorithmGraphComponent) {
            this.gc = algorithmGraphComponent;
            this.action();
        }

        protected void setVisible(AlgorithmGraph algorithmGraph, final boolean bl) {
            algorithmGraph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    mxCell2.setVisible(bl);
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }

        @Override
        public void undo() {
            super.undo();
            this.setVisible(this.gc.getGraph(), false);
            this.gc.getGraph().refresh();
        }

        @Override
        protected void action() {
            this.setVisible(this.gc.getGraph(), true);
            this.gc.getGraph().refresh();
        }
    }

    protected class MakeTransposeGraphInstruction
    extends AbstractController.BasicInstruction {
        protected MakeTransposeGraphInstruction() {
        }

        @Override
        public void preform() {
            AlgorithmGraph algorithmGraph = SccController.this.transposeGraph.getGraph();
            algorithmGraph.addCells(SccController.this.graph.cloneCells(SccController.this.graph.getChildCells(SccController.this.graph.getDefaultParent())));
            algorithmGraph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (mxCell2.isVertex()) {
                        mxCell2.setValue((Object)new DfsGraphVertex(graphCell.getName()));
                        mxCell2.setStyle(SccController.this.stylesheet.getVertexStyle());
                    } else if (mxCell2.isEdge()) {
                        mxCell2.setValue((Object)new DfsGraphEdge());
                        mxCell2.setStyle(SccController.this.stylesheet.getEdgeStyle());
                        mxCell mxCell3 = (mxCell)mxCell2.getTarget();
                        mxCell mxCell4 = (mxCell)mxCell2.getSource();
                        mxCell2.setSource((mxICell)mxCell3);
                        mxCell2.setTarget((mxICell)mxCell4);
                    }
                    mxCell2.setVisible(false);
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
            SccController.this.editBlock.addEdit(new MakeTransposeGraphVisibleEdit(SccController.this.transposeGraph));
        }
    }

    protected final class AddNewScComponentEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent gc;
        protected Deque<mxCell> nodesList;
        protected Deque<mxCell> oldList;
        protected mxGraph originalGraph;
        protected List<mxCell> newCells = new ArrayList<mxCell>();
        protected String newStyle;

        public AddNewScComponentEdit(AlgorithmGraphComponent algorithmGraphComponent, Deque<mxCell> deque, mxGraph mxGraph2, String string) {
            this.gc = algorithmGraphComponent;
            this.nodesList = deque;
            this.originalGraph = mxGraph2;
            this.newStyle = string;
            this.oldList = new LinkedList<mxCell>();
            this.oldList.addAll(deque);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.nodesList.clear();
            this.nodesList.addAll(this.oldList);
            for (mxCell mxCell2 : this.newCells) {
                this.gc.getGraph().getModel().remove((Object)mxCell2);
            }
            this.newCells.clear();
        }

        protected void makeEdges(AlgorithmGraph algorithmGraph) {
            HashMap<mxCell, Set<mxCell>> hashMap = new HashMap<mxCell, Set<mxCell>>();
            for (int i = 0; i < algorithmGraph.getModel().getChildCount(algorithmGraph.getDefaultParent()); ++i) {
                mxCell object = (mxCell)algorithmGraph.getModel().getChildAt(algorithmGraph.getDefaultParent(), i);
                if (!object.isVertex()) continue;
                hashMap.put(object, ((SccGraphCell)object.getValue()).makeAdj(this.originalGraph, true));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                block2: for (Map.Entry entry2 : hashMap.entrySet()) {
                    if (entry.getKey() == entry2.getKey() || algorithmGraph.getEdgesBetween(entry.getKey(), entry2.getKey(), false).length != 0) continue;
                    for (mxCell mxCell2 : (Set)entry.getValue()) {
                        if (!((SccGraphCell)((mxCell)entry2.getKey()).getValue()).getNodes().contains(mxCell2)) continue;
                        this.newCells.add((mxCell)algorithmGraph.insertEdge(algorithmGraph.getDefaultParent(), null, new DfsGraphEdge(), entry.getKey(), entry2.getKey(), SccController.this.stylesheet.getEdgeStyle()));
                        continue block2;
                    }
                }
            }
        }

        @Override
        protected void action() {
            AlgorithmGraph algorithmGraph = this.gc.getGraph();
            double d = 0.0;
            double d2 = 0.0;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.nodesList.size() > 0) {
                SccGraphCell sccGraphCell = new SccGraphCell();
                for (mxCell mxCell2 : this.nodesList) {
                    DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell2.getValue();
                    stringBuilder.append(dfsGraphVertex.getName());
                    d += mxCell2.getGeometry().getX();
                    d2 += mxCell2.getGeometry().getY();
                    sccGraphCell.addNode(mxCell2);
                }
                sccGraphCell.setName(stringBuilder.toString());
                this.newCells.add((mxCell)algorithmGraph.insertVertex(algorithmGraph.getDefaultParent(), null, sccGraphCell, d /= (double)this.nodesList.size(), d2 /= (double)this.nodesList.size(), 80.0, 80.0, this.newStyle));
                this.nodesList.clear();
                this.makeEdges(algorithmGraph);
            }
        }
    }

    protected class AddNewScComponentInstruction
    extends AbstractController.BasicInstruction {
        protected AddNewScComponentInstruction() {
        }

        @Override
        public void preform() {
            String string = ExtendedColorStyle.getNextStyle();
            for (mxCell mxCell2 : SccController.this.componentNodes) {
                SccController.this.editBlock.addEdit(new AbstractController.SetColorEdit(string, mxCell2));
            }
            SccController.this.editBlock.addEdit(new AddNewScComponentEdit(SccController.this.componentsGraph, SccController.this.componentNodes, SccController.this.graph, string));
        }
    }

    protected final class OrderVertexListBySecondTimestampEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<mxCell> cellList;
        protected Deque<mxCell> oldCellList;
        protected AlgorithmGraph cellsGraph;

        public OrderVertexListBySecondTimestampEdit(Deque<mxCell> deque, AlgorithmGraph algorithmGraph) {
            this.cellList = deque;
            this.oldCellList = new LinkedList<mxCell>();
            this.oldCellList.addAll(deque);
            this.cellsGraph = algorithmGraph;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.cellList.clear();
            this.cellList.addAll(this.oldCellList);
        }

        @Override
        protected void action() {
            Collections.sort((List)((Object)this.cellList), new Comparator<mxCell>(){
                private int firstCellTime;
                private int secondCellTime;

                @Override
                public int compare(mxCell mxCell2, mxCell mxCell3) {
                    final DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell2.getValue();
                    final DfsGraphVertex dfsGraphVertex2 = (DfsGraphVertex)mxCell3.getValue();
                    this.firstCellTime = 0;
                    this.secondCellTime = 0;
                    OrderVertexListBySecondTimestampEdit.this.cellsGraph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                        @Override
                        public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                            if (dfsGraphVertex.getName().equals(graphCell.getName())) {
                                firstCellTime = ((DfsGraphVertex)graphCell).getSecondTimestamp();
                            } else if (dfsGraphVertex2.getName().equals(graphCell.getName())) {
                                secondCellTime = ((DfsGraphVertex)graphCell).getSecondTimestamp();
                            }
                            return firstCellTime == 0 || secondCellTime == 0;
                        }

                        @Override
                        public boolean allowEdge() {
                            return false;
                        }
                    });
                    return this.secondCellTime - this.firstCellTime;
                }
            });
        }
    }

    protected class OrderVertexListBySecondTimestampInstruction
    extends AbstractController.BasicInstruction {
        protected OrderVertexListBySecondTimestampInstruction() {
        }

        @Override
        public void preform() {
            if (SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL) {
                SccController.this.editBlock.addEdit(new OrderVertexListBySecondTimestampEdit(SccController.this.vertexList, SccController.this.mainGraph));
            }
        }
    }

    protected class SelectNextScComponentInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected Deque<mxCell> expectedNodes = new LinkedList<mxCell>();

        public SelectNextScComponentInstruction() {
            this.adapter = new SelectCellsMouseAdapter(SccController.this.transposeGraph, SccController.this.graph);
            this.adapter.setActivated(false);
            SccController.this.transposeGraph.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        protected void makeExpectedList(mxCell mxCell2) {
            LinkedList<mxCell> linkedList = new LinkedList<mxCell>();
            linkedList.push(mxCell2);
            while (!linkedList.isEmpty()) {
                mxCell mxCell3 = (mxCell)linkedList.pop();
                for (int i = 0; i < SccController.this.graph.getModel().getEdgeCount((Object)mxCell3); ++i) {
                    mxCell mxCell4 = (mxCell)SccController.this.graph.getModel().getEdgeAt((Object)mxCell3, i);
                    mxCell mxCell5 = (mxCell)mxCell4.getSource();
                    mxCell mxCell6 = (mxCell)mxCell4.getTarget();
                    if (mxCell5 != mxCell3 || this.expectedNodes.contains(mxCell6) || !mxCell6.getStyle().equals(SccController.this.stylesheet.getInitVertexStyle())) continue;
                    linkedList.push(mxCell6);
                }
                if (this.expectedNodes.contains(mxCell3)) continue;
                this.expectedNodes.add(mxCell3);
            }
        }

        @Override
        public void preform() {
            if (SccController.this.state == SccControllerState.TRANSPOSE_GRAPH_DFS_CALL) {
                if (!this.adapter.isActivated()) {
                    this.expectedNodes.clear();
                    this.makeExpectedList((mxCell)SccController.this.getRegisterValue(SccController.this.variableU));
                    SccController.this.graphComponentLabel.setText(SccController.this.getTextForLabel("Select nodes of the next component and continue\n[u\u017eivatelsk\u00e1 akce]"));
                    SccController.this.timer.setEnabled(false);
                    this.adapter.setActivated(true);
                } else if (this.adapter.getLastSelected() != null) {
                    Deque<mxCell> deque = this.adapter.getSelectedNodes();
                    if (deque.size() == this.expectedNodes.size() && deque.containsAll(this.expectedNodes)) {
                        this.stop();
                        return;
                    }
                    SccController.this.graphComponentLabel.setText(SccController.this.getTextForLabel("Wrong nodes of the strong components selected\n[u\u017eivatelsk\u00e1 akce]"));
                }
                SccController.this.pause = true;
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return SccController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                SccController.this.timer.setEnabled(true);
            }
        }
    }

    protected static class ExtendedColorStyle {
        protected BasicStylesheet extendedSheet;
        private static String[] names = new String[]{"AERO", "AMETHYST", "APPLE", "X11GRAY", "AURELION", "BLUSH", "CADMIUM_ORANGE", "MAROON", "CG Blue", "DARK_PASTER_GREEN", "CHARCOAL", "CAFE_AU_LAIT", "HAN_PURPLE", "MODE_NEIGE", "MINT", "FERRARI_RED"};
        protected String fromStyle;
        private static int index = 0;

        public ExtendedColorStyle(BasicStylesheet basicStylesheet, String string) {
            this.extendedSheet = basicStylesheet;
            this.fromStyle = string;
            this.addNewColorStyle(names[0], "#7CB9E8");
            this.addNewColorStyle(names[1], "#9966CC");
            this.addNewColorStyle(names[2], "#8DB600");
            this.addNewColorStyle(names[3], "#BEBEBE");
            this.addNewColorStyle(names[4], "#FDEE00");
            this.addNewColorStyle(names[5], "#DE5D83");
            this.addNewColorStyle(names[6], "#ED872D");
            this.addNewColorStyle(names[7], "#800000");
            this.addNewColorStyle(names[8], "#007AA5");
            this.addNewColorStyle(names[9], "#03C03C");
            this.addNewColorStyle(names[10], "#36454F");
            this.addNewColorStyle(names[11], "#A67B5B");
            this.addNewColorStyle(names[12], "#5218FA");
            this.addNewColorStyle(names[13], "#967117");
            this.addNewColorStyle(names[14], "#3EB489");
            this.addNewColorStyle(names[15], "#FF2800");
        }

        private void addNewColorStyle(String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll((Map)this.extendedSheet.getStyles().get(this.fromStyle));
            hashMap.put(mxConstants.STYLE_FILLCOLOR, string2);
            this.extendedSheet.putCellStyle(string, hashMap);
        }

        public static String getNextStyle() {
            return names[index++ % names.length];
        }

        public static void resetIndex() {
            index = 0;
        }
    }

    protected static enum SccControllerState {
        NORMAL_GRAPH_DFS_CALL,
        TRANSPOSE_GRAPH_DFS_CALL;

    }
}

