/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Deque;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractDfsController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.SimulatorMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class DfsController
extends AbstractDfsController {
    public DfsController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
        this.interactiveMode = false;
        this.resetControllerImpl();
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 10), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 11), Color.GREEN));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        this.tape.add(new AbstractDfsController.EnableEdgesTypeInstruction());
        AbstractController.LabelInstruction labelInstruction = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getInitVertexStyle()));
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractDfsController.SetPathInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 5)));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 4), this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Time initialization"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("time", true));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 5), this.algorithm.getRealLineNumber(0, 5), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 6)));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.vertexList));
        AbstractController.LabelInstruction labelInstruction2 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction2);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 6)));
        this.tape.add(new SelectNextNodeInstruction());
        this.tape.add(new AbstractController.SetSelectedCellFirstInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method to\nall unvisited nodes"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 7)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        AbstractController.LabelInstruction labelInstruction3 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)DfsController.this.activeVariable).getStyle().equals(DfsController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 8)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Calling the DFS-VISIT method"));
        this.tape.add(new AbstractController.PauseInstruction());
        AbstractController.LabelInstruction labelInstruction4 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction4));
        AbstractController.LabelInstruction labelInstruction5 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(labelInstruction3);
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(labelInstruction4);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 10)));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 10), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 11), this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Algorithm DFS is completed"));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(labelInstruction5);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.PushInstruction(this.visitStack));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The beginning of DFS-VISIT"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("The first visit of the node"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("The Increment of time"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getFirstPassVertexStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set up of the first time stamp"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(true));
        this.tape.add(new AbstractController.MakeAdjListInstruction(this.vertexList, this.graph.isOriented()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new MakeUserAdjListInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction labelInstruction6 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction7 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction6);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Go through all nodes that are next to the one in process"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction7, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return DfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetLabelTextInstruction("If a node has not been visited yet, adjust\n path and call DFS-VISIT for him"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 5)));
        this.tape.add(new AbstractController.DequeueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getHighlighEdgeStyle(), this.graph.isOriented()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 6)));
        AbstractController.LabelInstruction labelInstruction8 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction8, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !((mxCell)DfsController.this.activeVariable).getStyle().equals(DfsController.this.stylesheet.getInitVertexStyle());
            }
        }));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set up of the path"));
        this.tape.add(new AbstractController.ColorEdgeActiveAndRegisterInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.graph.isOriented()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetLabelTextInstruction("Call the DFS-VISIT method to all neighboring nodes"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 7)));
        this.tape.add(new AbstractDfsController.SetPathInstruction(this.variableU));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack, labelInstruction8));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableV));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableU));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction8);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 8)));
        this.tape.add(new SelectDfsEdgeTypeInstruction());
        this.tape.add(new AbstractDfsController.SetDfsEdgeTypeInstruction(this.variableU, this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 9)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !DfsController.this.vertexList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction7);
        this.tape.add(new AbstractController.ClearQueueInstruction(this.vertexList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 10)));
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableU));
        this.tape.add(new AbstractController.SetLabelTextInstruction("The second visit of the node"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 11)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getDoneVertexStyle()));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Set up of the second time stamp"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractDfsController.ChangeTimeInstruction());
        this.tape.add(new AbstractDfsController.SetTimeInstruction(false));
        this.tape.add(new AbstractController.DequeueInstruction(this.visitStack));
        this.tape.add(new AbstractDfsController.ContextInstruction(this.contextStack));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("DFS Algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("Stack S", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(DfsController.this.visitStack);
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return DfsController.this.getNodeName(DfsController.this.getRegisterValue(DfsController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return DfsController.this.getNodeName(DfsController.this.getRegisterValue(DfsController.this.variableV));
            }
        });
        this.variables.put("time", new VariableObject(true, false){

            @Override
            public String getVariableValue() {
                return Integer.toString(DfsController.this.timeVariable);
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(DfsController.this.vertexList);
            }
        });
        for (Map.Entry entry : this.variables.entrySet()) {
            if (!((VariableObject)entry.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)entry.getKey());
        }
        this.vertexList.clear();
        this.timeVariable = 0;
        this.visitStack.clear();
        this.contextStack.clear();
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected class SelectDfsEdgeTypeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SimulatorMouseAdapter adapter;
        protected JPopupMenu popup = new JPopupMenu();
        protected DfsGraphEdge.DfsEdgeType selectedType = DfsGraphEdge.DfsEdgeType.NOTHING;
        protected mxCell edge = null;
        protected ButtonGroup group;

        public SelectDfsEdgeTypeInstruction() {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Forward"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDfsEdgeTypeInstruction.this.selectedType = DfsGraphEdge.DfsEdgeType.FORWARD;
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction("Back"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDfsEdgeTypeInstruction.this.selectedType = DfsGraphEdge.DfsEdgeType.BACK;
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new AbstractAction("Cross"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDfsEdgeTypeInstruction.this.selectedType = DfsGraphEdge.DfsEdgeType.CROSS;
                }
            });
            this.group = new ButtonGroup();
            this.group.add(jRadioButtonMenuItem);
            this.group.add(jRadioButtonMenuItem2);
            this.group.add(jRadioButtonMenuItem3);
            this.popup.add(jRadioButtonMenuItem);
            this.popup.add(jRadioButtonMenuItem2);
            this.popup.add(jRadioButtonMenuItem3);
            this.adapter = new SimulatorMouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (this.activated && mouseEvent.isPopupTrigger()) {
                        this.showMenu(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (this.activated && mouseEvent.isPopupTrigger()) {
                        this.showMenu(mouseEvent);
                    }
                }

                public void showMenu(MouseEvent mouseEvent) {
                    mxCell mxCell2 = (mxCell)DfsController.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                    if (mxCell2 != null && mxCell2.isEdge() && mxCell2 == SelectDfsEdgeTypeInstruction.this.edge) {
                        SelectDfsEdgeTypeInstruction.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            this.adapter.setActivated(false);
            DfsController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        protected mxCell getEdge() {
            for (int i = 0; i < DfsController.this.graph.getModel().getEdgeCount(DfsController.this.activeVariable); ++i) {
                mxCell mxCell2 = (mxCell)DfsController.this.graph.getModel().getEdgeAt(DfsController.this.activeVariable, i);
                mxCell mxCell3 = (mxCell)mxCell2.getTarget();
                mxCell mxCell4 = (mxCell)mxCell2.getSource();
                DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell3.getValue();
                DfsGraphVertex dfsGraphVertex2 = (DfsGraphVertex)mxCell4.getValue();
                DfsGraphEdge dfsGraphEdge = (DfsGraphEdge)mxCell2.getValue();
                if ((mxCell3 != DfsController.this.activeVariable || mxCell4 != DfsController.this.registers[DfsController.this.variableU]) && (DfsController.this.graph.isOriented() || mxCell4 != DfsController.this.activeVariable || mxCell3 != DfsController.this.registers[DfsController.this.variableU]) || !mxCell2.getStyle().equals(DfsController.this.stylesheet.getHighlighEdgeStyle())) continue;
                if (dfsGraphVertex2.getNodePath() != null && dfsGraphVertex2.getNodePath().getName().equals(dfsGraphVertex.getName()) || dfsGraphVertex.getNodePath() != null && dfsGraphVertex2.getName().equals(dfsGraphVertex.getNodePath().getName())) {
                    return null;
                }
                if (dfsGraphEdge.getEdgeType() != DfsGraphEdge.DfsEdgeType.NOTHING) {
                    return null;
                }
                return mxCell2;
            }
            return null;
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                this.edge = this.getEdge();
                if (this.edge != null) {
                    DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("Select a type of active edge\n[u\u017eivatelsk\u00e1 akce, vyskakovac\u00ed menu u hrany]"));
                    DfsController.this.timer.setEnabled(false);
                    this.adapter.setActivated(true);
                }
            } else {
                if (this.edge != null && DfsGraphEdge.DfsEdgeType.getType(this.edge, DfsController.this.stylesheet.getPathEdgeStyle()) == this.selectedType) {
                    DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("The type of edge designed correctly\n[u\u017eivatelsk\u00e1 akce]"));
                    DfsController.this.graph.setSelectionCell(null);
                    this.stop();
                    return;
                }
                DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("The type of edge designed incorrectly\n[u\u017eivatelsk\u00e1 akce]"));
            }
            DfsController.this.pause = true;
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.selectedType = DfsGraphEdge.DfsEdgeType.NOTHING;
                this.group.clearSelection();
                this.edge = null;
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                DfsController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return DfsController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }

    protected class SelectNextNodeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectNextNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, DfsController.this.graphComponent, DfsController.this.graph);
            this.adapter.setActivated(false);
            DfsController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            if (!this.adapter.isActivated()) {
                DfsController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                        if (mxCell2.getStyle().equals(DfsController.this.stylesheet.getInitVertexStyle())) {
                            DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("Select a node which has not been visited and click continue\n[u\u017eivatelsk\u00e1 akce]"));
                            DfsController.this.timer.setEnabled(false);
                            SelectNextNodeInstruction.this.adapter.setActivated(true);
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
            } else if (this.adapter.getLastSelected() != null) {
                DfsController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                        if (mxCell2 == SelectNextNodeInstruction.this.adapter.getLastSelected()) {
                            graphCell.setSelected(true);
                        } else {
                            graphCell.setSelected(false);
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
                this.stop();
                return;
            }
            DfsController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return DfsController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                DfsController.this.timer.setEnabled(true);
            }
        }
    }

    protected class MakeUserAdjListInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public MakeUserAdjListInstruction() {
            this.adapter = new SelectCellsMouseAdapter(DfsController.this.graphComponent, DfsController.this.graph);
            this.adapter.setActivated(false);
            DfsController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        protected boolean isSelectedCorrect(Deque<mxCell> deque, Deque<mxCell> deque2) {
            if (deque.size() != deque2.size()) {
                return false;
            }
            for (mxCell mxCell2 : deque2) {
                if (deque.contains(mxCell2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void preform() {
            DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("Create a list of neghbors for the node\n[u\u017eivatelsk\u00e1 akce]"));
            if (!this.adapter.isActivated()) {
                DfsController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else {
                if (this.isSelectedCorrect(this.adapter.getSelectedNodes(), DfsController.this.vertexList)) {
                    DfsController.this.vertexList.clear();
                    DfsController.this.vertexList.addAll(this.adapter.getSelectedNodes());
                    this.stop();
                    return;
                }
                DfsController.this.graphComponentLabel.setText(DfsController.this.getTextForLabel("Incorrectly created list for node N\n[u\u017eivatelsk\u00e1 akce]"));
            }
            DfsController.this.pause = true;
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                DfsController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return DfsController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }
}

