/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.util.Deque;
import java.util.LinkedList;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractShortestPathController
extends AbstractController {
    protected Deque<mxCell> cellList = new LinkedList<mxCell>();
    protected Integer variableS = 0;
    protected Integer variableV = 1;
    protected Integer variableU = 2;

    public AbstractShortestPathController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
    }

    protected final class SetDistanceEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BellmanFordGraphVertex graphNode;
        protected Double newValue;
        protected Double oldValue;

        public SetDistanceEdit(mxCell mxCell2, Double d) {
            this.graphNode = (BellmanFordGraphVertex)mxCell2.getValue();
            this.newValue = d;
            this.oldValue = this.graphNode.getDistance();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setDistance(this.oldValue);
        }

        @Override
        protected void action() {
            this.graphNode.setDistance(this.newValue);
        }
    }

    protected class SetDistanceInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regIndex1;
        protected Integer regIndex2;
        protected Double value;

        public SetDistanceInstruction(Double d) {
            this.value = d;
            this.regIndex1 = null;
        }

        public SetDistanceInstruction(int n, Double d) {
            this.value = d;
            this.regIndex1 = n;
        }

        public SetDistanceInstruction(int n, int n2) {
            this.regIndex1 = n;
            this.regIndex2 = n2;
        }

        @Override
        public void preform() {
            if (this.regIndex1 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.activeVariable, this.value));
            } else if (this.regIndex1 != null && this.value != null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex1), this.value));
            } else if (this.regIndex1 != null && this.regIndex2 != null) {
                BellmanFordGraphEdge bellmanFordGraphEdge = (BellmanFordGraphEdge)((mxCell)AbstractShortestPathController.this.activeVariable).getValue();
                BellmanFordGraphVertex bellmanFordGraphVertex = (BellmanFordGraphVertex)((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex2)).getValue();
                Double d = bellmanFordGraphVertex.getDistance() + bellmanFordGraphEdge.getDistance();
                AbstractShortestPathController.this.editBlock.addEdit(new SetDistanceEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regIndex1), d));
            }
        }
    }

    protected final class EdgeToRegistersEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected int register1;
        protected int register2;
        protected Object register1Value;
        protected Object register2Value;
        protected mxCell edge;

        public EdgeToRegistersEdit(mxCell mxCell2, int n, int n2) {
            this.register1 = n;
            this.register2 = n2;
            this.edge = mxCell2;
            this.register1Value = AbstractShortestPathController.this.getRegisterValue(n);
            this.register2Value = AbstractShortestPathController.this.getRegisterValue(n2);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractShortestPathController.this.setRegisterValue(this.register1Value, this.register1);
            AbstractShortestPathController.this.setRegisterValue(this.register2Value, this.register2);
        }

        @Override
        protected void action() {
            AbstractShortestPathController.this.setRegisterValue(this.edge.getSource(), this.register1);
            AbstractShortestPathController.this.setRegisterValue(this.edge.getTarget(), this.register2);
        }
    }

    protected class EdgeToRegistersInstruction
    extends AbstractController.BasicInstruction {
        protected int register1;
        protected int register2;

        public EdgeToRegistersInstruction(int n, int n2) {
            this.register1 = n;
            this.register2 = n2;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.editBlock.addEdit(new EdgeToRegistersEdit((mxCell)AbstractShortestPathController.this.activeVariable, this.register1, this.register2));
        }
    }

    protected final class EdgeToActiveEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected mxCell edge;

        public EdgeToActiveEdit(mxCell mxCell2, mxCell mxCell3) {
            this.action();
            this.edge = (mxCell)AbstractShortestPathController.this.graph.getEdgesBetween(mxCell2, mxCell3, true)[0];
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractShortestPathController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractShortestPathController.this.activeVariable = this.edge;
        }
    }

    protected class EdgeToActiveInstruction
    extends AbstractController.BasicInstruction {
        protected int sourceReg;
        protected int targetReg;

        public EdgeToActiveInstruction(int n, int n2) {
            this.sourceReg = n;
            this.targetReg = n2;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.editBlock.addEdit(new EdgeToActiveEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.sourceReg), (mxCell)AbstractShortestPathController.this.getRegisterValue(this.targetReg)));
        }
    }

    protected final class SetPathEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BellmanFordGraphVertex graphNode;
        protected BellmanFordGraphVertex newPath;
        protected BellmanFordGraphVertex oldPath;

        public SetPathEdit(mxCell mxCell2, mxCell mxCell3) {
            this.graphNode = (BellmanFordGraphVertex)mxCell2.getValue();
            this.oldPath = this.graphNode.getNodePath();
            this.newPath = mxCell3 != null ? (BellmanFordGraphVertex)mxCell3.getValue() : null;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setNodePath(this.oldPath);
        }

        @Override
        protected void action() {
            this.graphNode.setNodePath(this.newPath);
        }
    }

    protected class SetPathInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regNum1 = null;
        protected Integer regNum2 = null;

        public SetPathInstruction() {
        }

        public SetPathInstruction(int n) {
            this.regNum1 = n;
        }

        public SetPathInstruction(int n, int n2) {
            this.regNum1 = n;
            this.regNum2 = n2;
        }

        @Override
        public void preform() {
            if (this.regNum1 == null && this.regNum2 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.activeVariable, null));
            } else if (this.regNum1 != null && this.regNum2 == null) {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.activeVariable, (mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum1)));
            } else {
                AbstractShortestPathController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum1), (mxCell)AbstractShortestPathController.this.getRegisterValue(this.regNum2)));
            }
        }
    }

    protected class ColorPathsInstruction
    extends AbstractController.BasicInstruction {
        protected String pathStyle;
        protected String normalStyle;

        public ColorPathsInstruction(String string, String string2) {
            this.pathStyle = string;
            this.normalStyle = string2;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (mxCell2.isEdge()) {
                        BellmanFordGraphVertex bellmanFordGraphVertex = (BellmanFordGraphVertex)mxCell2.getSource().getValue();
                        BellmanFordGraphVertex bellmanFordGraphVertex2 = (BellmanFordGraphVertex)mxCell2.getTarget().getValue();
                        if (bellmanFordGraphVertex2.getNodePath() == bellmanFordGraphVertex) {
                            AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(ColorPathsInstruction.this.pathStyle, mxCell2));
                        } else {
                            AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(ColorPathsInstruction.this.normalStyle, mxCell2));
                        }
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class InitInstruction
    extends AbstractController.BasicInstruction {
        protected String style;
        protected boolean wasSelected = false;

        public InitInstruction(String string) {
            this.style = string;
        }

        @Override
        public void preform() {
            AbstractShortestPathController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (graphCell.isSelected().booleanValue()) {
                        InitInstruction.this.wasSelected = true;
                        AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(InitInstruction.this.style, mxCell2));
                        AbstractShortestPathController.this.setRegisterValue(mxCell2, AbstractShortestPathController.this.variableS);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return false;
                }
            });
            if (!this.wasSelected) {
                mxCell mxCell2 = (mxCell)AbstractShortestPathController.this.graph.getChildVertices(AbstractShortestPathController.this.graph.getDefaultParent())[0];
                AbstractShortestPathController.this.editBlock.addEdit(new AbstractController.SetColorEdit(this.style, mxCell2));
                AbstractShortestPathController.this.setRegisterValue(mxCell2, AbstractShortestPathController.this.variableS);
            }
        }
    }
}

