/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.util.Deque;
import java.util.LinkedList;
import javax.swing.JLabel;
import simulator.controllers.AbstractController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class AbstractDfsController
extends AbstractController {
    protected int timeVariable = 0;
    protected Integer variableV = 0;
    protected Integer variableU = 1;
    protected Deque<mxCell> vertexList = new LinkedList<mxCell>();
    protected Deque<mxCell> visitStack = new LinkedList<mxCell>();
    protected Deque<ContextObject> contextStack = new LinkedList<ContextObject>();

    public AbstractDfsController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
    }

    protected ContextObject getContext(AbstractController.Instruction instruction) {
        return new DfsContextObject(instruction);
    }

    protected final class ZeroTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected int oldTime;

        public ZeroTimeEdit() {
            this.oldTime = AbstractDfsController.this.timeVariable;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDfsController.this.timeVariable = this.oldTime;
        }

        @Override
        protected void action() {
            AbstractDfsController.this.timeVariable = 0;
        }
    }

    protected final class IncTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        public IncTimeEdit() {
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            --AbstractDfsController.this.timeVariable;
        }

        @Override
        protected void action() {
            ++AbstractDfsController.this.timeVariable;
        }
    }

    protected class ChangeTimeInstruction
    extends AbstractController.BasicInstruction {
        protected boolean zero;
        protected boolean inc;

        public ChangeTimeInstruction() {
            this(false, true);
        }

        public ChangeTimeInstruction(boolean bl) {
            this(bl, false);
        }

        public ChangeTimeInstruction(boolean bl, boolean bl2) {
            this.zero = bl;
            this.inc = bl2;
        }

        @Override
        public void preform() {
            if (this.zero) {
                AbstractDfsController.this.editBlock.addEdit(new ZeroTimeEdit());
            } else if (this.inc) {
                AbstractDfsController.this.editBlock.addEdit(new IncTimeEdit());
            }
        }
    }

    protected final class SetTimeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphVertex graphNode;
        protected boolean first;
        protected Integer newTime;
        protected Integer oldTime;

        public SetTimeEdit(mxCell mxCell2, int n, boolean bl) {
            this.graphNode = (DfsGraphVertex)mxCell2.getValue();
            this.newTime = n;
            this.first = bl;
            this.oldTime = this.first ? this.graphNode.getFirstTimestamp() : this.graphNode.getSecondTimestamp();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            if (this.first) {
                this.graphNode.setFirstTimestamp(this.oldTime);
            } else {
                this.graphNode.setSecondTimestamp(this.oldTime);
            }
        }

        @Override
        protected void action() {
            if (this.first) {
                this.graphNode.setFirstTimestamp(this.newTime);
            } else {
                this.graphNode.setSecondTimestamp(this.newTime);
            }
        }
    }

    protected class SetTimeInstruction
    extends AbstractController.BasicInstruction {
        protected boolean first;

        public SetTimeInstruction(boolean bl) {
            this.first = bl;
        }

        @Override
        public void preform() {
            AbstractDfsController.this.editBlock.addEdit(new SetTimeEdit((mxCell)AbstractDfsController.this.activeVariable, AbstractDfsController.this.timeVariable, this.first));
        }
    }

    protected final class SetDfsEdgeTypeEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphEdge edge;
        protected DfsGraphEdge.DfsEdgeType oldType;
        protected DfsGraphEdge.DfsEdgeType newType;

        public SetDfsEdgeTypeEdit(DfsGraphEdge dfsGraphEdge, DfsGraphEdge.DfsEdgeType dfsEdgeType) {
            this.edge = dfsGraphEdge;
            this.newType = dfsEdgeType;
            this.oldType = dfsGraphEdge.getEdgeType();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.edge.setEdgeType(this.oldType);
        }

        @Override
        protected void action() {
            this.edge.setEdgeType(this.newType);
        }
    }

    protected class SetDfsEdgeTypeInstruction
    extends AbstractController.BasicInstruction {
        protected int registerNum;
        protected String pathEdgeStyle;
        protected String edgeStyle;

        public SetDfsEdgeTypeInstruction(int n, String string, String string2) {
            this.registerNum = n;
            this.pathEdgeStyle = string;
            this.edgeStyle = string2;
        }

        @Override
        public void preform() {
            for (int i = 0; i < AbstractDfsController.this.graph.getModel().getEdgeCount(AbstractDfsController.this.activeVariable); ++i) {
                mxCell mxCell2 = (mxCell)AbstractDfsController.this.graph.getModel().getEdgeAt(AbstractDfsController.this.activeVariable, i);
                mxCell mxCell3 = (mxCell)mxCell2.getTarget();
                mxCell mxCell4 = (mxCell)mxCell2.getSource();
                DfsGraphVertex dfsGraphVertex = (DfsGraphVertex)mxCell3.getValue();
                DfsGraphVertex dfsGraphVertex2 = (DfsGraphVertex)mxCell4.getValue();
                DfsGraphEdge dfsGraphEdge = (DfsGraphEdge)mxCell2.getValue();
                if (dfsGraphEdge.getEdgeType() == DfsGraphEdge.DfsEdgeType.NOTHING) {
                    if ((mxCell3 != AbstractDfsController.this.activeVariable || mxCell4 != AbstractDfsController.this.registers[this.registerNum]) && (AbstractDfsController.this.graph.isOriented() || mxCell4 != AbstractDfsController.this.activeVariable || mxCell3 != AbstractDfsController.this.registers[this.registerNum])) continue;
                    if (!AbstractDfsController.this.graph.isOriented() && (dfsGraphVertex2.getNodePath() != null && dfsGraphVertex2.getNodePath().getName().equals(dfsGraphVertex.getName()) || dfsGraphVertex.getNodePath() != null && dfsGraphVertex2.getName().equals(dfsGraphVertex.getNodePath().getName()))) {
                        AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(mxCell2, this.pathEdgeStyle));
                        continue;
                    }
                    DfsGraphEdge.DfsEdgeType dfsEdgeType = DfsGraphEdge.DfsEdgeType.getType(mxCell2, this.pathEdgeStyle);
                    AbstractDfsController.this.editBlock.addEdit(new SetDfsEdgeTypeEdit(dfsGraphEdge, dfsEdgeType));
                    if (dfsEdgeType == DfsGraphEdge.DfsEdgeType.NOTHING) continue;
                    AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(mxCell2, this.edgeStyle));
                    continue;
                }
                AbstractDfsController.this.editBlock.addEdit(new AbstractController.ChangeEdgeStyleEdit(mxCell2, this.edgeStyle));
            }
        }
    }

    protected final class SetPathEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected DfsGraphVertex graphNode;
        protected DfsGraphVertex newPath;
        protected DfsGraphVertex oldPath;

        public SetPathEdit(mxCell mxCell2, mxCell mxCell3) {
            this.graphNode = (DfsGraphVertex)mxCell2.getValue();
            this.oldPath = this.graphNode.getNodePath();
            this.newPath = mxCell3 != null ? (DfsGraphVertex)mxCell3.getValue() : null;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setNodePath(this.oldPath);
        }

        @Override
        protected void action() {
            this.graphNode.setNodePath(this.newPath);
        }
    }

    protected class SetPathInstruction
    extends AbstractController.BasicInstruction {
        protected Integer regNum = null;

        public SetPathInstruction() {
        }

        public SetPathInstruction(int n) {
            this.regNum = n;
        }

        @Override
        public void preform() {
            if (this.regNum != null) {
                AbstractDfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractDfsController.this.activeVariable, (mxCell)AbstractDfsController.this.getRegisterValue(this.regNum)));
            } else {
                AbstractDfsController.this.editBlock.addEdit(new SetPathEdit((mxCell)AbstractDfsController.this.activeVariable, null));
            }
        }
    }

    protected final class ContextEditSave
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<ContextObject> stack;
        protected ContextObject context;
        protected ContextObject actualContext;

        public ContextEditSave(Deque<ContextObject> deque, AbstractController.Instruction instruction) {
            this.stack = deque;
            this.context = AbstractDfsController.this.getContext(instruction);
            this.actualContext = AbstractDfsController.this.getContext(null);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.stack.remove(this.context);
            int n = AbstractDfsController.this.tapePosition;
            this.actualContext.restoreContext();
            AbstractDfsController.this.tapePosition = n;
        }

        @Override
        protected void action() {
            this.stack.push(this.context);
        }
    }

    protected final class ContextEditRestore
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<ContextObject> stack;
        protected ContextObject context;

        public ContextEditRestore(Deque<ContextObject> deque) {
            this.stack = deque;
            this.context = deque.getFirst();
            this.context.restoreContext();
            deque.remove(this.context);
        }

        @Override
        public void undo() {
            super.undo();
            this.stack.push(this.context);
        }

        @Override
        protected void action() {
            int n = AbstractDfsController.this.tapePosition;
            this.context.restoreContext();
            AbstractDfsController.this.tapePosition = n;
            this.stack.remove(this.context);
        }
    }

    protected class ContextInstruction
    extends AbstractController.BasicInstruction {
        protected Deque<ContextObject> stack;
        protected AbstractController.Instruction next;

        public ContextInstruction(Deque<ContextObject> deque) {
            this(deque, null);
        }

        public ContextInstruction(Deque<ContextObject> deque, AbstractController.Instruction instruction) {
            this.stack = deque;
            this.next = instruction;
        }

        @Override
        public void preform() {
            if (this.next != null) {
                AbstractDfsController.this.editBlock.addEdit(new ContextEditSave(this.stack, this.next));
            } else {
                AbstractDfsController.this.editBlock.addEdit(new ContextEditRestore(this.stack));
            }
        }
    }

    protected class EnableEdgesTypeInstruction
    extends AbstractController.BasicInstruction {
        protected EnableEdgesTypeInstruction() {
        }

        @Override
        public void preform() {
            AbstractDfsController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (mxCell2.isEdge()) {
                        ((DfsGraphEdge)mxCell2.getValue()).setEnabled(true);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class DfsContextObject
    implements ContextObject {
        protected Deque<mxCell> vList = new LinkedList<mxCell>();
        protected mxCell vU;
        protected mxCell vV;
        protected mxCell activeV;
        protected AbstractController.Instruction nextIns;
        protected int tapeIndex;

        public DfsContextObject(AbstractController.Instruction instruction) {
            this.nextIns = instruction;
            this.vU = (mxCell)AbstractDfsController.this.getRegisterValue(AbstractDfsController.this.variableU);
            this.vV = (mxCell)AbstractDfsController.this.getRegisterValue(AbstractDfsController.this.variableV);
            this.activeV = (mxCell)AbstractDfsController.this.activeVariable;
            this.vList.addAll(AbstractDfsController.this.vertexList);
            this.tapeIndex = AbstractDfsController.this.tapePosition;
        }

        @Override
        public void restoreContext() {
            AbstractDfsController.this.setRegisterValue(this.vU, AbstractDfsController.this.variableU);
            AbstractDfsController.this.setRegisterValue(this.vV, AbstractDfsController.this.variableV);
            AbstractDfsController.this.activeVariable = this.activeV;
            AbstractDfsController.this.vertexList.clear();
            AbstractDfsController.this.vertexList.addAll(this.vList);
            if (this.nextIns != null) {
                new AbstractController.SetTapePositionInstruction(AbstractDfsController.this.tape.indexOf(this.nextIns)).preform();
            } else {
                AbstractDfsController.this.tapePosition = this.tapeIndex;
            }
        }

        @Override
        public AbstractController.Instruction getNextIns() {
            return this.nextIns;
        }
    }

    protected static interface ContextObject {
        public void restoreContext();

        public AbstractController.Instruction getNextIns();
    }
}

